/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.optionpane;

import com.nepxion.swing.button.ButtonFocusListener;
import com.nepxion.swing.dialog.DialogResizer;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.validation.IValidation;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class JBasicOptionPane
extends JOptionPane {
    public JBasicOptionPane() {
    }

    public JBasicOptionPane(Object message) {
        super(message);
    }

    public JBasicOptionPane(Object message, int messageType) {
        super(message, messageType);
    }

    public JBasicOptionPane(Object message, int messageType, int optionType) {
        super(message, messageType, optionType);
    }

    public JBasicOptionPane(Object message, int messageType, int optionType, Icon icon) {
        super(message, messageType, optionType, icon);
    }

    public JBasicOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
        super(message, messageType, optionType, icon, options);
    }

    public JBasicOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        super(message, messageType, optionType, icon, options, initialValue);
    }

    public static int showDialog(Component parentComponent, Object message, String title) {
        return JBasicOptionPane.showDialog(parentComponent, message, title, null);
    }

    public static int showDialog(Component parentComponent, Object message, String title, Icon icon) {
        return JBasicOptionPane.showDialog(parentComponent, message, title, icon, false);
    }

    public static int showDialog(Component parentComponent, Object message, String title, boolean resizable) {
        return JBasicOptionPane.showDialog(parentComponent, message, title, null, resizable);
    }

    public static int showDialog(Component parentComponent, Object message, String title, Icon icon, boolean resizable) {
        return JBasicOptionPane.showDialog(parentComponent, message, title, icon, new Object[]{SwingLocale.getString("yes"), SwingLocale.getString("no")}, resizable);
    }

    public static int showDialog(Component parentComponent, Object message, String title, Icon icon, Object[] options) {
        return JBasicOptionPane.showDialog(parentComponent, message, title, icon, options, false);
    }

    public static int showDialog(Component parentComponent, Object message, String title, Icon icon, Object[] options, boolean resizable) {
        return JBasicOptionPane.showDialog(parentComponent, message, title, -1, -1, icon, options, null, resizable);
    }

    public static int showDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean resizable) {
        int selectedValue = JBasicOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue, resizable);
        return JBasicOptionPane.showDialog(selectedValue, parentComponent, message, title, optionType, messageType, icon, options, initialValue, resizable);
    }

    private static int showDialog(int selectedValue, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean resizable) {
        IValidation validation;
        if (selectedValue != 0) {
            return selectedValue;
        }
        if (message instanceof IValidation && !(validation = (IValidation)message).verify()) {
            selectedValue = JBasicOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue, resizable);
            return JBasicOptionPane.showDialog(selectedValue, parentComponent, message, title, optionType, messageType, icon, options, initialValue, resizable);
        }
        return selectedValue;
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, boolean resizable) throws HeadlessException {
        JBasicOptionPane pane = new JBasicOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JBasicOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        JDialog dialog = pane.createDialog(parentComponent, title, resizable);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static String showInputDialog(Object message) throws HeadlessException {
        return JBasicOptionPane.showInputDialog(null, message);
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        return JBasicOptionPane.showInputDialog(null, message, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message) throws HeadlessException {
        return JBasicOptionPane.showInputDialog(parentComponent, message, JBasicOptionPane.getString("OptionPane.inputDialogTitle", parentComponent), 3);
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return (String)JBasicOptionPane.showInputDialog(parentComponent, message, JBasicOptionPane.getString("OptionPane.inputDialogTitle", parentComponent), 3, null, null, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return (String)JBasicOptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        return (String)JBasicOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue, false);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue, boolean resizable) throws HeadlessException {
        JBasicOptionPane pane = new JBasicOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation((parentComponent == null ? JBasicOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        JDialog dialog = pane.createDialog(parentComponent, title, resizable);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public static void showMessageDialog(Component parentComponent, Object message) throws HeadlessException {
        JBasicOptionPane.showMessageDialog(parentComponent, message, JBasicOptionPane.getString("OptionPane.messageDialogTitle", parentComponent), 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        JBasicOptionPane.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) throws HeadlessException {
        JBasicOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null, false);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return JBasicOptionPane.showConfirmDialog(parentComponent, message, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return JBasicOptionPane.showConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JBasicOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return JBasicOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, null, false);
    }

    public JDialog createDialog(Component parentComponent, String title, boolean resizable) throws HeadlessException {
        JDialog dialog = this.createDialog(parentComponent, title);
        if (resizable) {
            dialog.setResizable(true);
            dialog.addComponentListener(new DialogResizer(dialog.getSize(), dialog.getSize(), null));
        }
        Container container = (Container)this.getComponent(this.getComponentCount() - 1);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof JButton)) continue;
            JButton button = (JButton)component;
            button.addFocusListener(new ButtonFocusListener(this));
        }
        return dialog;
    }

    public static String getString(Object key, Component c) {
        Locale l = c == null ? Locale.getDefault() : c.getLocale();
        return UIManager.getString(key, l);
    }
}

