/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart;

import com.nepxion.swing.chart.JChartPanel;
import com.nepxion.swing.color.ColorUtil;
import com.nepxion.swing.font.FontContext;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import org.jfree.chart.ChartColor;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public class JChartFactory {
    public static final Paint[] CHART_PAINT_LIST = ChartColor.createDefaultPaintArray();

    public static JChartPanel createChartPanel(JFreeChart chart) {
        JChartPanel chartPanel = new JChartPanel(chart);
        return chartPanel;
    }

    public static JFreeChart createChart(String title, String subTitle, Plot plot) {
        JFreeChart chart = new JFreeChart(plot);
        chart.setTitle(new TextTitle(title));
        chart.addSubtitle((Title)new TextTitle(subTitle));
        JChartFactory.setChartPreference(chart);
        return chart;
    }

    public static void setChartPreference(JFreeChart chart) {
        block7: {
            int i;
            Plot plot;
            block9: {
                int i2;
                block8: {
                    chart.setBackgroundPaint((Paint)Color.white);
                    LegendTitle legendTitle = chart.getLegend();
                    legendTitle.setBackgroundPaint((Paint)new Color(128, 128, 128, 30));
                    legendTitle.setMargin(new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 5.0));
                    legendTitle.setPosition(RectangleEdge.BOTTOM);
                    chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    TextTitle textTitle = chart.getTitle();
                    if (textTitle != null) {
                        textTitle.setFont(FontContext.getChartTitleFont());
                    }
                    for (int i3 = 0; i3 < chart.getSubtitleCount(); ++i3) {
                        Title subTitle = chart.getSubtitle(i3);
                        if (!(subTitle instanceof TextTitle)) continue;
                        TextTitle subTextTitle = (TextTitle)subTitle;
                        subTextTitle.setFont(FontContext.getChartSubTitleFont());
                    }
                    if (legendTitle != null) {
                        legendTitle.setItemFont(FontContext.getChartLabelFont());
                    }
                    if ((plot = chart.getPlot()) == null) break block7;
                    if (!(plot instanceof PiePlot)) break block8;
                    PiePlot piePlot = (PiePlot)plot;
                    piePlot.setLabelFont(FontContext.getChartLabelFont());
                    piePlot.setNoDataMessageFont(FontContext.getChartLabelFont());
                    break block7;
                }
                if (!(plot instanceof CategoryPlot)) break block9;
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                for (i2 = 0; i2 < categoryPlot.getDomainAxisCount(); ++i2) {
                    CategoryAxis domainAxis = categoryPlot.getDomainAxis(i2);
                    if (domainAxis == null) continue;
                    domainAxis.setLabelFont(FontContext.getChartLabelFont());
                    domainAxis.setTickLabelFont(FontContext.getChartTickLabelFont());
                }
                for (i2 = 0; i2 < categoryPlot.getRangeAxisCount(); ++i2) {
                    ValueAxis rangeAxis = categoryPlot.getRangeAxis(i2);
                    if (rangeAxis == null) continue;
                    rangeAxis.setLabelFont(FontContext.getChartLabelFont());
                    rangeAxis.setTickLabelFont(FontContext.getChartTickLabelFont());
                }
                break block7;
            }
            if (!(plot instanceof XYPlot)) break block7;
            XYPlot xyPlot = (XYPlot)plot;
            for (i = 0; i < xyPlot.getDomainAxisCount(); ++i) {
                ValueAxis domainAxis = xyPlot.getDomainAxis(i);
                if (domainAxis == null) continue;
                domainAxis.setLabelFont(FontContext.getChartLabelFont());
                domainAxis.setTickLabelFont(FontContext.getChartTickLabelFont());
            }
            for (i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
                ValueAxis rangeAxis = xyPlot.getRangeAxis(i);
                if (rangeAxis == null) continue;
                rangeAxis.setLabelFont(FontContext.getChartLabelFont());
                rangeAxis.setTickLabelFont(FontContext.getChartTickLabelFont());
            }
        }
    }

    public static void fixRange(ValueAxis rangeAxis, double lowerFixedPercent, double upperFixedPercent) {
        Range range = rangeAxis.getRange();
        double lowerFixedValue = range.getLowerBound() * (1.0 + lowerFixedPercent);
        double upperFixedValue = range.getUpperBound() * (1.0 + upperFixedPercent);
        rangeAxis.setRange(new Range(lowerFixedValue, upperFixedValue));
    }

    public static Paint getPaint(int index) {
        Paint[] chartPaintList = CHART_PAINT_LIST;
        Paint paint = null;
        switch (index) {
            case 0: {
                paint = Color.red;
                break;
            }
            case 1: {
                paint = Color.green;
                break;
            }
            case 2: {
                paint = Color.blue;
                break;
            }
            default: {
                paint = index < chartPaintList.length ? chartPaintList[index] : ColorUtil.getRandomColor();
            }
        }
        return paint;
    }

    public static Paint getGradientPaint(int index) {
        return JChartFactory.getGradientPaint(index, true);
    }

    public static Paint getGradientPaint(int index, boolean isAsc) {
        Color color1 = (Color)JChartFactory.getPaint(index);
        Color color2 = null;
        color2 = color1 == Color.red ? new Color(64, 0, 0) : (color1 == Color.green ? new Color(0, 64, 0) : (color1 == Color.blue ? new Color(0, 0, 64) : new Color(0, 0, 0)));
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, isAsc ? color2 : color1, 0.0f, 0.0f, isAsc ? color1 : color2);
        return paint;
    }
}

