/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.awt.Dimension;
import y.algo.AlgorithmAbortedException;
import y.base.WrongGraphStructure;
import y.layout.BufferedLayouter;
import y.layout.CanonicMultiStageLayouter;
import y.layout.ComponentLayouter;
import y.layout.GraphLayout;
import y.layout.Layouter;
import y.module.YModule;
import y.util.D;
import y.view.Graph2D;
import y.view.LayoutMorpher;
import y.view.Selections;

public abstract class LayoutModule
extends YModule {
    private boolean ae = true;
    private boolean ad = true;

    public LayoutModule(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    protected void launchLayouter(Layouter layouter) {
        this.launchLayouter(layouter, this.ae);
    }

    protected void launchLayouter(Layouter layouter, boolean bl) {
        Object object;
        if (this.getGraph2DView() == null) {
            this.a(layouter);
            return;
        }
        Graph2D graph2D = this.getGraph2D();
        graph2D.addDataProvider(Layouter.SELECTED_NODES, Selections.createSelectionNodeMap(graph2D));
        graph2D.addDataProvider(Layouter.SELECTED_EDGES, Selections.createSelectionEdgeMap(graph2D));
        if (layouter instanceof CanonicMultiStageLayouter) {
            object = (CanonicMultiStageLayouter)layouter;
            Dimension dimension = this.getGraph2DView().getSize();
            if (((CanonicMultiStageLayouter)object).getComponentLayouter() instanceof ComponentLayouter) {
                ComponentLayouter componentLayouter = (ComponentLayouter)((CanonicMultiStageLayouter)object).getComponentLayouter();
                componentLayouter.setPreferredLayoutSize(dimension.getWidth(), dimension.getHeight());
                double d2 = this.getGraph2DView().getGridMode() ? this.getGraph2DView().getGridResolution() : 0.0;
                componentLayouter.setGridSpacing(0.0);
                if (d2 > 0.0) {
                    componentLayouter.setComponentSpacing(d2);
                } else {
                    componentLayouter.setComponentSpacing(45.0);
                }
            }
        }
        try {
            if (bl) {
                if (this.isMorphingEnabled()) {
                    object = new BufferedLayouter(layouter).calcLayout(graph2D);
                    new LayoutMorpher(this.getGraph2DView(), (GraphLayout)object).execute();
                } else {
                    new BufferedLayouter(layouter).doLayout(graph2D);
                    graph2D.fitGraph2DView();
                }
            } else {
                layouter.doLayout(graph2D);
            }
        }
        catch (WrongGraphStructure wrongGraphStructure) {
            D.show(wrongGraphStructure);
        }
        catch (AlgorithmAbortedException algorithmAbortedException) {
            throw algorithmAbortedException;
        }
        catch (Exception exception) {
            D.show(exception);
        }
        this.getGraph2D().updateViews();
    }

    private void a(Layouter layouter) {
        Graph2D graph2D = this.getGraph2D();
        graph2D.addDataProvider(Layouter.SELECTED_NODES, Selections.createSelectionNodeMap(graph2D));
        graph2D.addDataProvider(Layouter.SELECTED_EDGES, Selections.createSelectionEdgeMap(graph2D));
        layouter.doLayout(graph2D);
    }

    public boolean isAbortable() {
        return true;
    }

    public void setBufferedMode(boolean bl) {
        this.ae = bl;
    }

    public boolean getBufferedMode() {
        return this.ae;
    }

    public boolean isMorphingEnabled() {
        return this.ad;
    }

    public void setMorphingEnabled(boolean bl) {
        this.ad = bl;
    }
}

