/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.util.Arrays;
import java.util.Comparator;
import y.algo.Trees;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.base.YCursor;
import y.base.YList;
import y.base.if;
import y.geom.Geom;
import y.geom.YPoint;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.util.D;

public class BalloonLayouter
extends CanonicMultiStageLayouter {
    public static final byte DIRECTED_ROOT = 0;
    public static final byte CENTER_ROOT = 1;
    public static final byte WEIGHTED_CENTER_ROOT = 2;
    private double kl = 340.0;
    private double km = 360.0;
    private double kk = 40.0;
    private boolean kj = false;
    private double ko = 0.5;
    private byte ki = 0;
    private NodeInfo[] kn;
    protected LayoutGraph graph;

    public void setRootNodePolicy(byte by) {
        this.ki = by;
    }

    public byte getRootNodePolicy() {
        return this.ki;
    }

    public void setPreferredChildWedge(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > 359) {
            n = 359;
        }
        this.kl = n;
    }

    public void setPreferredRootWedge(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > 359) {
            n = 359;
        }
        this.km = n;
    }

    public int getPreferredRootWedge() {
        return (int)this.km;
    }

    public int getPreferredChildWedge() {
        return (int)this.kl;
    }

    public void setAllowOverlaps(boolean bl) {
        this.kj = bl;
    }

    public boolean getAllowOverlaps() {
        return this.kj;
    }

    public void setCompactnessFactor(double d2) {
        if (d2 <= 0.0) {
            d2 = 0.05;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        this.ko = d2;
    }

    public double getCompactnessFactor() {
        return this.ko;
    }

    public void setMinimalEdgeLength(int n) {
        this.kk = n;
    }

    public int getMinimalEdgeLength() {
        return (int)this.kk;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        if if_;
        if (!Trees.isTree(layoutGraph)) {
            throw new WrongGraphStructure("Graph is not a tree");
        }
        this.graph = layoutGraph;
        Node node = this.determineRoot();
        EdgeList edgeList = Trees.directTree(layoutGraph, node);
        LayoutTool.resetPaths(layoutGraph);
        this.kn = new NodeInfo[layoutGraph.nodeCount()];
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            if_ = nodeCursor.node();
            if (if_ != node) {
                this.a((Node)if_, new NodeInfo(this.kk + this.q(if_.predecessors().node())));
            } else {
                this.a((Node)if_, new NodeInfo(this.kk));
            }
            nodeCursor.next();
        }
        this.s(node);
        layoutGraph.setCenter(node, 0.0, 0.0);
        this.t(node);
        while (!edgeList.isEmpty()) {
            if_ = edgeList.popEdge();
            layoutGraph.reverseEdge((Edge)if_);
        }
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return Trees.isTree(layoutGraph);
    }

    protected NodeInfo getInfo(Node node) {
        return this.kn[node.index()];
    }

    protected Node determineRoot() {
        switch (this.ki) {
            case 2: {
                return Trees.getWeightedCenterNode(this.graph);
            }
            case 1: {
                return Trees.getCenterRoot(this.graph);
            }
        }
        return Trees.getRoot(this.graph);
    }

    protected void calcChildArrangement(Node node) {
        Object object;
        double d2;
        double d3 = this.getPreferredChildWedge(node);
        while ((d2 = this.calcAngles(node)) > d3) {
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                Node node2 = nodeCursor.node();
                object = this.getInfo(node2);
                this.getInfo((Node)node2).dist *= 1.0 + this.ko;
                nodeCursor.next();
            }
        }
        double d4 = (d3 - d2) / (double)(2 * node.outDegree());
        d2 = 0.0;
        object = node.successors();
        while (object.ok()) {
            NodeInfo nodeInfo = this.getInfo(object.node());
            nodeInfo.upperAngle += d4;
            nodeInfo.lowerAngle += d4;
            d2 += nodeInfo.upperAngle + nodeInfo.lowerAngle;
            object.next();
        }
        this.sortChildNodes(node);
    }

    protected void sortChildNodes(Node node) {
        Edge[] edgeArray = new Edge[node.outDegree()];
        int n = 0;
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            edgeArray[n] = edgeCursor.edge();
            edgeCursor.next();
            ++n;
        }
        Arrays.sort(edgeArray, new _a());
        int n2 = 0;
        while (n2 < edgeArray.length) {
            this.graph.hide(edgeArray[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < edgeArray.length) {
            this.graph.unhide(edgeArray[n3]);
            n3 += 2;
        }
        n = edgeArray.length - 1;
        if (n % 2 == 0) {
            --n;
        }
        while (n > 0) {
            this.graph.unhide(edgeArray[n]);
            n -= 2;
        }
    }

    protected double getPreferredChildWedge(Node node) {
        if (node.inDegree() == 0) {
            return this.km;
        }
        if (node.outDegree() == 2) {
            return Math.min(180.0, this.kl);
        }
        return this.kl;
    }

    protected double calcAngles(Node node) {
        double d2 = 0.0;
        double d3 = this.q(node);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            NodeInfo nodeInfo = this.getInfo(node2);
            double d4 = -nodeInfo.dist;
            double d5 = nodeInfo.b;
            YList yList = nodeInfo.c;
            double d6 = 0.0;
            double d7 = d6 + 1.0;
            ListCell listCell = yList.firstCell();
            YPoint yPoint = (YPoint)listCell.getInfo();
            YPoint yPoint2 = null;
            while (d7 > d6) {
                yPoint2 = yPoint;
                listCell = yList.cyclicPred(listCell);
                yPoint = (YPoint)listCell.getInfo();
                d6 = (yPoint.getY() - yPoint2.getY()) / (yPoint.getX() - yPoint2.getX());
                d7 = (yPoint2.getY() - d5) / (yPoint2.getX() - d4);
            }
            nodeInfo.upperAngle = -Math.toDegrees(Math.atan(d7));
            d6 = 0.0;
            d7 = d6 - 1.0;
            listCell = yList.firstCell();
            yPoint = (YPoint)listCell.getInfo();
            while (((YPoint)listCell.succ().getInfo()).getX() == yPoint.getX()) {
                listCell = listCell.succ();
                yPoint = (YPoint)listCell.getInfo();
            }
            while (d7 < d6) {
                yPoint2 = yPoint;
                listCell = yList.cyclicSucc(listCell);
                yPoint = (YPoint)listCell.getInfo();
                d6 = (yPoint.getY() - yPoint2.getY()) / (yPoint.getX() - yPoint2.getX());
                d7 = (yPoint2.getY() - d5) / (yPoint2.getX() - d4);
            }
            nodeInfo.lowerAngle = Math.toDegrees(Math.atan(d7));
            d2 += nodeInfo.upperAngle + nodeInfo.lowerAngle;
            edgeCursor.next();
        }
        return d2;
    }

    void a(Node node, NodeInfo nodeInfo) {
        this.kn[node.index()] = nodeInfo;
    }

    void p(Node node) {
        NodeInfo nodeInfo = this.getInfo(node);
        YList yList = new YList();
        double d2 = 2.0 * this.q(node);
        yList.add(new YPoint(0.0, 0.0));
        yList.add(new YPoint(0.0, d2));
        yList.add(new YPoint(d2, d2));
        yList.add(new YPoint(d2, 0.0));
        nodeInfo.c = yList;
        nodeInfo.a = d2 / 2.0;
        nodeInfo.b = d2 / 2.0;
    }

    void r(Node node) {
        if (node.outDegree() == 0) {
            this.p(node);
        } else {
            Object object;
            NodeInfo nodeInfo = this.getInfo(node);
            double d2 = this.q(node);
            YList yList = new YList();
            yList.add(new YPoint(-d2, -d2));
            yList.add(new YPoint(-d2, d2));
            yList.add(new YPoint(d2, -d2));
            yList.add(new YPoint(d2, d2));
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                object = this.getInfo(nodeCursor.node());
                yList.splice(((NodeInfo)object).c);
                nodeCursor.next();
            }
            object = Geom.calcConvexHull(yList);
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            double d5 = -1.7976931348623157E308;
            double d6 = -1.7976931348623157E308;
            YCursor yCursor = ((YList)object).cursor();
            while (yCursor.ok()) {
                YPoint yPoint = (YPoint)yCursor.current();
                if (yPoint.getX() < d3) {
                    d3 = yPoint.getX();
                }
                if (yPoint.getX() > d5) {
                    d5 = yPoint.getX();
                }
                if (yPoint.getY() < d4) {
                    d4 = yPoint.getY();
                }
                if (yPoint.getY() > d6) {
                    d6 = yPoint.getY();
                }
                yCursor.next();
            }
            double d7 = d5 - d3;
            double d8 = d6 - d4;
            YList yList2 = new YList();
            YCursor yCursor2 = ((YList)object).cursor();
            while (yCursor2.ok()) {
                YPoint yPoint = (YPoint)yCursor2.current();
                yList2.add(new YPoint(yPoint.getX() - d3, yPoint.getY() - d4));
                yCursor2.next();
            }
            nodeInfo.c = yList2;
            nodeInfo.a = -d3;
            nodeInfo.b = -d4;
        }
    }

    void s(Node node) {
        if (node.outDegree() == 0) {
            this.r(node);
        } else {
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                this.s(nodeCursor.node());
                nodeCursor.next();
            }
            this.calcChildArrangement(node);
            double d2 = 0.0;
            NodeCursor nodeCursor2 = node.successors();
            while (nodeCursor2.ok()) {
                double d3;
                double d4;
                Node node2 = nodeCursor2.node();
                NodeInfo nodeInfo = this.getInfo(node2);
                double d5 = 180.0 - (360.0 - this.getPreferredChildWedge(node)) / 2.0 - d2 - (nodeInfo.lowerAngle + nodeInfo.gapAngle);
                d2 += nodeInfo.getAngleSum();
                d5 = Math.toRadians(d5);
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                ListCell listCell = nodeInfo.c.firstCell();
                while (listCell != null) {
                    YPoint yPoint = (YPoint)listCell.getInfo();
                    d4 = yPoint.getX() + nodeInfo.dist;
                    d3 = yPoint.getY() - nodeInfo.b;
                    YPoint yPoint2 = new YPoint(d4 * d7 - d6 * d3, d4 * d6 + d7 * d3);
                    listCell.setInfo(yPoint2);
                    listCell = listCell.succ();
                }
                d4 = nodeInfo.a + nodeInfo.dist;
                d3 = 0.0;
                nodeInfo.a = d4 * d7;
                nodeInfo.b = d4 * d6;
                nodeCursor2.next();
            }
            this.r(node);
        }
    }

    void t(Node node) {
        Object object;
        Object object2;
        YPoint yPoint = this.graph.getCenter(node);
        double d2 = 0.0;
        if (node.inDegree() > 0) {
            object2 = node.predecessors().node();
            object = this.graph.getCenter((Node)object2);
            d2 = Math.PI + Math.atan2(((YPoint)object).getY() - yPoint.getY(), ((YPoint)object).getX() - yPoint.getX());
        }
        object2 = node.successors();
        while (object2.ok()) {
            object = object2.node();
            NodeInfo nodeInfo = this.getInfo((Node)object);
            if (d2 != 0.0) {
                double d3 = Math.cos(d2);
                double d4 = Math.sin(d2);
                double d5 = nodeInfo.a * d3 - d4 * nodeInfo.b;
                double d6 = nodeInfo.a * d4 + d3 * nodeInfo.b;
                nodeInfo.a = d5;
                nodeInfo.b = d6;
            }
            this.graph.setCenter((Node)object, yPoint.getX() + nodeInfo.a, yPoint.getY() + nodeInfo.b);
            this.t((Node)object);
            object2.next();
        }
    }

    double q(Node node) {
        if (this.kj) {
            return (this.graph.getWidth(node) + this.graph.getHeight(node)) / 4.0;
        }
        return 1.41 * (Math.max(this.graph.getWidth(node), this.graph.getHeight(node)) / 2.0);
    }

    void b(Graph graph, Object object, EdgeMap edgeMap, NodeMap nodeMap) {
        D.bug(object);
        D.bug("nodes: " + graph.nodeCount());
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            D.bug(node + " inAngle: " + nodeMap.get(node));
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                Node node2 = edge.target();
                D.bug(" >edge to " + node2 + " outAngle: " + edgeMap.get(edge));
                edgeCursor.next();
            }
            nodeCursor.next();
        }
    }

    class _a
    implements Comparator {
        _a() {
        }

        public int compare(Object object, Object object2) {
            Node node = ((Edge)object).target();
            Node node2 = ((Edge)object2).target();
            double d2 = BalloonLayouter.this.getInfo(node).getAngleSum() - BalloonLayouter.this.getInfo(node2).getAngleSum();
            if (d2 > 0.0) {
                return 1;
            }
            if (d2 < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    public static class NodeInfo {
        YList c;
        public double upperAngle;
        public double lowerAngle;
        public double gapAngle;
        public double dist;
        double a;
        double b;

        NodeInfo(double d2) {
            this.dist = d2;
            this.c = new YList();
        }

        public double getAngleSum() {
            return this.upperAngle + this.lowerAngle + this.gapAngle;
        }
    }
}

