/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.E.a;
import twaver.chart.AbstractChart;
import twaver.chart.C;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGPercentChart;
import twaver.web.svg.network.SVGContext;

public class PercentChart
extends AbstractChart {
    private int \u0542 = TUIManager.getInt("tchart.percent.gap");
    private int \u0535 = TUIManager.getInt("tchart.thickness");
    private int \u053e = TUIManager.getInt("tchart.segment.count");
    private Color \u0537 = TUIManager.getColor("tchart.percent.label.color");
    private Font \u053d = TUIManager.getFont("tchart.percent.label.font");
    private boolean \u0538 = TUIManager.getBoolean("tchart.percent.label.visible");
    private boolean \u0539 = TUIManager.getBoolean("tchart.percent.label.center");
    private boolean \u0541 = TUIManager.getBoolean("tchart.percent.spare.fill");
    private Color \u053b = TUIManager.getColor("tchart.spare.color");
    private Color \u053c = TUIManager.getColor("tchart.percent.spare.gradient.color");
    private Color \u0543 = TUIManager.getColor("tchart.outline.color");
    private int \u0536 = TUIManager.getInt("tchart.percent.type");
    private int \u053f = TUIManager.getInt("tchart.percent.marker.start.position");
    private double \u053a = TUIManager.getDouble("tchart.segment.section.prorate");
    private int \u0540 = TUIManager.getInt("tchart.percent.marker.position");
    public static final JLabel renderer = new JLabel(){
        {
            this.setOpaque(false);
            this.setDoubleBuffered(false);
        }
    };

    public PercentChart() {
        this(new TDataBox());
    }

    public PercentChart(TDataBox box) {
        this(box, null, null);
    }

    public PercentChart(TDataBox box, String title, Color backgroundColor) {
        this(box, title, backgroundColor, null);
    }

    public PercentChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
        this.init();
    }

    public PercentChart(List items) {
        this(items, null);
    }

    public PercentChart(List items, String title) {
        this(items, title, null);
    }

    public PercentChart(List items, String title, Color backgroundColor) {
        this(items, title, backgroundColor, null);
    }

    public PercentChart(List items, String title, Color backgroundColor, Color foregroundColor) {
        super(items, title, backgroundColor, foregroundColor);
        this.init();
    }

    protected void init() {
        if (this.selectedColor == null) {
            this.selectedColor = TWaverConst.COLOR_DARK;
        }
        this.legendPane.setVisible(false);
        this.setXGap(1);
        this.setYGap(1);
    }

    protected void calculate() {
    }

    public void paintChart(Graphics2D g2, int width, int height) {
        this.backgroundBounds.x = this.xGap;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = width - 2 * this.xGap;
        this.backgroundBounds.height = height - 2 * this.yGap;
        this.paintBackground(g2);
        int count = this.publishedElements.size();
        if (count == 0) {
            return;
        }
        if (this.\u0536 == 2) {
            this.H(g2, width, height);
        } else if (this.\u0536 == 1) {
            this.G(g2, width, height);
        }
    }

    private void H(Graphics2D g2, int width, int height) {
        Element element;
        int i2;
        int count = this.publishedElements.size();
        int span = (int)this.getSpanSize(width - 2 * this.xGap);
        if (span < 4) {
            span = 4;
        }
        int thick = this.\u0535 > span - 4 ? span - 4 : this.\u0535;
        int lableHeight = 0;
        if (this.\u0538 && !this.\u0539) {
            renderer.setFont(this.\u053d);
            renderer.setForeground(this.\u0537);
            for (i2 = 0; i2 < count; ++i2) {
                element = (Element)this.publishedElements.get(i2);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                if (size.height <= lableHeight) continue;
                lableHeight = size.height;
            }
        }
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            double percent = this.F(element);
            Stroke stroke = this.getStroke(element);
            int x = this.xGap + i2 * span + span / 2 - thick / 2;
            int y = height - this.yGap - this.\u0542 - lableHeight;
            int w = thick;
            int h2 = height - 2 * this.yGap - lableHeight - this.\u0542 * 2;
            if (this.\u0538 && !this.\u0539) {
                renderer.setFont(this.\u053d);
                renderer.setForeground(this.\u0537);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                int labelwidth = 0;
                labelwidth = size.width > span ? span : size.width;
                this.paintComponent(g2, renderer, x + w / 2 - labelwidth / 2, y, labelwidth, lableHeight);
            }
            Rectangle selectShape = new Rectangle(x - 1, y - h2 - 1, w + 2, h2 + 2);
            this.shapeStructs.add(0, new C(selectShape, element, this.getToolTipText(element)));
            boolean spareFill = this.getSpareFill(element);
            Color spareCoverColor = this.getSpareCoverColor(element);
            Color spareColorx = this.getSpareColor(element);
            Color color = this.getPercentColor(element);
            int percentStyle = element.getChartPercentStyle();
            Color gradientColor = this.getGradientColor(element);
            Color spareGradientColor = this.getSpareGradientColor(element);
            if (percentStyle == 2) {
                int r = w / 4;
                int solidy = y - r;
                int solidh = h2 - 2 * r;
                int length = (int)((double)solidh * percent);
                Ellipse2D.Float bottoms = new Ellipse2D.Float(x, solidy - r, w, r * 2);
                Ellipse2D.Float tops = new Ellipse2D.Float(x, solidy - solidh - r, w, r * 2);
                Ellipse2D.Float percents = new Ellipse2D.Float(x, solidy - length - r, w, r * 2);
                Rectangle rect = new Rectangle(x, solidy - solidh, w, solidh);
                Area area = new Area(rect);
                area.add(new Area(bottoms));
                area.add(new Area(tops));
                g2.setStroke(stroke);
                if (spareFill) {
                    if (this.gradient) {
                        g2.setPaint(new GradientPaint(x, solidy, spareColorx, x + w / 2, solidy, spareGradientColor, true));
                    } else {
                        g2.setColor(spareColorx);
                    }
                    g2.fill(area);
                    if (percent == 1.0) {
                        g2.setColor(color);
                    } else {
                        g2.setColor(spareCoverColor);
                    }
                    g2.fill(tops);
                    if (percent != 0.0) {
                        if (this.gradient) {
                            g2.setPaint(new GradientPaint(x, solidy, color, x + w / 2, solidy, gradientColor, true));
                        } else {
                            g2.setColor(color);
                        }
                        area = new Area(new Rectangle(x, solidy - length, w, length));
                        area.add(new Area(bottoms));
                        area.subtract(new Area(percents));
                        g2.fill(area);
                    }
                    g2.setColor(this.\u0543);
                    if (percent != 1.0) {
                        g2.draw(tops);
                    }
                } else {
                    if (percent != 0.0) {
                        if (this.gradient) {
                            g2.setPaint(new GradientPaint(x, solidy, color, x + w / 2, solidy, gradientColor, true));
                        } else {
                            g2.setColor(color);
                        }
                        area = new Area(new Rectangle(x, solidy - length, w, length));
                        area.add(new Area(bottoms));
                        area.add(new Area(percents));
                        g2.fill(area);
                        if (this.gradient) {
                            g2.setColor(color);
                            g2.fill(percents);
                        }
                        g2.setColor(color.darker());
                        g2.draw(percents);
                    }
                    g2.setColor(this.\u0543);
                    if (percent != 1.0) {
                        g2.draw(tops);
                    }
                }
                if (this.\u053f == 2) {
                    y -= r;
                    h2 -= 2 * r;
                }
                g2.setColor(this.\u0543);
                rect = new Rectangle(x, solidy - solidh, w, solidh);
                area = new Area(rect);
                area.add(new Area(tops));
                area.add(new Area(bottoms));
                g2.draw(area);
            } else if (percentStyle == 3) {
                Rectangle2D.Double rec;
                int k2;
                double divider = percent * (double)this.\u053e;
                double proportionGap = (double)h2 / ((double)(this.\u053e - 1) + this.\u053a);
                double valueGap = proportionGap * this.\u053a;
                if (this.gradient) {
                    g2.setPaint(new GradientPaint(x, y, spareColorx, x + w / 2, y, spareGradientColor, true));
                } else {
                    g2.setColor(spareColorx);
                }
                for (k2 = (int)divider; k2 < this.\u053e; ++k2) {
                    rec = new Rectangle2D.Double(x, (double)y - proportionGap * (double)k2 - valueGap, w, valueGap);
                    g2.fill(rec);
                }
                if (this.gradient) {
                    g2.setPaint(new GradientPaint(x, y, color, x + w / 2, y, gradientColor, true));
                } else {
                    g2.setColor(color);
                }
                k2 = 0;
                while ((double)k2 <= divider - 1.0) {
                    rec = new Rectangle2D.Double(x, (double)y - proportionGap * (double)k2 - valueGap, w, valueGap);
                    g2.fill(rec);
                    ++k2;
                }
                double startY = (double)y - proportionGap * (double)((int)divider) - valueGap * (divider % 1.0);
                Rectangle2D.Double rec2 = new Rectangle2D.Double(x, startY, w, valueGap * (divider % 1.0));
                g2.fill(rec2);
            } else {
                if (spareFill) {
                    if (this.gradient) {
                        g2.setPaint(new GradientPaint(x, y, spareColorx, x + w / 2, y, spareGradientColor, true));
                    } else {
                        g2.setColor(spareColorx);
                    }
                    g2.fillRect(x, y - h2, w, h2);
                }
                g2.setColor(this.\u0543);
                g2.setStroke(stroke);
                g2.drawRect(x, y - h2, w, h2);
                if (this.gradient) {
                    g2.setPaint(new GradientPaint(x, y, color, x + w / 2, y, gradientColor, true));
                } else {
                    g2.setColor(color);
                }
                g2.fillRect(x + 1, (int)((double)y - (double)h2 * percent), w - 1, (int)((double)h2 * percent + 1.0));
            }
            this.A(g2, x, y, w, h2, element);
            if (this.\u0538 && this.\u0539) {
                renderer.setFont(this.\u053d);
                renderer.setForeground(this.\u0537);
                renderer.setText(this.getPercentLabel(element));
                g2.translate(x + w / 2, y);
                g2.rotate(-1.5707963267948966);
                Dimension size = renderer.getPreferredSize();
                this.paintComponent(g2, renderer, h2 / 2 - size.width / 2, -size.height / 2, size.width, size.height);
                g2.rotate(1.5707963267948966);
                g2.translate(-(x + w / 2), -y);
            }
            if (!element.isSelected()) continue;
            g2.setStroke(this.getSelectedStroke(element));
            g2.setColor(this.getSelectedColor(element));
            g2.draw(selectShape);
        }
    }

    private void G(Graphics2D g2, int width, int height) {
        Element element;
        int i2;
        int count = this.publishedElements.size();
        int span = (int)this.getSpanSize(height - 2 * this.yGap);
        if (span < 4) {
            span = 4;
        }
        int thick = this.\u0535 > span - 4 ? span - 4 : this.\u0535;
        int maxLabelWidth = 0;
        if (this.\u0538 && !this.\u0539) {
            renderer.setFont(this.\u053d);
            renderer.setForeground(this.\u0537);
            for (i2 = 0; i2 < count; ++i2) {
                element = (Element)this.publishedElements.get(i2);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                this.paintComponent(g2, renderer, this.xGap + this.\u0542, this.yGap + i2 * span + span / 2 - size.height / 2, size.width, size.height);
                if (size.width + this.\u0542 <= maxLabelWidth) continue;
                maxLabelWidth = size.width + this.\u0542;
            }
        }
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            double percent = this.F(element);
            Stroke stroke = this.getStroke(element);
            int x = this.xGap + maxLabelWidth + this.\u0542;
            int y = this.yGap + i2 * span + span / 2 - thick / 2;
            int w = width - maxLabelWidth - 2 * this.xGap - this.\u0542 * 2;
            int h2 = thick;
            Rectangle selectShape = new Rectangle(x - 1, y - 1, w + 2, h2 + 2);
            this.shapeStructs.add(0, new C(selectShape, element, this.getToolTipText(element)));
            Color color = this.getPercentColor(element);
            int percentStyle = element.getChartPercentStyle();
            boolean spareFill = this.getSpareFill(element);
            Color spareCoverColor = this.getSpareCoverColor(element);
            Color spareColorx = this.getSpareColor(element);
            Color gradientColor = this.getGradientColor(element);
            Color spareGradientColor = this.getSpareGradientColor(element);
            if (percentStyle == 2) {
                int r = h2 / 4;
                int solidx = x + r;
                int solidw = w - 2 * r;
                int length = (int)((double)solidw * percent);
                Ellipse2D.Float sleft = new Ellipse2D.Float(solidx - r, y, r * 2, h2);
                Ellipse2D.Float spercent = new Ellipse2D.Float(solidx - r + length, y, r * 2, h2);
                Ellipse2D.Float sright = new Ellipse2D.Float(solidx - r + solidw, y, r * 2, h2);
                Rectangle rect = new Rectangle(solidx, y, length, h2);
                Area area = new Area(rect);
                area.add(new Area(sleft));
                area.add(new Area(spercent));
                g2.setStroke(stroke);
                if (spareFill) {
                    Rectangle wholeRect = new Rectangle(solidx, y, solidw, h2);
                    Area wholeArea = new Area(wholeRect);
                    wholeArea.add(new Area(sleft));
                    if (this.gradient) {
                        g2.setPaint(new GradientPaint(solidx, y, spareColorx, solidx, y + h2 / 2, spareGradientColor, true));
                    } else {
                        g2.setColor(spareColorx);
                    }
                    g2.fill(wholeArea);
                    if (percent == 1.0) {
                        g2.setColor(color);
                    } else {
                        g2.setColor(spareCoverColor);
                    }
                    g2.fill(sright);
                    if (percent != 0.0) {
                        if (this.gradient) {
                            g2.setPaint(new GradientPaint(solidx, y, color, solidx, y + h2 / 2, gradientColor, true));
                        } else {
                            g2.setColor(color);
                        }
                        area.subtract(new Area(spercent));
                        g2.fill(area);
                    }
                    g2.setColor(this.\u0543);
                    if (percent != 1.0) {
                        g2.draw(sright);
                    }
                } else {
                    if (percent != 0.0) {
                        if (this.gradient) {
                            g2.setPaint(new GradientPaint(solidx, y, color, solidx, y + h2 / 2, gradientColor, true));
                        } else {
                            g2.setColor(color);
                        }
                        g2.fill(area);
                        if (this.gradient) {
                            g2.setColor(color);
                            g2.fill(spercent);
                        }
                        g2.setColor(color.darker());
                        g2.draw(spercent);
                    }
                    g2.setColor(this.\u0543);
                    if (percent != 1.0) {
                        g2.draw(sright);
                    }
                }
                if (this.\u053f == 2) {
                    x += r;
                    w -= 2 * r;
                }
                g2.setColor(this.\u0543);
                rect = new Rectangle(solidx, y, solidw, h2);
                area = new Area(rect);
                area.add(new Area(sleft));
                area.add(new Area(sright));
                g2.draw(area);
            } else if (percentStyle == 3) {
                Rectangle2D.Double rec;
                int k2;
                double divider = percent * (double)this.\u053e;
                double proportionGap = (double)w / ((double)(this.\u053e - 1) + this.\u053a);
                double valueGap = proportionGap * this.\u053a;
                if (this.gradient) {
                    g2.setPaint(new GradientPaint(x, y, spareColorx, x, y + h2 / 2, spareGradientColor, true));
                } else {
                    g2.setColor(spareColorx);
                }
                for (k2 = (int)divider; k2 < this.\u053e; ++k2) {
                    rec = new Rectangle2D.Double((double)x + proportionGap * (double)k2, y, valueGap, h2);
                    g2.fill(rec);
                }
                if (this.gradient) {
                    g2.setPaint(new GradientPaint(x, y, color, x, y + h2 / 2, gradientColor, true));
                } else {
                    g2.setColor(color);
                }
                k2 = 0;
                while ((double)k2 <= divider - 1.0) {
                    rec = new Rectangle2D.Double((double)x + proportionGap * (double)k2, y, valueGap, h2);
                    g2.fill(rec);
                    ++k2;
                }
                double startX = (double)x + proportionGap * (double)((int)divider);
                Rectangle2D.Double rec2 = new Rectangle2D.Double(startX, y, valueGap * (divider % 1.0), h2);
                g2.fill(rec2);
            } else {
                if (spareFill) {
                    if (this.gradient) {
                        g2.setPaint(new GradientPaint(x, y, spareColorx, x, y + h2 / 2, spareGradientColor, true));
                    } else {
                        g2.setColor(spareColorx);
                    }
                    g2.fillRect(x, y, w, h2);
                }
                g2.setColor(this.\u0543);
                g2.setStroke(stroke);
                g2.drawRect(x, y, w, h2);
                if (this.gradient) {
                    g2.setPaint(new GradientPaint(x, y, color, x, y + h2 / 2, gradientColor, true));
                } else {
                    g2.setColor(color);
                }
                g2.fillRect(x + 1, y + 1, (int)((double)w * percent) - 1, h2 - 1);
            }
            this.A(g2, x, y, w, h2, element);
            if (this.\u0538 && this.\u0539) {
                renderer.setFont(this.\u053d);
                renderer.setForeground(this.\u0537);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                this.paintComponent(g2, renderer, x + w / 2 - size.width / 2, y + h2 / 2 - size.height / 2, size.width, size.height);
            }
            if (!element.isSelected()) continue;
            g2.setStroke(this.getSelectedStroke(element));
            g2.setColor(this.getSelectedColor(element));
            g2.draw(selectShape);
        }
    }

    protected double getSpanSize(double allSize) {
        return allSize / (double)this.publishedElements.size();
    }

    protected Color getSpareGradientColor(Element element) {
        return this.\u053c;
    }

    protected double getMarkerSize(Marker marker, int w, int h2) {
        if (this.\u0536 == 1) {
            return (double)h2 / 4.0;
        }
        return (double)w / 4.0;
    }

    private void A(Graphics2D g2, int x, int y, int w, int h2, Element element) {
        List markers = element.getChartMarkers();
        if (markers != null) {
            for (int k2 = 0; k2 < markers.size(); ++k2) {
                double offset;
                Point2D.Double point;
                double divider;
                double spaceGap;
                double valueGap;
                Marker marker = (Marker)markers.get(k2);
                double markerOffset = marker.getYOffset();
                double percent = this.B(marker, element);
                renderer.setFont(marker.getTextFont());
                renderer.setForeground(marker.getTextColor());
                renderer.setText(marker.getText());
                Dimension size = renderer.getPreferredSize();
                double lineLength = 0.0;
                Point2D.Double startPoint = null;
                Point2D.Double endPoint = null;
                int markerPosition = this.getMarkerPosition(element);
                if (this.\u0536 == 1) {
                    double textX = 0.0;
                    if (element.getChartPercentStyle() == 3) {
                        double proportionGap = (double)w / ((double)(this.\u053e - 1) + this.\u053a);
                        valueGap = proportionGap * this.\u053a;
                        spaceGap = proportionGap * (1.0 - this.\u053a);
                        divider = percent * (double)this.\u053e;
                        double xValue = (double)x + proportionGap * (double)((int)divider) + valueGap * (divider % 1.0);
                        if (percent != 0.0 && divider % 1.0 == 0.0) {
                            xValue -= spaceGap;
                        }
                        textX = xValue - (double)(size.width / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(xValue, y + h2);
                                    endPoint = new Point2D.Double(xValue, (double)(y + h2) + lineLength);
                                } else {
                                    startPoint = new Point2D.Double(xValue, y);
                                    endPoint = new Point2D.Double(xValue, (double)y - lineLength);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(xValue, y + h2);
                                    endPoint = new Point2D.Double(xValue, (double)(y + h2) - lineLength);
                                } else {
                                    startPoint = new Point2D.Double(xValue, y);
                                    endPoint = new Point2D.Double(xValue, (double)y + lineLength);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double(xValue, y);
                                endPoint = new Point2D.Double(xValue, (double)y - lineLength);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double(xValue, y);
                                endPoint = new Point2D.Double(xValue, (double)y + lineLength);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double(xValue, y + h2);
                                endPoint = new Point2D.Double(xValue, (double)(y + h2) - lineLength);
                            } else {
                                startPoint = new Point2D.Double(xValue, y + h2);
                                endPoint = new Point2D.Double(xValue, (double)(y + h2) + lineLength);
                            }
                        }
                    } else {
                        textX = (double)x + (double)w * percent - (double)(size.width / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) + lineLength);
                                } else {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y - lineLength);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) - lineLength);
                                } else {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y + lineLength);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y - lineLength);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y + lineLength);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) - lineLength);
                            } else {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) + lineLength);
                            }
                        }
                    }
                    point = startPoint;
                    if (startPoint != null) {
                        startPoint = new Point2D.Double(point.getX(), point.getY() + markerOffset);
                    }
                    if (endPoint != null) {
                        point = endPoint;
                        endPoint = new Point2D.Double(point.getX(), point.getY() + markerOffset);
                    }
                    offset = markerPosition == 1 ? (k2 % 2 == 1 ? (double)(-size.height) - lineLength - 2.0 : (double)h2 + lineLength + 2.0) : (markerPosition == 10 ? (k2 % 2 == 1 ? lineLength + 2.0 : (double)(h2 - size.height) - lineLength - 2.0) : (markerPosition == 2 || markerPosition == 6 ? (double)(-size.height) - lineLength - 2.0 : (markerPosition == 3 || markerPosition == 7 ? lineLength + 2.0 : (markerPosition == 5 || markerPosition == 9 ? (double)h2 - lineLength - (double)size.height - 2.0 : (double)h2 + lineLength + 2.0))));
                    this.paintComponent(g2, renderer, (int)textX, (int)((double)y + (offset += markerOffset)), size.width, size.height);
                } else if (this.\u0536 == 2) {
                    double textY = 0.0;
                    if (element.getChartPercentStyle() == 3) {
                        double proportionGap = (double)h2 / ((double)(this.\u053e - 1) + this.\u053a);
                        valueGap = proportionGap * this.\u053a;
                        spaceGap = proportionGap * (1.0 - this.\u053a);
                        divider = percent * (double)this.\u053e;
                        double yValue = (double)y - proportionGap * (double)((int)divider) - (double)((int)(valueGap * (divider % 1.0)));
                        if (percent != 0.0 && divider % 1.0 == 0.0) {
                            yValue += spaceGap;
                        }
                        textY = yValue - (double)(size.height / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, yValue);
                                    endPoint = new Point2D.Double((double)(x + w) + lineLength, yValue);
                                } else {
                                    startPoint = new Point2D.Double(x, yValue);
                                    endPoint = new Point2D.Double((double)x - lineLength, yValue);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, yValue);
                                    endPoint = new Point2D.Double((double)(x + w) - lineLength, yValue);
                                } else {
                                    startPoint = new Point2D.Double(x, yValue);
                                    endPoint = new Point2D.Double((double)x + lineLength, yValue);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double(x, yValue);
                                endPoint = new Point2D.Double((double)x - lineLength, yValue);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double(x, yValue);
                                endPoint = new Point2D.Double((double)x + lineLength, yValue);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double(x + w, yValue);
                                endPoint = new Point2D.Double((double)(x + w) - lineLength, yValue);
                            } else {
                                startPoint = new Point2D.Double(x + w, yValue);
                                endPoint = new Point2D.Double((double)(x + w) + lineLength, yValue);
                            }
                        }
                    } else {
                        textY = (double)y - (double)h2 * percent - (double)(size.height / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)(x + w) + lineLength, (double)y - (double)h2 * percent);
                                } else {
                                    startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)x - lineLength, (double)y - (double)h2 * percent);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)(x + w) - lineLength, (double)y - (double)h2 * percent);
                                } else {
                                    startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)x + lineLength, (double)y - (double)h2 * percent);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)x - lineLength, (double)y - (double)h2 * percent);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)x + lineLength, (double)y - (double)h2 * percent);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)(x + w) - lineLength, (double)y - (double)h2 * percent);
                            } else {
                                startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)(x + w) + lineLength, (double)y - (double)h2 * percent);
                            }
                        }
                    }
                    point = startPoint;
                    if (startPoint != null) {
                        startPoint = new Point2D.Double(point.getX() + markerOffset, point.getY());
                    }
                    if (endPoint != null) {
                        point = endPoint;
                        endPoint = new Point2D.Double(point.getX() + markerOffset, point.getY());
                    }
                    offset = markerPosition == 1 ? (k2 % 2 == 1 ? (double)(-size.width - 2) - lineLength : (double)(w + 2) + lineLength) : (markerPosition == 10 ? (k2 % 2 == 1 ? 2.0 + lineLength : (double)(w - 2) - lineLength - (double)size.width) : (markerPosition == 2 || markerPosition == 6 ? (double)(-size.width - 2) - lineLength : (markerPosition == 3 || markerPosition == 7 ? lineLength + 2.0 : (markerPosition == 5 || markerPosition == 9 ? (double)w - lineLength - (double)size.width - 2.0 : (double)(w + 2) + lineLength))));
                    this.paintComponent(g2, renderer, (int)((double)x + (offset += markerOffset)), (int)textY, size.width, size.height);
                }
                this.paintMarkerScale(g2, marker, startPoint, endPoint);
            }
        }
    }

    protected int getMarkerPosition(Element element) {
        Object object = element.getClientProperty("chart.percent.marker.position");
        if (object != null && Integer.class.isAssignableFrom(object.getClass())) {
            return (Integer)object;
        }
        return this.\u0540;
    }

    private double F(Element element) {
        double value = this.getValue(element);
        double min = this.getMin(element);
        double max = this.getMax(element);
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return (value - min) / (max - min);
    }

    private double B(Marker marker, Element element) {
        double min = this.getMin(element);
        double max = this.getMax(element);
        return (marker.getValue() - min) / (max - min);
    }

    protected void paintMarkerScale(Graphics2D g2, Marker marker, Point2D.Double startPoint, Point2D.Double endPoint) {
        g2.setColor(marker.getTextColor());
        if (marker.getShape() == 1) {
            Line2D.Double line = new Line2D.Double(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            g2.draw(line);
        } else if (marker.getShape() == 2) {
            Point2D.Double p1 = null;
            Point2D.Double p2 = null;
            double distance = TWaverUtil.getDistance(startPoint, endPoint);
            if (this.\u0536 == 2) {
                p1 = new Point2D.Double(endPoint.x, endPoint.y - Math.tan(0.5235987755982988) * distance);
                p2 = new Point2D.Double(endPoint.x, endPoint.y + Math.tan(0.5235987755982988) * distance);
            } else if (this.\u0536 == 1) {
                p1 = new Point2D.Double(endPoint.x - Math.tan(0.5235987755982988) * distance, endPoint.y);
                p2 = new Point2D.Double(endPoint.x + Math.tan(0.5235987755982988) * distance, endPoint.y);
            }
            GeneralPath path = new GeneralPath();
            path.moveTo((float)startPoint.x, (float)startPoint.y);
            path.lineTo((float)p1.x, (float)p1.y);
            path.lineTo((float)p2.x, (float)p2.y);
            path.closePath();
            g2.fill(path);
        }
    }

    public Color getSpareColor(Element element) {
        Object object = element.getClientProperty("chart.percent.spare.color");
        if (object != null && Color.class.isAssignableFrom(object.getClass())) {
            return (Color)object;
        }
        if (this.\u053b == null) {
            return TUIManager.getColor("chart.percent.spare.color");
        }
        return this.\u053b;
    }

    public Color getSpareCoverColor(Element element) {
        return element.getChartPercentSpareCoverColor();
    }

    public boolean getSpareFill(Element element) {
        Object object = element.getClientProperty("chart.percent.spare.fill");
        if (object != null && Boolean.class.isAssignableFrom(object.getClass())) {
            return (Boolean)object;
        }
        return this.\u0541;
    }

    public Color getPercentColor(Element element) {
        Color color = this.getColor(element);
        List markers = element.getChartMarkers();
        if (markers == null) {
            return color;
        }
        Collections.sort(markers);
        double value = this.getValue(element);
        int count = markers.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Marker marker = (Marker)markers.get(i2);
            if (i2 == 0 && value < marker.getValue()) {
                return color;
            }
            if (i2 < count - 1 && marker.getValue() <= value && value < ((Marker)markers.get(i2 + 1)).getValue()) {
                color = marker.getColor();
                break;
            }
            if (i2 != count - 1) continue;
            color = marker.getColor();
        }
        return color;
    }

    public String getPercentLabel(Element element) {
        double value = this.getValue(element);
        double min = this.getMin(element);
        double max = this.getMax(element);
        String name = this.getLegendLabel(element);
        int percent = (int)((value - min) / (max - min) * 100.0);
        if (name != null) {
            return name + " " + this.getFormat().format(percent) + "%";
        }
        return percent + "%";
    }

    public int getThickness() {
        return this.\u0535;
    }

    public void setThickness(int thickness) {
        this.\u0535 = thickness;
        this.chartPane.repaint();
    }

    public boolean isShowLabel() {
        return this.\u0538;
    }

    public void setShowLabel(boolean showLabel) {
        this.\u0538 = showLabel;
        this.chartPane.repaint();
    }

    public Color getSpareColor() {
        return this.\u053b;
    }

    public void setSpareColor(Color spareColor) {
        this.\u053b = spareColor;
        this.chartPane.repaint();
    }

    public Color getOutlineColor() {
        return this.\u0543;
    }

    public void setOutlineColor(Color outlineColor) {
        this.\u0543 = outlineColor;
        this.chartPane.repaint();
    }

    public int getSegmentCount() {
        return this.\u053e;
    }

    public void setSegmentCount(int segmentCount) {
        this.\u053e = segmentCount;
        this.chartPane.repaint();
    }

    public int getPercentGap() {
        return this.\u0542;
    }

    public void setPercentGap(int percentGap) {
        this.\u0542 = percentGap;
        this.chartPane.repaint();
    }

    public boolean isPercentLabelCenter() {
        return this.\u0539;
    }

    public void setPercentLabelCenter(boolean percentLabelCenter) {
        this.\u0539 = percentLabelCenter;
        this.chartPane.repaint();
    }

    public Color getPercentLabelColor() {
        return this.\u0537;
    }

    public void setPercentLabelColor(Color percentLabelColor) {
        this.\u0537 = percentLabelColor;
        this.chartPane.repaint();
    }

    public Font getPercentLabelFont() {
        return this.\u053d;
    }

    public void setPercentLabelFont(Font percentLabelFont) {
        this.\u053d = percentLabelFont;
        this.chartPane.repaint();
    }

    public boolean isPercentLabelVisible() {
        return this.\u0538;
    }

    public void setPercentLabelVisible(boolean percentLabelVisible) {
        this.\u0538 = percentLabelVisible;
        this.chartPane.repaint();
    }

    public int getPercentType() {
        return this.\u0536;
    }

    public void setPercentType(int percentType) {
        this.\u0536 = percentType;
        this.chartPane.repaint();
    }

    public int getMarkerStartPosition() {
        return this.\u053f;
    }

    public void setMarkerStartPosition(int markStartPosition) {
        this.\u053f = markStartPosition;
        this.chartPane.repaint();
    }

    public double getSegmentSectionProrate() {
        return this.\u053a;
    }

    public void setSegmentSectionProrate(double segmentSectionProrate) {
        this.\u053a = segmentSectionProrate;
        this.chartPane.repaint();
    }

    public int getMarkerPosition() {
        return this.\u0540;
    }

    public void setMarkerPosition(int markerPosition) {
        this.\u0540 = markerPosition;
        this.chartPane.repaint();
    }

    public Color getSpareGradientColor() {
        return this.\u053c;
    }

    public void setSpareGradientColor(Color spareGradientColor) {
        this.\u053c = spareGradientColor;
        this.chartPane.repaint();
    }

    public boolean isSpareFill() {
        return this.\u0541;
    }

    public void setSpareFill(boolean spareFill) {
        this.\u0541 = spareFill;
        this.chartPane.repaint();
    }

    protected void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        SVGPercentChart chart = (SVGPercentChart)abschart;
        chart.setThickness(this.getThickness());
        chart.setShowLabel(this.isShowLabel());
        chart.setSpareColor(this.getSpareColor());
        chart.setOutlineColor(this.getOutlineColor());
        chart.setSegmentCount(this.getSegmentCount());
        chart.setPercentGap(this.getPercentGap());
        chart.setPercentLabelCenter(this.isPercentLabelCenter());
        chart.setPercentLabelColor(this.getPercentLabelColor());
        chart.setPercentLabelFont(this.getPercentLabelFont());
        chart.setPercentLabelVisible(this.isPercentLabelVisible());
        chart.setPercentType(this.getPercentType());
        chart.setMarkerStartPosition(this.getMarkerStartPosition());
        chart.setSegmentSectionProrate(this.getSegmentSectionProrate());
        chart.setMarkerPosition(this.getMarkerPosition());
        chart.setSpareGradientColor(this.getSpareGradientColor());
        chart.setSpareFill(this.isSpareFill());
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGPercentChart chart = new SVGPercentChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }
}

