/*
 * Decompiled with CFR 0.152.
 */
package y.layout.labeling;

import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.geom.IntersectionAlgorithm;
import y.geom.PlaneObject;
import y.geom.YRectangle;
import y.layout.DefaultLayoutGraph;
import y.layout.GraphLayout;
import y.layout.LabelCandidate;
import y.layout.LayoutGraph;
import y.layout.labeling.AbstractLabelingAlgorithm;
import y.layout.labeling.if;
import y.util.D;
import y.util.Timer;

public abstract class MISLabelingAlgorithm
extends AbstractLabelingAlgorithm {
    protected Graph conflictGraph;
    protected NodeMap nodesToBoxes;
    protected NodeMap nodesToID;
    protected static boolean showGraph = false;

    protected void label(LayoutGraph layoutGraph, if[] ifArray) {
        D.bug(this, (Object)"Labeling with MIS !");
        this.createConflictGraph(ifArray);
        D.bug(this, (Object)("Conflict Graph has " + this.conflictGraph.nodeCount() + " nodes !"));
        D.bug(this, (Object)("Conflict Graph has " + this.conflictGraph.edgeCount() + " edges !"));
        NodeList nodeList = this.solveMIS(ifArray);
        this.propagateSolution(ifArray, nodeList);
        this.conflictGraph.clear();
    }

    public void createConflictGraph(if[] ifArray) {
        this.conflictGraph = showGraph ? new DefaultLayoutGraph() : new Graph();
        this.nodesToBoxes = this.conflictGraph.createNodeMap();
        this.nodesToID = this.conflictGraph.createNodeMap();
        this.createNodes(ifArray);
        this.createEdges();
        if (showGraph) {
            GraphLayout graphLayout = (GraphLayout)((Object)this.conflictGraph);
            NodeCursor nodeCursor = this.conflictGraph.nodes();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                LabelCandidate labelCandidate = (LabelCandidate)this.nodesToBoxes.get(node);
                graphLayout.getNodeLayout(node).setSize(3.0, 3.0);
                graphLayout.getNodeLayout(node).setLocation(labelCandidate.getLocation().getX(), labelCandidate.getLocation().getY());
                nodeCursor.next();
            }
        }
    }

    protected abstract NodeList solveMIS(if[] var1);

    public void propagateSolution(if[] ifArray, NodeList nodeList) {
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            if if_ = ifArray[this.nodesToID.getInt(nodeCursor.node())];
            LabelCandidate labelCandidate = (LabelCandidate)this.nodesToBoxes.get(nodeCursor.node());
            labelCandidate.propagate();
            if_.a(true);
            nodeCursor.next();
        }
        int n = 0;
        while (n < ifArray.length) {
            if (!ifArray[n].a()) {
                ifArray[n].c();
            }
            ++n;
        }
    }

    protected void createNodes(if[] ifArray) {
        int n = 0;
        while (n < ifArray.length) {
            if if_ = ifArray[n];
            YList yList = ifArray[n].b();
            if (yList != null) {
                YCursor yCursor = yList.cursor();
                while (yCursor.ok()) {
                    LabelCandidate labelCandidate = (LabelCandidate)yCursor.current();
                    Node node = this.conflictGraph.createNode();
                    this.nodesToBoxes.set(node, labelCandidate);
                    this.nodesToID.setInt(node, n);
                    yCursor.next();
                }
            }
            ++n;
        }
    }

    protected void createEdges() {
        Timer timer = new Timer();
        D.bug(this, (Object)"create edges in conflict graph");
        this.intersectionSL();
        D.bug(this, (Object)("Time: " + timer));
    }

    protected void intersectionSL() {
        YList yList = new YList();
        NodeCursor nodeCursor = this.conflictGraph.nodes();
        while (nodeCursor.ok()) {
            yList.add(new _a(nodeCursor.node()));
            nodeCursor.next();
        }
        IntersectionAlgorithm intersectionAlgorithm = new IntersectionAlgorithm();
        IntersectionAlgorithm.intersect(yList, new _if());
    }

    protected NodeMap assignProfit() {
        NodeMap nodeMap = this.conflictGraph.createNodeMap();
        NodeCursor nodeCursor = this.conflictGraph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            LabelCandidate labelCandidate = (LabelCandidate)this.nodesToBoxes.get(node);
            nodeMap.setDouble(node, this.getProfit(labelCandidate) - labelCandidate.getOverlapPenalty());
            nodeCursor.next();
        }
        return nodeMap;
    }

    class _if
    implements IntersectionAlgorithm.IntersectionHandler {
        _if() {
        }

        public void checkIntersection(Object object, Object object2) {
            Node node = ((_a)object).a();
            Node node2 = ((_a)object2).a();
            MISLabelingAlgorithm.this.conflictGraph.createEdge(node, node2);
        }
    }

    class _a
    implements PlaneObject {
        Node c;

        _a(Node node) {
            this.c = node;
        }

        public YRectangle getBoundingBox() {
            LabelCandidate labelCandidate = (LabelCandidate)MISLabelingAlgorithm.this.nodesToBoxes.get(this.c);
            return labelCandidate.getBoundingBox();
        }

        Node a() {
            return this.c;
        }
    }
}

