/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.shrinkbar.BasicShrinkBar;
import com.nepxion.swing.shrinkbar.JShrinkShortcut;
import com.nepxion.swing.style.texture.shrink.IHeaderTextureStyle;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JShrinkShortcutBar
extends BasicShrinkBar {
    private JPanel contentBar;

    public JShrinkShortcutBar(int placement) {
        this(placement, 2);
    }

    public JShrinkShortcutBar(int placement, IHeaderTextureStyle headerTextureStyle) {
        this(placement, 2, headerTextureStyle);
    }

    public JShrinkShortcutBar(int placement, int contentPaneType) {
        this(placement, contentPaneType, DEFAULT_HEADER_TEXTURE_STYLE);
    }

    public JShrinkShortcutBar(int placement, int contentPaneType, IHeaderTextureStyle headerTextureStyle) {
        super(placement, contentPaneType, headerTextureStyle);
        this.initComponents();
    }

    private void initComponents() {
        this.contentBar = new JPanel();
        this.contentBar.setLayout(new FiledLayout(0, 2, 5));
        this.shrinkContentPane.add((Component)this.contentBar, "Center");
    }

    public JShrinkShortcut addShrinkShortcut(String title, Icon icon, String toolTipText, List buttonList) {
        JShrinkShortcut shrinkShortcut = new JShrinkShortcut();
        shrinkShortcut.setTitle(title);
        shrinkShortcut.setIcon(icon);
        shrinkShortcut.setToolTipText(toolTipText);
        shrinkShortcut.setButtonList(buttonList);
        shrinkShortcut.shrinkChanged(this.isShrinked());
        shrinkShortcut.setSeparatorColor(this.shrinkHeader.getHeaderTextureStyle().getSeparatorColors());
        this.contentBar.add(shrinkShortcut);
        Color background = this.shrinkHeader.getHeaderTextureStyle().getContentBackground();
        if (background != null) {
            this.setBackground(background);
        }
        return shrinkShortcut;
    }

    @Override
    protected void shrinkChanged(boolean shrinked) {
        super.shrinkChanged(shrinked);
        for (int i = 0; i < this.contentBar.getComponentCount(); ++i) {
            Component component = this.contentBar.getComponent(i);
            if (!(component instanceof JShrinkShortcut)) continue;
            JShrinkShortcut shrinkShortcut = (JShrinkShortcut)component;
            shrinkShortcut.shrinkChanged(shrinked);
        }
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        this.setBackground(this, background);
    }

    private void setBackground(JComponent component, Color background) {
        for (int i = 0; i < component.getComponentCount(); ++i) {
            Component c = component.getComponent(i);
            if (!(c instanceof JComponent)) continue;
            JComponent childComponent = (JComponent)c;
            childComponent.setBackground(background);
            this.setBackground(childComponent, background);
        }
    }

    public JShrinkShortcut getShrinkOutlook(int index) {
        Component component = this.contentBar.getComponent(index);
        if (component instanceof JShrinkShortcut) {
            JShrinkShortcut shrinkShortcut = (JShrinkShortcut)component;
            return shrinkShortcut;
        }
        return null;
    }

    public JShrinkShortcut getShrinkOutlook(String title) {
        for (int i = 0; i < this.contentBar.getComponentCount(); ++i) {
            JShrinkShortcut shrinkShortcut;
            Component component = this.contentBar.getComponent(i);
            if (!(component instanceof JShrinkShortcut) || !(shrinkShortcut = (JShrinkShortcut)component).getTitle().equals(title)) continue;
            return shrinkShortcut;
        }
        return null;
    }
}

