/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.pie;

import com.nepxion.swing.chart.JChartPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jfree.chart.plot.PiePlot;

public class PiePlotRotator
extends Timer
implements ActionListener {
    private PiePlot piePlot;
    private int angle = 270;

    public PiePlotRotator(JChartPanel chartPanel, boolean isClickingStarted) {
        this(chartPanel, 100, isClickingStarted);
    }

    public PiePlotRotator(JChartPanel chartPanel, int delay, boolean isClickingStarted) {
        super(delay, null);
        this.piePlot = (PiePlot)chartPanel.getChart().getPlot();
        if (isClickingStarted) {
            chartPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                        PiePlotRotator.this.execute();
                    }
                }
            });
        }
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.piePlot.setStartAngle((double)this.angle);
        ++this.angle;
        if (this.angle == 360) {
            this.angle = 0;
        }
    }

    public void execute() {
        if (!this.isRunning()) {
            this.start();
        } else {
            this.stop();
        }
    }
}

