/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraphBackground;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class TGraphGridBackground
extends TGraphBackground {
    private int width = 650;
    private int height = 450;
    private int widthCount = 30;
    private int heightCount = 40;
    private int startX = 105;
    private int startY = 295;
    private double angle = 0.5235987755982988;

    public TGraphGridBackground(Color color, Color gradientColor) {
        super(color, gradientColor);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidthCount() {
        return this.widthCount;
    }

    public void setWidthCount(int widthCount) {
        this.widthCount = widthCount;
    }

    public int getHeightCount() {
        return this.heightCount;
    }

    public void setHeightCount(int heightCount) {
        this.heightCount = heightCount;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int startX) {
        this.startX = startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public void paintContent(Graphics2D g, double zoom, Rectangle viewportRect) {
        super.paintContent(g, zoom, viewportRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(this.getGradientColor());
        double xGap = (double)this.width / ((double)this.widthCount - 1.0);
        double xHSpace = xGap * Math.cos(this.angle);
        double xVSpace = xGap * Math.sin(this.angle);
        double xEndX = (double)this.startX + (double)this.height * Math.cos(this.angle);
        double xEndY = (double)this.startY - (double)this.height * Math.sin(this.angle);
        double out = 10.0;
        double outx = out * Math.cos(this.angle);
        double outy = out * Math.sin(this.angle);
        for (int i = 0; i < this.widthCount; ++i) {
            double sx = (double)this.startX + xHSpace * (double)i - outx;
            double sy = (double)this.startY + xVSpace * (double)i + outy;
            double ex = xEndX + xHSpace * (double)i + outx;
            double ey = xEndY + xVSpace * (double)i - outy;
            Line2D.Double line = new Line2D.Double(sx, sy, ex, ey);
            g2d.draw(line);
        }
        double yGap = (double)this.height / ((double)this.heightCount - 1.0);
        double yHSpace = yGap * Math.cos(this.angle);
        double yVSpace = yGap * Math.sin(this.angle);
        double yEndX = (double)this.startX + (double)this.width * Math.cos(this.angle);
        double yEndY = (double)this.startY + (double)this.width * Math.sin(this.angle);
        for (int i = 0; i < this.heightCount; ++i) {
            double sx = (double)this.startX + yHSpace * (double)i - outx;
            double sy = (double)this.startY - yVSpace * (double)i - outy;
            double ex = yEndX + yHSpace * (double)i + outx;
            double ey = yEndY - yVSpace * (double)i + outy;
            Line2D.Double line = new Line2D.Double(sx, sy, ex, ey);
            g2d.draw(line);
        }
    }
}

