/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.scrollpane;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.SimpleScrollPane;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.scrollpane.ScrollPaneManager;
import com.nepxion.swing.style.button.lite.LiteButtonUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;

public class JAutoRollScrollPane
extends SimpleScrollPane
implements SwingConstants {
    public JAutoRollScrollPane() {
        this.initComponents();
    }

    public JAutoRollScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.initComponents();
    }

    public JAutoRollScrollPane(Component view) {
        super(view);
        this.initComponents();
    }

    public JAutoRollScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.initComponents();
    }

    private void initComponents() {
        this.setScrollUpButton(new JAutoRollScrollButton(1));
        this.setScrollDownButton(new JAutoRollScrollButton(5));
        this.setScrollLeftButton(new JAutoRollScrollButton(7));
        this.setScrollRightButton(new JAutoRollScrollButton(3));
        this.setRepeatDelay(15);
        ScrollPaneManager.setPreferenceStyle((JScrollPane)((Object)this));
    }

    public class JAutoRollScrollButton
    extends JBasicButton
    implements MouseListener,
    ActionListener,
    UIResource {
        private int direction;
        private Timer timer;

        public JAutoRollScrollButton(final int direction) {
            this.direction = direction;
            switch (direction) {
                case 1: {
                    this.setIcon(JideIconsFactory.getImageIcon((String)"jide/direction_up.gif"));
                    break;
                }
                case 5: {
                    this.setIcon(JideIconsFactory.getImageIcon((String)"jide/direction_down.gif"));
                    break;
                }
                case 7: {
                    this.setIcon(JideIconsFactory.getImageIcon((String)"jide/direction_left.gif"));
                    break;
                }
                case 3: {
                    this.setIcon(JideIconsFactory.getImageIcon((String)"jide/direction_right.gif"));
                }
            }
            this.setUI(new LiteButtonUI(ButtonManager.getButtonStyle()){

                @Override
                public void paint(Graphics g, JComponent c) {
                    super.paint(g, c);
                    g.setColor(Color.gray);
                    Border viewportBorder = JAutoRollScrollPane.this.getViewportBorder();
                    if (viewportBorder != null && viewportBorder instanceof CompoundBorder) {
                        switch (direction) {
                            case 1: {
                                g.drawLine(0, 0, JAutoRollScrollButton.this.getWidth() - 1, 0);
                                g.drawLine(0, 0, 0, JAutoRollScrollButton.this.getHeight() - 1);
                                g.drawLine(JAutoRollScrollButton.this.getWidth() - 1, 0, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                                break;
                            }
                            case 5: {
                                g.drawLine(0, JAutoRollScrollButton.this.getHeight() - 1, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                                g.drawLine(0, 0, 0, JAutoRollScrollButton.this.getHeight() - 1);
                                g.drawLine(JAutoRollScrollButton.this.getWidth() - 1, 0, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                                break;
                            }
                            case 7: {
                                g.drawLine(0, 0, JAutoRollScrollButton.this.getWidth() - 1, 0);
                                g.drawLine(0, 0, 0, JAutoRollScrollButton.this.getHeight() - 1);
                                g.drawLine(0, JAutoRollScrollButton.this.getHeight() - 1, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                                break;
                            }
                            case 3: {
                                g.drawLine(0, 0, JAutoRollScrollButton.this.getWidth() - 1, 0);
                                g.drawLine(JAutoRollScrollButton.this.getWidth() - 1, 0, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                                g.drawLine(0, JAutoRollScrollButton.this.getHeight() - 1, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                            }
                        }
                    } else {
                        g.drawRect(0, 0, JAutoRollScrollButton.this.getWidth() - 1, JAutoRollScrollButton.this.getHeight() - 1);
                    }
                }
            });
            this.setDimension(new Dimension(10, 10));
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JAutoRollScrollPane.this.scroll(JAutoRollScrollPane.this.getViewport(), this.direction);
            JAutoRollScrollPane.this.updateButtonState();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!JAutoRollScrollPane.this.isScrollOnRollover()) {
                this.startTimer(e, 500);
            } else {
                this.updateTimer(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!JAutoRollScrollPane.this.isScrollOnRollover()) {
                this.stopTimer();
            } else {
                this.updateTimer(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (JAutoRollScrollPane.this.isScrollOnRollover()) {
                this.startTimer(e, 500);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (JAutoRollScrollPane.this.isScrollOnRollover()) {
                this.stopTimer();
            }
        }

        private void updateTimer(MouseEvent e) {
            if (this.timer != null) {
                int delay = this.getDelay(e);
                this.timer.setDelay(delay);
            }
        }

        private void startTimer(MouseEvent e, int initialDelay) {
            this.stopTimer();
            int delay = this.getDelay(e);
            this.timer = new Timer(delay, this);
            this.timer.setInitialDelay(initialDelay);
            this.timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        private int getDelay(MouseEvent e) {
            if (JAutoRollScrollPane.this.isScrollOnRollover()) {
                return SwingUtilities.isLeftMouseButton(e) ? JAutoRollScrollPane.this.getRepeatDelay() : JAutoRollScrollPane.this.getRepeatDelay() * 2;
            }
            return JAutoRollScrollPane.this.getRepeatDelay();
        }
    }
}

