/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class IntegerEditor
extends AbstractCellEditor {
    public IntegerEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public IntegerEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return TWaverUtil.valueOf(((Number)value).intValue());
        }
        try {
            return TWaverUtil.valueOf(Integer.parseInt(value.toString()));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof Integer;
    }
}

