/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import twaver.BTS;
import twaver.BTSAntenna;
import twaver.Card;
import twaver.DataBoxEvent;
import twaver.Element;
import twaver.Equipment;
import twaver.Follower;
import twaver.Grid;
import twaver.Group;
import twaver.Link;
import twaver.Node;
import twaver.PolyLine;
import twaver.ResizableNode;
import twaver.RotatableNode;
import twaver.ShapeLink;
import twaver.ShapeNode;
import twaver.Shelf;
import twaver.Slot;
import twaver.TDataBox;
import twaver.TSubNetwork;
import twaver.TUIManager;
import twaver.UndoRedoEvent;
import twaver.UndoRedoInterceptor;
import twaver.UndoRedoManager;
import twaver.network.background.Background;

public class DefaultUndoRedoInterceptor
implements UndoRedoInterceptor {
    protected UndoRedoManager undoRedoManager = null;

    public DefaultUndoRedoInterceptor(UndoRedoManager undoRedoManager) {
        this.undoRedoManager = undoRedoManager;
    }

    public void undo(TDataBox box, Object event) {
        if (event instanceof PropertyChangeEvent) {
            PropertyChangeEvent e2 = (PropertyChangeEvent)event;
            this.undoPropertyChange((Element)e2.getSource(), e2.getPropertyName(), e2.getOldValue());
        } else if (event instanceof DataBoxEvent) {
            DataBoxEvent e3 = (DataBoxEvent)event;
            int type = e3.getType();
            Element element = e3.getElement();
            if (type == 1) {
                box.removeElement(element);
            } else if (type == 2) {
                this.A(box, element, e3);
            }
        } else if (event instanceof UndoRedoEvent) {
            UndoRedoEvent undoRedoEvent = (UndoRedoEvent)event;
            undoRedoEvent.undo();
        }
    }

    private void A(TDataBox box, Element element, DataBoxEvent e2) {
        Link link;
        if (element instanceof Link && ((link = (Link)element).getFrom() == null || link.getTo() == null)) {
            link.setFrom(e2.getFrom());
            link.setTo(e2.getTo());
        }
        if (e2.getParent() != null) {
            element.setParent(e2.getParent());
        }
        if (e2.getHost() != null && element instanceof Follower) {
            ((Follower)element).setHost(e2.getHost());
        }
        if (e2.getBTS() != null && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setBTS(e2.getBTS());
        }
        box.addElement(element);
    }

    public void redo(TDataBox box, Object event) {
        if (event instanceof PropertyChangeEvent) {
            PropertyChangeEvent e2 = (PropertyChangeEvent)event;
            this.undoPropertyChange((Element)e2.getSource(), e2.getPropertyName(), e2.getNewValue());
        } else if (event instanceof DataBoxEvent) {
            DataBoxEvent e3 = (DataBoxEvent)event;
            int type = e3.getType();
            Element element = e3.getElement();
            if (type == 1) {
                this.A(box, element, e3);
            } else if (type == 2) {
                box.removeElement(element);
            }
        } else if (event instanceof UndoRedoEvent) {
            UndoRedoEvent undoRedoEvent = (UndoRedoEvent)event;
            undoRedoEvent.redo();
        }
    }

    public boolean isInterested(DataBoxEvent event) {
        if (event.getType() == 3) {
            this.undoRedoManager.reset();
            return false;
        }
        return true;
    }

    public boolean isInterested(PropertyChangeEvent event) {
        PropertyChangeEvent e2 = event;
        String propertyName = e2.getPropertyName();
        Element element = (Element)e2.getSource();
        return this.handlerable(propertyName, element, e2.getOldValue(), e2.getNewValue());
    }

    private boolean A(Element element) {
        return element instanceof ResizableNode && !(element instanceof Group) && !(element instanceof BTSAntenna);
    }

    protected boolean handlerable(String name, Element element, Object oldValue, Object newValue) {
        if (name.startsWith("CP:")) {
            name = name.substring("CP:".length());
            return TUIManager.isPredefinedClientPropertyKey(name);
        }
        if ("layerID".equals(name)) {
            return true;
        }
        if ("icon".equals(name)) {
            return true;
        }
        if ("image".equals(name)) {
            return true;
        }
        if ("name".equals(name)) {
            return true;
        }
        if ("displayName".equals(name)) {
            return true;
        }
        if ("enableAlarmPropagationFromChildren".equals(name)) {
            return true;
        }
        if ("parent".equals(name)) {
            return true;
        }
        if ("userObject".equals(name)) {
            return true;
        }
        if ("toolTipText".equals(name)) {
            return true;
        }
        if ("visible".equals(name)) {
            return true;
        }
        if ("location".equals(name)) {
            return true;
        }
        if ("width".equals(name) && this.A(element)) {
            return true;
        }
        if ("height".equals(name) && this.A(element)) {
            return true;
        }
        if ("size".equals(name) && this.A(element)) {
            return true;
        }
        if ("host".equals(name) && element instanceof Follower) {
            return true;
        }
        if ("exist".equals(name) && element instanceof Equipment) {
            return true;
        }
        if ("tag".equals(name) && element instanceof Equipment) {
            return true;
        }
        if ("from".equals(name) && element instanceof Link) {
            return newValue != null && oldValue != null;
        }
        if ("to".equals(name) && element instanceof Link) {
            return newValue != null && oldValue != null;
        }
        if ("linkType".equals(name) && element instanceof Link) {
            return true;
        }
        if ("expand".equals(name) && element instanceof Group) {
            return true;
        }
        if ("groupType".equals(name) && element instanceof Group) {
            return true;
        }
        if ("shapeNodeType".equals(name) && element instanceof ShapeNode) {
            return true;
        }
        if ("power".equals(name) && element instanceof BTSAntenna) {
            return true;
        }
        if ("beamDirection".equals(name) && element instanceof BTSAntenna) {
            return true;
        }
        if ("beamWidth".equals(name) && element instanceof BTSAntenna) {
            return true;
        }
        if ("beamAlpha".equals(name) && element instanceof BTSAntenna) {
            return true;
        }
        if ("antennaType".equals(name) && element instanceof BTSAntenna) {
            return true;
        }
        if ("BTS".equals(name) && element instanceof BTSAntenna) {
            return true;
        }
        if ("blinkingObject".equals(name) && element instanceof PolyLine) {
            return true;
        }
        if ("equipIndex".equals(name) && element instanceof Shelf) {
            return true;
        }
        if ("equipCount".equals(name) && element instanceof Shelf) {
            return true;
        }
        if ("equipIndex".equals(name) && element instanceof Slot) {
            return true;
        }
        if ("equipCount".equals(name) && element instanceof Slot) {
            return true;
        }
        if ("zoom".equals(name) && element instanceof RotatableNode) {
            return true;
        }
        if ("angle".equals(name) && element instanceof RotatableNode) {
            return true;
        }
        if ("rowCount".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("columnCount".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("rowIndex".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("columnIndex".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("rowSpan".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("columnSpan".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("padding".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("border".equals(name) && element instanceof Grid) {
            return true;
        }
        if ("shapeFrozen".equals(name) && element instanceof Link) {
            return true;
        }
        if ("shapeLinkType".equals(name) && element instanceof ShapeLink) {
            return true;
        }
        if ("spanCount".equals(name) && element instanceof Card) {
            return true;
        }
        if ("startIndex".equals(name) && element instanceof Card) {
            return true;
        }
        return "background".equals(name) && element instanceof TSubNetwork;
    }

    protected void undoPropertyChange(Element element, String name, Object value) {
        if (name.startsWith("CP:")) {
            if (TUIManager.isPredefinedClientPropertyKey(name = name.substring("CP:".length()))) {
                element.putClientProperty((Object)name, value);
            }
        } else if ("layerID".equals(name)) {
            element.setLayerID(value);
        } else if ("icon".equals(name)) {
            element.setIcon((String)value);
        } else if ("image".equals(name)) {
            element.setImage((String)value);
        } else if ("name".equals(name)) {
            element.setName((String)value);
        } else if ("displayName".equals(name)) {
            element.setDisplayName((String)value);
        } else if ("enableAlarmPropagationFromChildren".equals(name)) {
            element.setEnableAlarmPropagationFromChildren((Boolean)value);
        } else if ("parent".equals(name)) {
            element.setParent((Element)value);
        } else if ("userObject".equals(name)) {
            element.setUserObject(value);
        } else if ("toolTipText".equals(name)) {
            element.setToolTipText((String)value);
        } else if ("visible".equals(name)) {
            element.setVisible((Boolean)value);
        } else if ("location".equals(name)) {
            Point2D location = (Point2D)value;
            element.setLocation(location.getX(), location.getY());
        } else if ("width".equals(name) && element instanceof ResizableNode) {
            ((ResizableNode)element).setWidthSize((Integer)value);
        } else if ("height".equals(name) && element instanceof ResizableNode) {
            ((ResizableNode)element).setHeightSize((Integer)value);
        } else if ("size".equals(name) && element instanceof ResizableNode) {
            ((ResizableNode)element).setSize((Dimension)value);
        } else if ("host".equals(name) && element instanceof Follower) {
            ((Follower)element).setHost((Node)value);
        } else if ("exist".equals(name) && element instanceof Equipment) {
            ((Equipment)element).setExist((Boolean)value);
        } else if ("tag".equals(name) && element instanceof Equipment) {
            ((Equipment)element).setTag((String)value);
        } else if ("from".equals(name) && element instanceof Link) {
            ((Link)element).setFrom((Node)value);
        } else if ("to".equals(name) && element instanceof Link) {
            ((Link)element).setTo((Node)value);
        } else if ("linkType".equals(name) && element instanceof Link) {
            ((Link)element).setLinkType((Integer)value);
        } else if ("expand".equals(name) && element instanceof Group) {
            ((Group)element).setExpand((Boolean)value);
        } else if ("groupType".equals(name) && element instanceof Group) {
            ((Group)element).setGroupType((Integer)value);
        } else if ("shapeNodeType".equals(name) && element instanceof ShapeNode) {
            ((ShapeNode)element).setShapeNodeType((Integer)value);
        } else if ("power".equals(name) && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setPower((Integer)value);
        } else if ("beamDirection".equals(name) && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setBeamDirection((Integer)value);
        } else if ("beamWidth".equals(name) && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setBeamWidth((Integer)value);
        } else if ("beamAlpha".equals(name) && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setBeamAlpha(((Float)value).floatValue());
        } else if ("antennaType".equals(name) && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setAntennaType((Integer)value);
        } else if ("BTS".equals(name) && element instanceof BTSAntenna) {
            ((BTSAntenna)element).setBTS((BTS)value);
        } else if ("blinkingObject".equals(name) && element instanceof PolyLine) {
            ((PolyLine)element).setBlinkingObject(value);
        } else if ("equipIndex".equals(name) && element instanceof Shelf) {
            ((Shelf)element).setEquipIndex((Integer)value);
        } else if ("equipCount".equals(name) && element instanceof Shelf) {
            ((Shelf)element).setEquipCount((Integer)value);
        } else if ("equipIndex".equals(name) && element instanceof Slot) {
            ((Slot)element).setEquipIndex((Integer)value);
        } else if ("equipCount".equals(name) && element instanceof Slot) {
            ((Slot)element).setEquipCount((Integer)value);
        } else if ("zoom".equals(name) && element instanceof RotatableNode) {
            ((RotatableNode)element).setZoom((Double)value);
        } else if ("angle".equals(name) && element instanceof RotatableNode) {
            ((RotatableNode)element).setAngle((Double)value);
        } else if ("rowCount".equals(name) && element instanceof Grid) {
            ((Grid)element).setRowCount((Integer)value);
        } else if ("columnCount".equals(name) && element instanceof Grid) {
            ((Grid)element).setColumnCount((Integer)value);
        } else if ("rowIndex".equals(name) && element instanceof Grid) {
            ((Grid)element).setRowIndex((Integer)value);
        } else if ("columnIndex".equals(name) && element instanceof Grid) {
            ((Grid)element).setColumnIndex((Integer)value);
        } else if ("rowSpan".equals(name) && element instanceof Grid) {
            ((Grid)element).setRowSpan((Integer)value);
        } else if ("columnSpan".equals(name) && element instanceof Grid) {
            ((Grid)element).setColumnSpan((Integer)value);
        } else if ("padding".equals(name) && element instanceof Grid) {
            ((Grid)element).setPadding((Insets)value);
        } else if ("border".equals(name) && element instanceof Grid) {
            ((Grid)element).setBorder((Insets)value);
        } else if ("shapeFrozen".equals(name) && element instanceof Link) {
            ((Link)element).setShapeFrozen((Boolean)value);
        } else if ("shapeLinkType".equals(name) && element instanceof ShapeLink) {
            ((ShapeLink)element).setShapeLinkType((Integer)value);
        } else if ("spanCount".equals(name) && element instanceof Card) {
            ((Card)element).setSpanCount((Integer)value);
        } else if ("startIndex".equals(name) && element instanceof Card) {
            ((Card)element).setStartIndex((Integer)value);
        } else if ("background".equals(name) && element instanceof TSubNetwork) {
            ((TSubNetwork)element).setBackground((Background)value);
        }
    }
}

