/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import com.jidesoft.spinner.SpinnerWheelSupport;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.InternationalFormatter;

public class DateSpinner
extends JSpinner {
    public DefaultFormatter _formatter;
    public JSpinner.DateEditor _timeEditor;
    public DateFormat _format;
    public String format;

    public DateSpinner() {
        this("hh:mm:ss");
    }

    public DateSpinner(String format) {
        this(format, new Date());
    }

    public DateSpinner(String format, Date date) {
        super(new SpinnerDateModel(date, null, null, 5));
        this.setFormat(format);
        this.customizeSpinner();
    }

    private void customizeDateEditor() {
        Format f;
        JFormattedTextField.AbstractFormatter formatter = this._timeEditor.getTextField().getFormatter();
        if (!(formatter instanceof DefaultFormatter)) {
            throw new IllegalStateException("The formatter is not an instance of DefaultFormatter.");
        }
        this._formatter = (DefaultFormatter)formatter;
        if (formatter instanceof InternationalFormatter && (f = ((InternationalFormatter)formatter).getFormat()) instanceof DateFormat) {
            this._format = (DateFormat)f;
        }
        if (this._format == null) {
            throw new IllegalStateException("The format is not an instance of SimpleDateFormat.");
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this._timeEditor = this.createDateEditor(format);
        this.customizeDateEditor();
        this.setEditor(this._timeEditor);
    }

    protected void customizeSpinner() {
        this.setLenient(false);
        this.setCommitsOnValidEdit(true);
        this.setAllowsInvalid(false);
        this.setOverwriteMode(true);
        SpinnerWheelSupport.installMouseWheelSupport(this);
    }

    protected JSpinner.DateEditor createDateEditor(String format) {
        return new JSpinner.DateEditor((JSpinner)this, format);
    }

    public void setCommitsOnValidEdit(boolean commit) {
        this._formatter.setCommitsOnValidEdit(commit);
    }

    public boolean getCommitsOnValidEdit() {
        return this._formatter.getCommitsOnValidEdit();
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this._formatter.setOverwriteMode(overwriteMode);
    }

    public boolean getOverwriteMode() {
        return this._formatter.getOverwriteMode();
    }

    public void setAllowsInvalid(boolean allowsInvalid) {
        this._formatter.setAllowsInvalid(allowsInvalid);
    }

    public boolean getAllowsInvalid() {
        return this._formatter.getAllowsInvalid();
    }

    public void setTimeZone(TimeZone zone) {
        this._format.setTimeZone(zone);
    }

    public TimeZone getTimeZone() {
        return this._format.getTimeZone();
    }

    public void setLenient(boolean lenient) {
        this._format.setLenient(lenient);
    }

    public boolean isLenient() {
        return this._format.isLenient();
    }
}

