/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import y.base.Graph;
import y.base.Node;
import y.io.gml.GMLEncoder;
import y.io.gml.InterEdge;
import y.io.gml.ObjectEncoder;
import y.view.Graph2D;
import y.view.hierarchy.HierarchyManager;

public class HierarchicGraphObjectEncoder
implements ObjectEncoder {
    private HierarchicGraphObjectEncoder o;
    private ObjectEncoder l;
    private ObjectEncoder m;
    private List n;

    public HierarchicGraphObjectEncoder(HierarchicGraphObjectEncoder hierarchicGraphObjectEncoder) {
        this(null, null, hierarchicGraphObjectEncoder);
    }

    public HierarchicGraphObjectEncoder(ObjectEncoder objectEncoder, ObjectEncoder objectEncoder2, HierarchicGraphObjectEncoder hierarchicGraphObjectEncoder) {
        this.o = hierarchicGraphObjectEncoder;
        this.l = objectEncoder;
        this.m = objectEncoder2;
        this.n = new ArrayList(20);
    }

    public void encode(Object object, GMLEncoder gMLEncoder) throws IOException {
        this.n.clear();
        Graph2D graph2D = (Graph2D)object;
        HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph2D);
        if (hierarchyManager != null) {
            gMLEncoder.addAttribute("hierarchic", 1);
        }
        if (this.l != null) {
            this.l.encode(object, gMLEncoder);
        }
        if (this.m != null) {
            Iterator iterator = this.n.iterator();
            while (iterator.hasNext()) {
                gMLEncoder.beginSection("interedge");
                InterEdge interEdge = (InterEdge)iterator.next();
                this.m.encode(interEdge, gMLEncoder);
                gMLEncoder.endSection();
            }
        }
    }

    public ObjectEncoder getInterEdgeEncoder() {
        return this.m;
    }

    public void setInterEdgeEncoder(ObjectEncoder objectEncoder) {
        this.m = objectEncoder;
    }

    public List getInterEdgeList() {
        return this.n;
    }

    public String createNodeReference(Graph graph, Node node, HierarchyManager hierarchyManager) {
        Graph graph2 = node.getGraph();
        String string = Integer.toString(node.index());
        while (graph2 != graph) {
            Node node2 = hierarchyManager.getAnchorNode(graph2);
            string = Integer.toString(node2.index()) + ":" + string;
            graph2 = hierarchyManager.getParentGraph(graph2);
        }
        return string;
    }

    public ObjectEncoder getGraphEncoder() {
        return this.l;
    }

    public void setGraphEncoder(ObjectEncoder objectEncoder) {
        this.l = objectEncoder;
    }
}

