/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree;

import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class TreeNavigator {
    private JTree tree;
    private String url;
    private String delimiter = "||";
    private boolean rootInclusive = true;

    public TreeNavigator(JTree tree) {
        this.tree = tree;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isRootInclusive() {
        return this.rootInclusive;
    }

    public void setRootInclusive(boolean rootInclusive) {
        this.rootInclusive = rootInclusive;
    }

    public String getURL(TreeNode treeNode) {
        this.url = treeNode.toString();
        this.recursion(treeNode);
        return this.url;
    }

    private void recursion(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        TreeNode parentTreeNode = treeNode.getParent();
        if (parentTreeNode != null) {
            if (this.rootInclusive) {
                this.url = parentTreeNode.toString() + " " + this.delimiter + " " + this.url;
                this.recursion(parentTreeNode);
            } else if (parentTreeNode != this.tree.getModel().getRoot()) {
                this.url = parentTreeNode.toString() + " " + this.delimiter + " " + this.url;
                this.recursion(parentTreeNode);
            }
        }
    }
}

