/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.thread.container;

import com.nepxion.swing.swingworker.JSwingWorker;
import com.nepxion.swing.thread.container.AbstractThreadContainer;
import java.awt.Component;

public abstract class AbstractSwingWorker
extends JSwingWorker {
    private int delayTime = 0;

    public AbstractSwingWorker(Component component, int delayTime) {
        super(component);
        this.delayTime = delayTime;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    @Override
    protected Object doInBackground() throws Exception {
        AbstractThreadContainer threadContainer = (AbstractThreadContainer)this.getComponent();
        if (this.delayTime > 0) {
            threadContainer.start(this.delayTime);
        } else {
            threadContainer.start();
        }
        Object data = super.doInBackground();
        threadContainer.finish();
        return data;
    }

    @Override
    public void firePendingStatusChanged() {
    }

    @Override
    public void fireStartedStatusChanged() {
        AbstractThreadContainer threadContainer = (AbstractThreadContainer)this.getComponent();
        threadContainer.showThread();
    }

    @Override
    public void fireDoneStatusChanged() {
        AbstractThreadContainer threadContainer = (AbstractThreadContainer)this.getComponent();
        threadContainer.stop();
    }

    @Override
    public void fireProgressValueChanged(Object value) {
    }

    @Override
    public void fireCancelledStatusChanged() {
        AbstractThreadContainer threadContainer = (AbstractThreadContainer)this.getComponent();
        threadContainer.stop();
        threadContainer.showInformation();
    }

    @Override
    public void fireForegroundException(Exception e) {
        AbstractThreadContainer threadContainer = (AbstractThreadContainer)this.getComponent();
        threadContainer.stop();
        threadContainer.showError();
    }

    @Override
    public void fireBackgroundException(Exception e) {
    }
}

