/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.dropdown.component;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menuitem.JBasicCheckBoxMenuItem;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.selector.dropdown.IDropDownPopupMenu;
import com.nepxion.swing.selector.dropdown.JDropDownDraggablePopupMenu;
import com.nepxion.swing.selector.dropdown.JDropDownPane;
import com.nepxion.swing.selector.dropdown.JDropDownPopupMenu;
import com.nepxion.swing.selector.dropdown.JDropDownSelector;
import com.nepxion.swing.textcomponent.TextPopupMenuAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class JTreeDropDownSelector
extends JDropDownSelector {
    private JTree tree;
    private TreeNode treeNode;
    private String text;
    private String delimiter = "||";
    private JBasicCheckBoxMenuItem showRootMenuItem;
    private JBasicCheckBoxMenuItem showPathMenuItem;

    public JTreeDropDownSelector(JTree tree) {
        this(tree, true);
    }

    public JTreeDropDownSelector(JTree tree, boolean isDraggablePopupMenu) {
        this.tree = tree;
        this.tree.getSelectionModel().setSelectionMode(1);
        IDropDownPopupMenu dropDownPopupMenu = null;
        dropDownPopupMenu = isDraggablePopupMenu ? new JDropDownDraggablePopupMenu() : new JDropDownPopupMenu();
        DropDownPane dropDownPane = new DropDownPane(dropDownPopupMenu, tree);
        this.setDropDownPane(dropDownPane);
        TextPopupMenuAdapter popupMenuAdapter = this.getTextField().getPopupMenuAdapter();
        JBasicPopupMenu popoupMenu = popupMenuAdapter.getPopupMenu();
        popoupMenu.addSeparator();
        this.showRootMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("show_tree_root"), SwingLocale.getString("show_tree_root"), true);
        this.showRootMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTreeDropDownSelector.this.adaptText();
            }
        });
        popoupMenu.add(this.showRootMenuItem);
        this.showPathMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("show_tree_path"), SwingLocale.getString("show_tree_path"), true);
        this.showPathMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTreeDropDownSelector.this.adaptText();
            }
        });
        popoupMenu.add(this.showPathMenuItem);
    }

    private void recursion(TreeNode treeNode) {
        if (treeNode == null) {
            this.text = null;
            return;
        }
        TreeNode parentTreeNode = treeNode.getParent();
        if (parentTreeNode != null) {
            if (this.showRootMenuItem.isSelected()) {
                this.text = parentTreeNode.toString() + " " + this.delimiter + " " + this.text;
                this.recursion(parentTreeNode);
            } else if (parentTreeNode != this.tree.getModel().getRoot()) {
                this.text = parentTreeNode.toString() + " " + this.delimiter + " " + this.text;
                this.recursion(parentTreeNode);
            }
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeNode getSelectedTreeNode() {
        return this.treeNode;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isShowRoot() {
        return this.showRootMenuItem.isSelected();
    }

    public void setShowRoot(boolean isShowRoot) {
        this.showRootMenuItem.setSelected(isShowRoot);
    }

    public boolean isShowPath() {
        return this.showPathMenuItem.isSelected();
    }

    public void setShowPath(boolean isShowPath) {
        this.showPathMenuItem.setSelected(isShowPath);
    }

    public boolean doConfirm() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return false;
        }
        Object selectedComponent = treePath.getLastPathComponent();
        if (selectedComponent == null) {
            return false;
        }
        boolean returnValue = this.confirm();
        if (returnValue) {
            this.treeNode = (TreeNode)selectedComponent;
            this.adaptText();
        }
        return returnValue;
    }

    private void adaptText() {
        String string = this.text = this.treeNode != null ? this.treeNode.toString() : null;
        if (this.showPathMenuItem.isSelected()) {
            this.recursion(this.treeNode);
        }
        if (this.text != null) {
            this.getTextField().setText(this.text);
        }
    }

    public boolean doCancel() {
        return this.cancel();
    }

    public abstract boolean confirm();

    public abstract boolean cancel();

    public class DropDownPane
    extends JDropDownPane {
        public DropDownPane(IDropDownPopupMenu popupMenu, JTree tree) {
            super(popupMenu, new JBasicScrollPane(tree));
        }

        @Override
        public boolean confirm() {
            return JTreeDropDownSelector.this.doConfirm();
        }

        @Override
        public boolean cancel() {
            return JTreeDropDownSelector.this.doCancel();
        }
    }
}

