/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import com.nepxion.swing.border.ComponentTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JComponentTitledBorderPanel
extends JPanel {
    private ComponentTitledBorder titledBorder;
    private JPanel titledBorderContainer = new JPanel();
    private JPanel contentPane;
    private boolean isToggleAllowed = false;

    public JComponentTitledBorderPanel(JCheckBox checkBox, boolean isToggleAllowed) {
        this(checkBox);
        this.isToggleAllowed = isToggleAllowed;
        if (this.isToggleAllowed) {
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComponentTitledBorderPanel.this.setContentPaneEnabled(e.getStateChange() == 1);
                }
            });
        }
    }

    public JComponentTitledBorderPanel(JRadioButton radioButton, boolean isToggleAllowed) {
        this(radioButton);
        this.isToggleAllowed = isToggleAllowed;
        if (this.isToggleAllowed) {
            radioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComponentTitledBorderPanel.this.setContentPaneEnabled(e.getStateChange() == 1);
                }
            });
        }
    }

    public JComponentTitledBorderPanel(JComponent component) {
        this.titledBorderContainer.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.titledBorderContainer.setLayout(new BorderLayout());
        this.titledBorderContainer.add((Component)component, "Center");
        this.titledBorder = new ComponentTitledBorder(this.titledBorderContainer);
        this.setBorder(this.titledBorder);
        this.contentPane = new JPanel();
        this.setLayout(null);
        this.add(this.titledBorderContainer);
        this.add(this.contentPane);
    }

    public void setTitledBorderWidth(int width) {
        this.titledBorderContainer.setPreferredSize(new Dimension(width, this.titledBorderContainer.getPreferredSize().height));
    }

    public void setTitledBorderHeight(int height) {
        this.titledBorderContainer.setPreferredSize(new Dimension(this.titledBorderContainer.getPreferredSize().width, height));
    }

    public void setTitledBorderDimension(Dimension dimension) {
        this.titledBorderContainer.setPreferredSize(dimension);
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setContentPaneEnabled(boolean enabled) {
        this.setChildEnabled(this.contentPane, enabled);
    }

    private void setChildEnabled(JComponent component, boolean enabled) {
        component.setEnabled(enabled);
        if (component.getComponentCount() > 0) {
            for (int i = 0; i < component.getComponentCount(); ++i) {
                Component c = component.getComponent(i);
                if (!(c instanceof JComponent)) continue;
                JComponent childComponent = (JComponent)c;
                childComponent.setEnabled(enabled);
                this.setChildEnabled(childComponent, enabled);
            }
        }
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle componentRectangle = this.titledBorder.getComponentRectangle(rectangle, insets);
        this.titledBorder.getComponent().setBounds(componentRectangle);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        this.contentPane.setBounds(rectangle);
    }
}

