/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class JCaptionPanel
extends JPanel
implements Runnable,
SwingConstants {
    private String[] caption;
    private BufferedImage image;
    private int alignment = 1;
    private int speed = 100;
    private int rollOffset = 0;
    private Thread internalThread;
    private volatile boolean noStopRequested;
    private volatile boolean onceRoll = false;
    private boolean autoAdaptSize = false;
    private boolean isAntialiasing = false;

    public JCaptionPanel() {
    }

    public JCaptionPanel(String[] caption) {
        this.setCaption(caption);
    }

    @Override
    public void run() {
        if (this.getCaption() == null || this.getCaption().length == 0) {
            return;
        }
        while (this.noStopRequested) {
            if (this.image == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JCaptionPanel.this.rollOffset = JCaptionPanel.this.getHeight();
                        JCaptionPanel.this.repaint();
                    }
                });
                if (this.image == null) continue;
                if (this.isAutoAdaptSize()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JCaptionPanel.this.setSize(new Dimension(JCaptionPanel.this.image.getWidth(), JCaptionPanel.this.getHeight()));
                        }
                    });
                }
            }
            if (!this.onceRoll) {
                this.rollOffset = this.getAlignment() == 1 ? this.getHeight() : -this.image.getHeight();
                this.onceRoll = true;
            }
            try {
                Thread.sleep(this.getSpeed());
                if (this.image != null) {
                    if (this.getAlignment() == 1) {
                        this.rollOffset = (this.rollOffset - 1) % (this.getHeight() + this.image.getHeight());
                        if (this.rollOffset == -this.image.getHeight()) {
                            this.rollOffset = this.getHeight();
                        }
                    } else {
                        this.rollOffset = (this.rollOffset + 1) % (this.getHeight() + this.image.getHeight());
                        if (this.rollOffset == this.getHeight()) {
                            this.rollOffset = -this.image.getHeight();
                        }
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JCaptionPanel.this.repaint();
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null && this.rollOffset != 0) {
            this.image = this.generateImage(this.getCaption(), g, this.getAlignment(), this.getBackground(), this.getForeground(), this.getFont());
        }
        if (this.image != null) {
            g.drawImage(this.image, 0, this.rollOffset, this);
        }
    }

    private BufferedImage generateImage(String[] caption, Graphics g, int alignment, Color background, Color foreground, Font font) {
        Dimension size;
        if (caption == null || caption.length == 0) {
            return null;
        }
        if (g == null) {
            return null;
        }
        if (background == null) {
            background = Color.white;
        }
        if (foreground == null) {
            foreground = Color.black;
        }
        if ((size = this.getImageSize(caption, g.getFontMetrics())) == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2d = image.createGraphics();
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
        } else {
            g2d.setComposite(AlphaComposite.getInstance(1, 0.0f));
        }
        g2d.fillRect(0, 0, size.width, size.height);
        if (!this.isOpaque()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        g2d.setColor(foreground);
        int baselineOffset = g.getFontMetrics().getHeight();
        if (this.isAntialiasing) {
            RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHints(renderHints);
        }
        FontRenderContext frc = g2d.getFontRenderContext();
        for (int i = 0; i < caption.length; ++i) {
            TextLayout textLayout = null;
            textLayout = alignment == 1 ? new TextLayout(caption[i], font, frc) : new TextLayout(caption[caption.length - (i + 1)], font, frc);
            textLayout.draw(g2d, 0.0f, baselineOffset);
            baselineOffset += g.getFontMetrics().getHeight();
        }
        g2d.dispose();
        g2d = null;
        return image;
    }

    private Dimension getImageSize(String[] caption, FontMetrics fm) {
        if (caption == null || caption.length == 0) {
            return null;
        }
        if (fm == null) {
            return null;
        }
        int width = 0;
        int height = 0;
        width = fm.stringWidth(caption[0]);
        for (int i = 1; i < caption.length; ++i) {
            if (width >= fm.stringWidth(caption[i])) continue;
            width = fm.stringWidth(caption[i]);
        }
        height = fm.getHeight() * caption.length + fm.getHeight();
        return new Dimension(width, height);
    }

    public void start() {
        this.noStopRequested = true;
        this.internalThread = new Thread(this);
        this.internalThread.start();
    }

    public void stop() {
        this.noStopRequested = false;
        if (this.internalThread != null) {
            this.internalThread.interrupt();
        }
    }

    public void reStart() {
        if (this.internalThread != null && this.internalThread.isAlive()) {
            this.stop();
        }
        this.onceRoll = false;
        this.start();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public String[] getCaption() {
        return this.caption;
    }

    public void setCaption(String[] caption) {
        this.caption = caption;
    }

    public boolean isAutoAdaptSize() {
        return this.autoAdaptSize;
    }

    public void setAutoAdaptSize(boolean autoAdaptSize) {
        this.autoAdaptSize = autoAdaptSize;
    }

    public boolean isAntialiasing() {
        return this.isAntialiasing;
    }

    public void setAntialiasing(boolean isAntialiasing) {
        this.isAntialiasing = isAntialiasing;
    }
}

