/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.button;

import com.jidesoft.swing.JideButton;
import com.nepxion.swing.button.IButton;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.listener.DisplayAbilityListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import javax.swing.Action;
import javax.swing.Icon;

public class JStyleButton
extends JideButton
implements IButton {
    protected int widthInset = 5;
    protected int heightInset = 5;
    protected boolean isDimensionAdaptive = true;

    public JStyleButton() {
        this.initComponents();
    }

    public JStyleButton(Action action) {
        super(action);
        this.initComponents();
    }

    public JStyleButton(String text) {
        super(text);
        this.initComponents();
    }

    public JStyleButton(Icon icon) {
        super(icon);
        this.initComponents();
    }

    public JStyleButton(String text, Icon icon) {
        super(text, icon);
        this.initComponents();
    }

    public JStyleButton(String text, String toolTipText) {
        super(text);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JStyleButton(Icon icon, String toolTipText) {
        super(icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    public JStyleButton(String text, Icon icon, String toolTipText) {
        super(text, icon);
        this.initComponents();
        this.setToolTipText(toolTipText);
    }

    private void initComponents() {
        this.addHierarchyListener(new DisplayAbilityListener(){

            @Override
            public void displayAbilityChanged(HierarchyEvent e) {
                JStyleButton.this.adaptDimension();
                JStyleButton.this.removeHierarchyListener(this);
            }
        });
    }

    private void adaptDimension() {
        if (this.isDimensionAdaptive) {
            Dimension dimension = this.getPreferredSize();
            int width = dimension.width;
            width = width % 2 != 0 ? (width += this.widthInset) : (width += this.widthInset + 1);
            dimension.width = width;
            int height = dimension.height;
            height = height % 2 != 0 ? (height += this.heightInset) : (height += this.heightInset + 1);
            dimension.height = height;
            this.setDimension(dimension);
        }
    }

    @Override
    public int getWidthInset() {
        return this.widthInset;
    }

    @Override
    public void setWidthInset(int widthInset) {
        this.widthInset = widthInset;
    }

    @Override
    public int getHeightInset() {
        return this.heightInset;
    }

    @Override
    public void setHeightInset(int heightInset) {
        this.heightInset = heightInset;
    }

    @Override
    public void setDimension(Dimension dimension) {
        DimensionManager.setDimension((Component)((Object)this), dimension);
        this.isDimensionAdaptive = false;
    }
}

