/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.Color;
import java.awt.Rectangle;
import twaver.AbstractElement;
import twaver.Element;
import twaver.Generator;
import twaver.base.A.E.b;
import twaver.base.A.H.I;
import twaver.web.WebUtil;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.ElementSVGUI;

public abstract class AbstractElementSVGUI
implements ElementSVGUI {
    protected TSVGNetwork network;
    protected AbstractElement element;

    public AbstractElementSVGUI(TSVGNetwork network, AbstractElement element) {
        this.network = network;
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public TSVGNetwork getNetwork() {
        return this.network;
    }

    public SVGStruct toSVG(SVGContext context) {
        SVGStruct struct;
        SVGStruct svgStruct = context.getSVGStruct(this.element);
        if (svgStruct != null) {
            return svgStruct;
        }
        StringBuffer head = new StringBuffer();
        Rectangle bounds = null;
        StringBuffer sb = new StringBuffer();
        this.appendCustomerSVGBeforeBody(sb, context);
        boolean underneath = this.element.isBorderUnderneath();
        if (underneath) {
            struct = this.toBorderSVG(context);
            sb.append(struct.getSvg());
            if (struct.getBounds() != null) {
                bounds = struct.getBounds();
            }
        }
        struct = this.toBodySVG(context);
        sb.append(struct.getSvg());
        if (struct.getBounds() != null) {
            context.registerBounds(this.element, struct.getBounds());
            if (bounds == null) {
                bounds = struct.getBounds();
            } else {
                bounds.add(struct.getBounds());
            }
        }
        head.append("<g");
        this.prepareElementSVGHeader(context, head);
        if (bounds != null) {
            int borderInsets = b.J(this.element, "border.insets");
            Color borderColor = this.network.getElementSelectColor(this.element);
            bounds.grow(borderInsets, borderInsets);
            head.append(" bx='").append(bounds.x + bounds.width / 2).append("'").append(" by='").append(bounds.y + bounds.height / 2).append("'").append(" bwidth='").append(bounds.width).append("'").append(" bheight='").append(bounds.height).append("'").append(" bcolor='");
            I.B(head, borderColor);
            head.append("'");
        }
        head.append(">\n");
        struct = this.toAttachmentSVG(context);
        sb.append(struct.getSvg());
        bounds = this.getBounds(struct, bounds);
        if (!underneath) {
            struct = this.toBorderSVG(context);
            sb.append(struct.getSvg());
            bounds = this.getBounds(struct, bounds);
        }
        this.appendElementBodyProperties(sb, context);
        this.appendCustomerSVGAfterBody(sb, context);
        sb.append("</g>");
        svgStruct = new SVGStruct(head.append(sb).toString(), bounds);
        context.registerSVGStruct(this.element, svgStruct);
        return svgStruct;
    }

    protected void prepareElementSVGHeader(SVGContext context, StringBuffer head) {
        String toolTipText;
        head.append(this.toAttributesSVG(context));
        context.appendElementHeadCustomAttribute(head, this.element);
        if (!this.network.isSelectable(this.element)) {
            I.C(head);
        }
        if (!this.network.isMovable(this.element)) {
            head.append(" elementMovable='false'");
        }
        if (this.network.isResizable(this.element)) {
            head.append(" elementResizable='true'");
        }
        if (context.isEnableElementTooltip() && !I.C(toolTipText = this.network.getCanvasToolTipText(this.element))) {
            if (context.isEscapeText()) {
                toolTipText = WebUtil.htmlEscape(toolTipText);
            }
            head.append(" tooltip='").append(toolTipText).append("'");
        }
    }

    protected void appendCustomerSVGBeforeBody(StringBuffer sb, SVGContext context) {
    }

    private boolean A() {
        return this.network.getBlinkingRule().isElementBodyBlinkable(this.element);
    }

    private boolean B() {
        return this.network.getBlinkingRule().isAlarmAttachmentBlinkable(this.element);
    }

    protected void appendElementBodyProperties(StringBuffer sb, SVGContext context) {
        Generator generator = context.getElementBodyCustomAttributeGenerator();
        if (generator != null) {
            sb.append("<up ");
            context.appendElementBodyCustomAttribute(sb, this.element);
            sb.append("/>");
        }
        if (this.A()) {
            int blinkSpeed = b.J(this.element, "blink.body.speed");
            I.A(sb, "visibility", "indefinite", "hidden", blinkSpeed, "remove");
        }
    }

    protected void appendCustomerSVGAfterBody(StringBuffer sb, SVGContext context) {
    }

    protected Rectangle getBounds(SVGStruct struct, Rectangle bounds) {
        Rectangle structBounds = struct.getBounds();
        if (structBounds == null) {
            return bounds;
        }
        if (bounds == null) {
            bounds = structBounds;
        } else {
            bounds.add(structBounds);
        }
        return bounds;
    }

    protected String toAttributesSVG(SVGContext context) {
        StringBuffer sb = new StringBuffer();
        I.A(sb, "id", this.element.getID().toString());
        sb.append(" ");
        return sb.toString();
    }

    protected SVGStruct toBodySVG(SVGContext context) {
        return SVGStruct.EMPTY;
    }

    protected SVGStruct toBorderSVG(SVGContext context) {
        return SVGStruct.EMPTY;
    }

    protected SVGStruct toAttachmentSVG(SVGContext context) {
        String structSvg;
        StringBuffer sb = new StringBuffer();
        Rectangle bounds = null;
        SVGStruct struct = this.toLabelAttachmentSVG(context);
        sb.append(struct.getSvg());
        bounds = this.getBounds(struct, bounds);
        struct = this.toIconAttachmentSVG(context);
        sb.append(struct.getSvg());
        bounds = this.getBounds(struct, bounds);
        boolean minimized = this.element.isMessageMinimized();
        if (minimized) {
            I.A(sb, this.network, context, this.element);
        } else {
            struct = this.toMessageAttachmentSVG(context);
            structSvg = struct.getSvg();
            if (structSvg != null && !"".equals(structSvg)) {
                if (this.element.isMessageShownOnTop()) {
                    context.registerMessageAttachment(this.element, structSvg);
                } else {
                    sb.append(structSvg);
                }
            }
            bounds = this.getBounds(struct, bounds);
        }
        if (this.network.isAlarmBalloonVisible() && !I.C(structSvg = (struct = this.toAlarmAttachmentSVG(context)).getSvg())) {
            if (context.isShowAlarmOnTop()) {
                context.registerAlarmAttachment(this.element, structSvg);
            } else {
                sb.append(structSvg);
            }
        }
        bounds = this.getBounds(struct, bounds);
        return new SVGStruct(sb.toString(), bounds);
    }

    protected SVGStruct toAlarmAttachmentSVG(SVGContext context) {
        return I.A(this.network, context, this.element, this.B());
    }

    protected SVGStruct toMessageAttachmentSVG(SVGContext context) {
        return I.A(this.network, context, this.element);
    }

    protected SVGStruct toLabelAttachmentSVG(SVGContext context) {
        return I.B(this.network, context, this.element);
    }

    protected SVGStruct toIconAttachmentSVG(SVGContext context) {
        return I.A(this.network, context, (ElementSVGUI)this);
    }

    protected String getGradientID(SVGContext context, int type, Color gradientColor, Color fillColor) {
        String id = WebUtil.getGradientID(type, gradientColor, fillColor);
        if (id != null) {
            context.registerGradientID(id);
        }
        return id;
    }

    protected Object getFillObject(SVGContext context, Color color) {
        String type = this.element.getTextureFactory();
        if (type == null) {
            return color;
        }
        String id = WebUtil.getTextureID(type, color);
        context.registerTexturePatternID(type, id);
        return id;
    }

    protected Color getPaintBodyColor(Color naturalBodyColor) {
        Color color;
        Generator generator = this.network.getElementBodyColorGenerator();
        Color color2 = color = generator == null ? null : (Color)generator.generate(this.element);
        if (color != null) {
            return color;
        }
        return naturalBodyColor;
    }

    protected Color getStateOutlineColor() {
        Generator generator = this.network.getElementStateOutlineColorGenerator();
        return generator == null ? null : (Color)generator.generate(this.element);
    }

    protected float getRenderAlpha() {
        float renderAlpha = this.element.getRenderAlpha();
        if (renderAlpha < 0.0f || renderAlpha > 1.0f) {
            renderAlpha = 1.0f;
        }
        return renderAlpha;
    }
}

