/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import twaver.TDataBox;
import twaver.TView;

public abstract class ButtonEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    public static final String COMMAND_EDIT = "edit";
    public static final String COMMAND_OK = "ok";
    public static final String COMMAND_CANCEL = "cancel";
    protected JTable table;
    protected Object value;
    protected JButton button = new JButton();
    protected int row;
    protected int column;
    protected TDataBox box;

    public ButtonEditor() {
        this.button.setActionCommand(COMMAND_EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    public void actionPerformed(ActionEvent e2) {
        if (COMMAND_EDIT.equalsIgnoreCase(e2.getActionCommand())) {
            this.editPerformed();
            this.fireEditingStopped();
        }
        if (COMMAND_OK.equalsIgnoreCase(e2.getActionCommand())) {
            this.okPerformed();
            this.fireEditingStopped();
        }
        if (COMMAND_CANCEL.equalsIgnoreCase(e2.getActionCommand())) {
            this.cancelPerformed();
            this.fireEditingCanceled();
        }
    }

    public abstract void editPerformed();

    public abstract void okPerformed();

    public abstract void cancelPerformed();

    public Object getCellEditorValue() {
        return this.value;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.value = value;
        this.row = row;
        this.column = column;
        if (table instanceof TView) {
            TView view = (TView)((Object)table);
            this.box = view.getDataBox();
        } else {
            this.box = null;
        }
        return this.button;
    }
}

