/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import twaver.TWaverUtil;
import twaver.swing.TComboBox;

public abstract class AbstractCellEditor
extends DefaultCellEditor {
    public static final Object[] OPTIONS = new Object[]{TWaverUtil.getString("CONFIRM")};
    protected JTable table = null;
    protected Object value = null;
    protected int row = -1;
    protected int column = -1;
    boolean B = false;
    boolean A = false;

    public AbstractCellEditor() {
        super(new JTextField());
        this.setClickCountToStart(TWaverUtil.CLICK_COUNT_TO_START);
        JTextField textField = (JTextField)this.getComponent();
        textField.setHorizontalAlignment(4);
    }

    public AbstractCellEditor(JTextField textField) {
        super(textField);
        this.setClickCountToStart(TWaverUtil.CLICK_COUNT_TO_START);
        textField.setHorizontalAlignment(4);
    }

    public AbstractCellEditor(Object[] values) {
        super(new TComboBox(values));
        this.setClickCountToStart(TWaverUtil.CLICK_COUNT_TO_START);
    }

    public boolean stopCellEditing() {
        if (this.A) {
            return super.stopCellEditing();
        }
        Object newValue = this.getCellEditorValue();
        if (newValue == this.value) {
            return super.stopCellEditing();
        }
        if (newValue != null && this.value != null && newValue.equals(this.value)) {
            return super.stopCellEditing();
        }
        boolean isValid = true;
        try {
            isValid = this.validInputValue(newValue);
        }
        catch (Exception e2) {
            isValid = false;
        }
        if (isValid) {
            return super.stopCellEditing();
        }
        this.cancelCellEditing();
        JOptionPane.showOptionDialog(TWaverUtil.getWindowForComponent(this.table), this.getInvalidMessage(), this.getInvalidTitle(), 1, 0, null, OPTIONS, OPTIONS[0]);
        return true;
    }

    public String getInvalidMessage() {
        String message = TWaverUtil.getString("INVALID_MESSAGE");
        Object value = this.delegate.getCellEditorValue();
        try {
            return message.replaceFirst("%value", value + "");
        }
        catch (Exception ex) {
            return message.replaceFirst(" '%value'", "");
        }
    }

    public String getInvalidTitle() {
        return TWaverUtil.getString("INVALID_TITLE");
    }

    public boolean validInputValue(Object inputValue) {
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.value = value;
        this.B = isSelected;
        this.row = row;
        this.column = column;
        this.A = true;
        Component component = super.getTableCellEditorComponent(table, this.getDisplayValue(value), isSelected, row, column);
        this.A = false;
        return component;
    }

    protected Object getDisplayValue(Object originalValue) {
        return originalValue;
    }
}

