/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twaver.Element;
import twaver.Layer;
import twaver.LayerModelListener;
import twaver.TWaverUtil;

public class LayerModel
implements Serializable,
PropertyChangeListener {
    private List C = new ArrayList();
    private Map E = new HashMap();
    private Layer D = new Layer(null, TWaverUtil.getString("layer.default"));
    private transient List B = new ArrayList();
    private transient List A = new ArrayList();

    public LayerModel() {
        this.addLayer(this.D);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.B = new ArrayList();
        this.A = new ArrayList();
    }

    public void addLayerModelListener(LayerModelListener l2) {
        if (!this.B.contains(l2)) {
            this.B.add(l2);
        }
    }

    public void removeLayerModelListener(LayerModelListener l2) {
        this.B.remove(l2);
    }

    public void addLayerPropertyChangeListener(PropertyChangeListener l2) {
        if (!this.A.contains(l2)) {
            this.A.add(l2);
        }
    }

    public void removeLayerPropertyChangeListener(PropertyChangeListener l2) {
        this.A.remove(l2);
    }

    public void addLayer(Layer layer) {
        this.addLayer(this.C.size(), layer);
    }

    public void addLayer(int index, Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Layer can not be null.");
        }
        if (this.E.containsKey(layer.getID())) {
            throw new IllegalArgumentException("Layer with ID '" + layer.getID() + "' already exist");
        }
        this.C.add(index, layer);
        this.E.put(layer.getID(), layer);
        layer.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.A(layer);
        this.A();
    }

    public void removeLayerByID(Object layerID) {
        Layer layer = this.getLayerByID(layerID);
        this.removeLayer(layer);
    }

    public void removeLayer(Layer layer) {
        if (layer == null) {
            return;
        }
        if (layer == this.D) {
            throw new IllegalArgumentException("The default layer can not be removed.");
        }
        this.C.remove(layer);
        this.E.remove(layer.getID());
        this.B(layer);
        layer.getPropertyChangeSupport().removePropertyChangeListener(this);
        this.A();
    }

    public Layer getLayerByID(Object layerID) {
        return (Layer)this.E.get(layerID);
    }

    public Layer getLayerByIndex(int index) {
        if (index >= 0 && index < this.C.size()) {
            return (Layer)this.C.get(index);
        }
        return null;
    }

    public List getLayers() {
        return this.C;
    }

    public Iterator iterator() {
        return this.C.iterator();
    }

    private void A(Layer layer) {
        for (int i2 = 0; i2 < this.B.size(); ++i2) {
            LayerModelListener l2 = (LayerModelListener)this.B.get(i2);
            l2.layerAdded(layer);
        }
    }

    private void B(Layer layer) {
        for (int i2 = 0; i2 < this.B.size(); ++i2) {
            LayerModelListener l2 = (LayerModelListener)this.B.get(i2);
            l2.layerRemoved(layer);
        }
    }

    private void A() {
        for (int i2 = 0; i2 < this.B.size(); ++i2) {
            LayerModelListener l2 = (LayerModelListener)this.B.get(i2);
            l2.layerIndexChanged();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        for (int i2 = 0; i2 < this.A.size(); ++i2) {
            PropertyChangeListener l2 = (PropertyChangeListener)this.A.get(i2);
            l2.propertyChange(evt);
        }
    }

    public int size() {
        return this.C.size();
    }

    public void clear() {
        block0: while (this.size() > 1) {
            for (int i2 = 0; i2 < this.C.size(); ++i2) {
                Layer layer = (Layer)this.C.get(i2);
                if (layer == this.D) continue;
                this.removeLayer(layer);
                continue block0;
            }
        }
    }

    public boolean contains(Element element, Layer layer) {
        if (element == null || layer == null) {
            return false;
        }
        Object elementLayerID = element.getLayerID();
        if (elementLayerID == null) {
            return layer == this.D;
        }
        if (layer.getID() == null) {
            return !this.E.containsKey(elementLayerID);
        }
        return layer.getID().equals(elementLayerID);
    }

    public boolean contains(Layer layer) {
        if (layer == null) {
            return false;
        }
        return this.E.containsKey(layer.getID());
    }

    public int indexOfLayer(Layer layer) {
        return this.C.indexOf(layer);
    }

    public void moveToTop(Layer layer) {
        if (!this.contains(layer)) {
            return;
        }
        if (this.C.get(0) == layer) {
            return;
        }
        this.C.remove(layer);
        this.C.add(0, layer);
        this.A();
    }

    public void moveToUp(Layer layer) {
        if (!this.contains(layer)) {
            return;
        }
        int index = this.C.indexOf(layer);
        if (index == 0) {
            return;
        }
        this.C.remove(layer);
        this.C.add(index - 1, layer);
        this.A();
    }

    public void moveToDown(Layer layer) {
        if (!this.contains(layer)) {
            return;
        }
        int index = this.C.indexOf(layer);
        if (index == this.C.size() - 1) {
            return;
        }
        this.C.remove(layer);
        this.C.add(index + 1, layer);
        this.A();
    }

    public void moveToBottom(Layer layer) {
        if (!this.contains(layer)) {
            return;
        }
        if (this.C.get(this.C.size() - 1) == layer) {
            return;
        }
        this.C.remove(layer);
        this.C.add(layer);
        this.A();
    }

    public void moveTo(Layer layer, int layerIndex) {
        if (!this.contains(layer)) {
            return;
        }
        if (layerIndex < 0 || layerIndex >= this.C.size()) {
            return;
        }
        if (this.C.indexOf(layer) == layerIndex) {
            return;
        }
        this.C.remove(layer);
        this.C.add(layerIndex, layer);
        this.A();
    }

    public Layer getDefaultLayer() {
        return this.D;
    }

    public boolean isMovable(Element element) {
        if (element == null) {
            return false;
        }
        Layer layer = this.getLayerByID(element.getLayerID());
        if (layer != null) {
            return layer.isMovable();
        }
        return this.D.isMovable();
    }

    public boolean isResizable(Element element) {
        if (element == null) {
            return false;
        }
        Layer layer = this.getLayerByID(element.getLayerID());
        if (layer != null) {
            return layer.isResizable();
        }
        return this.D.isResizable();
    }

    public boolean isSelectable(Element element) {
        if (element == null) {
            return false;
        }
        Layer layer = this.getLayerByID(element.getLayerID());
        if (layer != null) {
            return layer.isSelectable();
        }
        return this.D.isSelectable();
    }

    public boolean isVisible(Element element) {
        if (element == null) {
            return false;
        }
        Layer layer = this.getLayerByID(element.getLayerID());
        if (layer != null) {
            return layer.isVisible();
        }
        return this.D.isVisible();
    }
}

