/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.Comparator;
import java.util.Hashtable;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;
import y.layout.planar.Face;
import y.layout.planar.FaceCursor;
import y.layout.planar.PlanarInformation;
import y.layout.planar.SimplePlanarInformation;
import y.layout.planar.SubdivisionHandler;
import y.util.Maps;

public class DualPlanarInformation
extends SimplePlanarInformation
implements SubdivisionHandler {
    private Graph q;
    private EdgeMap l;
    private EdgeMap m;
    private Hashtable k;
    private NodeMap n;
    private boolean o = false;
    private boolean p = false;
    private SimplePlanarInformation j;

    public DualPlanarInformation(SimplePlanarInformation simplePlanarInformation) {
        this(simplePlanarInformation, null);
    }

    public DualPlanarInformation(SimplePlanarInformation simplePlanarInformation, EdgeList edgeList) {
        super(new Graph());
        this.j = simplePlanarInformation;
        this.q = this.j.getGraph();
        if (edgeList != null) {
            EdgeCursor edgeCursor = edgeList.edges();
            while (edgeCursor.ok()) {
                this.q.unhide(edgeCursor.edge());
                edgeCursor.next();
            }
        }
        this.k = new Hashtable();
        this.l = super.getGraph().createEdgeMap();
        this.m = this.q.createEdgeMap();
        this.n = super.getGraph().createNodeMap();
        if (edgeList != null) {
            EdgeCursor edgeCursor = edgeList.edges();
            while (edgeCursor.ok()) {
                this.q.hide(edgeCursor.edge());
                edgeCursor.next();
            }
        }
        this.computeDualGraph();
    }

    public void subscribe() {
        if (this.j instanceof PlanarInformation) {
            ((PlanarInformation)this.j).addSubdivisionHandler(this);
        }
    }

    public void unsubscribe() {
        if (this.j instanceof PlanarInformation) {
            ((PlanarInformation)this.j).removeSubdivisionHandler(this);
        }
    }

    public Face getRealFace(Node node) {
        if (!this.p) {
            throw new RuntimeException("Wrong execution order: call computeDualGraph() first!");
        }
        return (Face)this.n.get(node);
    }

    public Node getDualNode(Face face) {
        if (!this.p) {
            throw new RuntimeException("Wrong execution order: call computeDualGraph() first!");
        }
        return (Node)this.k.get(face);
    }

    public Edge getRealEdge(Edge edge) {
        if (!this.p) {
            throw new RuntimeException("Wrong execution order: call computeDualGraph() first!");
        }
        return (Edge)this.l.get(edge);
    }

    public Edge getDualEdge(Edge edge) {
        if (!this.p) {
            throw new RuntimeException("Wrong execution order: call computeDualGraph() first!");
        }
        return (Edge)this.m.get(edge);
    }

    public void computeDualGraph() {
        Object object;
        Object object2;
        Graph graph = this.getGraph();
        graph.clear();
        this.k.clear();
        FaceCursor faceCursor = this.j.faces();
        while (faceCursor.ok()) {
            object2 = faceCursor.face();
            object = graph.createNode();
            this.a((Face)object2, (Node)object);
            faceCursor.next();
        }
        object2 = this.j.faces();
        while (object2.ok()) {
            object = object2.face();
            Node node = (Node)this.k.get(object);
            EdgeCursor edgeCursor = ((Face)object).edges();
            edgeCursor.toLast();
            while (edgeCursor.ok()) {
                Edge edge = null;
                Edge edge2 = edgeCursor.edge();
                Edge edge3 = this.j.getReverse(edge2);
                edge = (Edge)this.m.get(edge3);
                Node node2 = (Node)this.k.get(this.j.faceOf(edge3));
                Edge edge4 = graph.createEdge(node, node2);
                if (edge != null) {
                    this.setReverse(edge, edge4);
                    if (edge.source() != edge4.target() && edge.target() != edge4.source()) {
                        throw new RuntimeException(" ***** Error setting reverse edge *****");
                    }
                }
                this.a(edge2, edge4);
                edgeCursor.prev();
            }
            object2.next();
        }
        boolean bl = this.o = graph.edgeCount() == this.q.edgeCount() && this.j.faceList.size() == this.k.size();
        if (!this.o) {
            throw new RuntimeException("Error computing dual graph!");
        }
        this.p = true;
    }

    public void createCircularEdgeOrder() {
        Object object;
        final EdgeMap edgeMap = Maps.createIndexEdgeMap(new int[this.q.E()]);
        this.calcFaces();
        FaceCursor faceCursor = this.faces();
        while (faceCursor.ok()) {
            object = faceCursor.face();
            EdgeCursor edgeCursor = ((Face)object).edges();
            int n = 0;
            while (edgeCursor.ok()) {
                Edge edge = (Edge)this.l.get(edgeCursor.edge());
                edgeMap.setInt(this.j.getReverse(edge), n++);
                edgeCursor.next();
            }
            faceCursor.next();
        }
        object = this.q.nodes();
        while (object.ok()) {
            object.node().sortOutEdges(new Comparator(){

                public int compare(Object object, Object object2) {
                    int n;
                    Edge edge = (Edge)object;
                    Edge edge2 = (Edge)object2;
                    int n2 = edgeMap.getInt(edge);
                    if (n2 == (n = edgeMap.getInt(edge2))) {
                        return 0;
                    }
                    if (n2 < n) {
                        return 1;
                    }
                    return -1;
                }
            });
            object.next();
        }
    }

    public void subdivide(Edge edge, Edge[] edgeArray) {
        Edge edge2 = this.getDualEdge(edge);
        if (edge2 == null) {
            return;
        }
        Edge edge3 = this.j.getReverse(edge);
        Face face = this.j.faceOf(edge);
        Node node = this.getDualNode(face);
        Face face2 = this.j.faceOf(edge3);
        Node node2 = this.getDualNode(face2);
        Edge edge4 = this.getDualEdge(edge3);
        Edge edge5 = edge2;
        Edge edge6 = edge4;
        int n = 0;
        while (n < edgeArray.length) {
            Edge edge7 = edgeArray[n];
            Edge edge8 = this.j.getReverse(edge7);
            Edge edge9 = this.graph.createEdge(node, edge5, node2, null, 0, 0);
            Edge edge10 = this.graph.createEdge(node2, edge6, node, null, 1, 1);
            this.setReverse(edge9, edge10);
            this.a(edge7, edge9);
            this.a(edge8, edge10);
            edge5 = edge9;
            ++n;
        }
        this.m.set(edge, null);
        this.m.set(edge3, null);
        this.graph.removeEdge(edge2);
        this.graph.removeEdge(edge4);
        this.checkConsistency();
    }

    public void unsubdivide(Edge[] edgeArray, Edge edge) {
        Edge edge2 = this.j.getReverse(edge);
        Face face = this.j.faceOf(edge);
        Node node = this.getDualNode(face);
        Face face2 = this.j.faceOf(edge2);
        Node node2 = this.getDualNode(face2);
        Edge edge3 = this.graph.createEdge(node, node2);
        Edge edge4 = this.graph.createEdge(node2, node);
        this.setReverse(edge3, edge4);
        this.a(edge, edge3);
        this.a(edge2, edge4);
        int n = 0;
        while (n < edgeArray.length) {
            Edge edge5 = edgeArray[n];
            Edge edge6 = this.j.getReverse(edge5);
            Edge edge7 = this.getDualEdge(edge5);
            Edge edge8 = this.getDualEdge(edge6);
            this.m.set(edge5, null);
            this.m.set(edge6, null);
            this.graph.removeEdge(edge7);
            this.graph.removeEdge(edge8);
            ++n;
        }
        this.checkConsistency();
    }

    public void splitFace(Edge edge, Face[] faceArray, Face[] faceArray2) {
        Edge edge2 = this.j.getReverse(edge);
        Node[] nodeArray = new Node[faceArray.length];
        int n = 0;
        while (n < faceArray.length) {
            nodeArray[n] = (Node)this.k.get(faceArray[n]);
            ++n;
        }
        Node[] nodeArray2 = new Node[faceArray2.length];
        int n2 = 0;
        while (n2 < faceArray2.length) {
            nodeArray2[n2] = this.graph.createNode();
            this.a(faceArray2[n2], nodeArray2[n2]);
            ++n2;
        }
        Edge edge3 = null;
        Edge edge4 = null;
        int n3 = 0;
        while (n3 < faceArray2.length) {
            Node node = nodeArray2[n3];
            EdgeCursor edgeCursor = faceArray2[n3].edges();
            while (edgeCursor.ok()) {
                Edge edge5 = edgeCursor.edge();
                if (edge5 == edge) {
                    edge3 = this.graph.createEdge(node, this.getDualNode(this.j.faceOf(edge2)));
                } else if (edge5 == edge2) {
                    edge4 = this.graph.createEdge(node, this.getDualNode(this.j.faceOf(edge)));
                } else {
                    Edge edge6 = this.j.getReverse(edgeCursor.edge());
                    Edge edge7 = this.getDualEdge(edge5);
                    Edge edge8 = this.getDualEdge(edge6);
                    this.graph.changeEdge(edge7, node, edge7.target());
                    this.graph.changeEdge(edge8, edge8.source(), node);
                }
                edgeCursor.next();
            }
            ++n3;
        }
        this.setReverse(edge3, edge4);
        this.a(edge, edge3);
        this.a(edge2, edge4);
        int n4 = 0;
        while (n4 < nodeArray.length) {
            this.graph.removeNode(nodeArray[n4]);
            ++n4;
        }
        this.checkConsistency();
    }

    public void unsplitFace(Edge edge, Face[] faceArray, Face[] faceArray2) {
        Node[] nodeArray = new Node[faceArray.length];
        int n = 0;
        while (n < faceArray.length) {
            nodeArray[n] = (Node)this.k.get(faceArray[n]);
            ++n;
        }
        Node[] nodeArray2 = new Node[faceArray2.length];
        int n2 = 0;
        while (n2 < faceArray2.length) {
            nodeArray2[n2] = this.graph.createNode();
            this.a(faceArray2[n2], nodeArray2[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < faceArray2.length) {
            Node node = nodeArray2[n3];
            EdgeCursor edgeCursor = faceArray2[n3].edges();
            while (edgeCursor.ok()) {
                Edge edge2 = edgeCursor.edge();
                Edge edge3 = this.j.getReverse(edgeCursor.edge());
                Edge edge4 = this.getDualEdge(edge2);
                Edge edge5 = this.getDualEdge(edge3);
                this.graph.changeEdge(edge4, node, edge4.target());
                this.graph.changeEdge(edge5, edge5.source(), node);
                edgeCursor.next();
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < nodeArray.length) {
            this.graph.removeNode(nodeArray[n4]);
            ++n4;
        }
        this.checkConsistency();
    }

    public void dispose() {
        super.dispose();
        Graph graph = this.getGraph();
        graph.disposeEdgeMap(this.l);
        this.q.disposeEdgeMap(this.m);
        graph.disposeNodeMap(this.n);
        this.k.clear();
    }

    private void a(Face face, Node node) {
        this.k.put(face, node);
        this.n.set(node, face);
    }

    private void a(Edge edge, Edge edge2) {
        this.l.set(edge2, edge);
        this.m.set(edge, edge2);
    }

    protected void checkConsistency() {
    }
}

