/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.popupmenu;

import com.nepxion.swing.gradient.JGradientPainter;
import com.nepxion.swing.popupmenu.PopupMenuManager;
import com.nepxion.swing.style.framework.IStyle;
import com.nepxion.swing.style.framework.StyleManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.JPopupMenu;

public class PopupMenuPainter {
    private JPopupMenu popupMenu;
    private String title;
    private int width;
    private Font font;
    private Color gradientColor;
    private Color foreground;
    private Color background;

    public PopupMenuPainter(String title) {
        this(title, StyleManager.getStyle());
    }

    public PopupMenuPainter(IStyle style) {
        this("", style);
    }

    public PopupMenuPainter(String title, IStyle style) {
        this(title, 25, new Font("Verdana", 1, 9), style.getSelectionGradientColor(), style.getSelectionForeground(), style.getSelectionBackground());
    }

    public PopupMenuPainter(String title, int width, Font font, Color gradientColor, Color foreground, Color background) {
        this.font = font;
        this.title = title;
        this.width = width;
        this.font = font;
        this.gradientColor = gradientColor;
        this.foreground = foreground;
        this.background = background;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public Insets getInsets(Insets insets) {
        insets.left += this.width;
        return insets;
    }

    protected Dimension getTextSize(String text, Font font, Graphics2D graphics2D) {
        Font graphics2DFont = graphics2D.getFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int i = (int)font.getStringBounds(text, fontRenderContext).getWidth();
        int j = (int)font.getStringBounds(text, fontRenderContext).getHeight();
        graphics2D.setFont(graphics2DFont);
        return new Dimension(i, j);
    }

    protected int getTextOffset(String text, Font font, Graphics2D graphics2D) {
        Font graphics2DFont = graphics2D.getFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int i = (int)font.getStringBounds(text, fontRenderContext).getHeight();
        LineMetrics linemetrics = font.getLineMetrics(text, fontRenderContext);
        int j = (int)linemetrics.getDescent();
        graphics2D.setFont(graphics2DFont);
        return i - j;
    }

    protected void paintString(String title, Graphics2D graphics2D, double x, double y, double angle) {
        graphics2D.translate(x, y);
        graphics2D.rotate(angle);
        graphics2D.drawString(title, 0, 0);
        graphics2D.rotate(-angle);
        graphics2D.translate(-x, -y);
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.popupMenu.getSize();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle rectangle = new Rectangle(0, 0, this.width, size.height - PopupMenuManager.getMargin());
        JGradientPainter.fastFill((Graphics2D)g, rectangle, this.background, this.gradientColor, true);
        if (this.title != null && this.font != null) {
            g2.setColor(this.foreground);
            g2.setFont(this.font);
            Dimension textSize = this.getTextSize(this.title, this.font, g2);
            int y = (size.height + textSize.width) / 2;
            int xOffset = this.getTextOffset(this.title, this.font, g2);
            if (size.height - textSize.width > 5) {
                this.paintString(this.title, g2, (this.width - textSize.height) / 2 + xOffset, y, -1.5707963267948966);
            }
        }
    }
}

