/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.VisibleFilter;
import twaver.base.A.J.D;
import twaver.base.A.J.G;
import twaver.base.A.J.H;
import twaver.table.TElementTable;
import twaver.table.TTableColumn;
import twaver.table.TTableModel;
import twaver.table.TTableRowFilter;
import twaver.tree.TTree;

public class TTreeTable
extends TElementTable {
    public static final TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private boolean \u0255 = TUIManager.getBoolean("table.tree.column.movable");

    public boolean isTreeColumnMovable() {
        return this.\u0255;
    }

    public void setTreeColumnMovable(boolean treeColumnMovable) {
        this.\u0255 = treeColumnMovable;
    }

    public TTreeTable() {
        this(new TDataBox());
    }

    public TTreeTable(TDataBox box) {
        super(box);
    }

    protected TTableModel createTTableModel() {
        return new G(this);
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        this.getTree().addVisibleFilter(visibleFilter);
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        this.getTree().removeVisibleFilter(visibleFilter);
    }

    public List getVisibleFilters() {
        return this.getTree().getVisibleFilters();
    }

    public void addRowFilter(TTableRowFilter rowFilter) {
        if (rowFilter != this.filter) {
            throw new UnsupportedOperationException("Uses #addVisibleFilter to replace");
        }
        super.addRowFilter(rowFilter);
    }

    protected void addElement(Element element) {
        if (!this.elementIDMapper.containsKey(element.getID())) {
            TElementTable._A data = new TElementTable._A(element);
            this.elementIDMapper.put(element.getID(), data);
            this.tableModel.addRow(data.B);
            this.rowOIDMapper.put(data.B.get(0), data);
        }
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        TTree tree = this.getTree();
        if (tree != null && tree.getRowHeight() != rowHeight) {
            tree.setRowHeight(this.getRowHeight());
        }
    }

    public void updateUI() {
        super.updateUI();
        TTree tree = this.getTree();
        if (tree != null) {
            tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public boolean isInCheckState() {
        TTree tree = this.getTree();
        return tree != null && tree.getTTreeSelectionMode() != 0;
    }

    protected void syncSelectionFromDataBoxToView() {
        if (this.isInCheckState() || !this.isAutoSyncSelectionFromDataBoxToView()) {
            return;
        }
        super.syncSelectionFromDataBoxToView();
    }

    protected void syncSelectionFromViewToDataBox(final List selectedRows) {
        if (this.isInCheckState() || !this.isAutoSyncSelectionFromViewToDataBox()) {
            return;
        }
        boolean isRootNodeRowSelected = false;
        if (selectedRows != null) {
            for (int i2 = 0; i2 < selectedRows.size(); ++i2) {
                Vector rowData = (Vector)selectedRows.get(i2);
                if (rowData.get(0) != null) continue;
                isRootNodeRowSelected = true;
                break;
            }
        }
        if (isRootNodeRowSelected) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArrayList<Element> selectedElements = new ArrayList<Element>();
                    if (selectedRows != null) {
                        for (int i2 = 0; i2 < selectedRows.size(); ++i2) {
                            Vector rowData = (Vector)selectedRows.get(i2);
                            Element element = TTreeTable.this.getElementByOID(rowData.get(0));
                            if (element == null) continue;
                            selectedElements.add(element);
                        }
                    }
                    TTreeTable.this.box.getSelectionModel().setSelection(selectedElements);
                }
            });
        } else {
            super.syncSelectionFromViewToDataBox(selectedRows);
        }
    }

    protected Object readElementPropertyValue(Element element, TTableColumn column) {
        if (column == this.getTTreeTableModel().B()) {
            return null;
        }
        if (!this.interested(element)) {
            return null;
        }
        return super.readElementPropertyValue(element, column);
    }

    protected void writeElementPropertyValue(Element element, TTableColumn column, Object value) {
        if (column == this.getTTreeTableModel().B()) {
            return;
        }
        if (!this.interested(element)) {
            return;
        }
        super.writeElementPropertyValue(element, column, value);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        G model;
        TTableColumn tableColumn;
        Element element = this.getElementByRowIndex(row);
        if (!this.interested(element) && (tableColumn = (TTableColumn)this.getColumnModel().getColumn(column)) != (model = this.getTTreeTableModel()).B() && tableColumn != model.getOIDColumn() && tableColumn != model.getCheckColumn()) {
            return defaultRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    protected Iterator iterator() {
        return this.box.getAllElementsReverse().iterator();
    }

    public G getTTreeTableModel() {
        return (G)this.tableModel;
    }

    public TTree getTree() {
        G model = this.getTTreeTableModel();
        if (model != null) {
            return model.E();
        }
        return null;
    }

    public Comparator getTreeColumnComparator() {
        return this.getTTreeTableModel().C();
    }

    public void setTreeColumnComparator(Comparator treeColumnComparator) {
        this.getTTreeTableModel().A(treeColumnComparator);
    }

    public TableCellRenderer createTreeColumnCellRenderer() {
        return new H(this);
    }

    public TableCellEditor createTreeColumnCellEditor() {
        return new D(this);
    }

    public void setTreeColumnDisplayName(String displayName) {
        this.getTTreeTableModel().B().setDisplayName(displayName);
    }

    public TTableColumn getTreeColumn() {
        return this.getTTreeTableModel().B();
    }

    public final boolean isIteratorByHiberarchy() {
        return false;
    }

    public final void setIteratorByHiberarchy(boolean iteratorByHiberarchy) {
    }

    public void prepareTreeColumnRenderer(JLabel renderer, Element element) {
    }
}

