/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import twaver.BatchAdapter;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSequenceAdapter;
import twaver.DataBoxSequenceListener;
import twaver.Element;
import twaver.MouseActionEvent;
import twaver.PopupMenuGenerator;
import twaver.SelectableFilter;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TView;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.VisibleFilter;
import twaver.base.A.D.O;
import twaver.base.A.E.d;
import twaver.base.A.F.D;
import twaver.chart.A;
import twaver.chart.B;
import twaver.chart.C;
import twaver.chart.ChartExporter;
import twaver.chart.Item;
import twaver.chart.LabelStruct;
import twaver.swing.RotatableLabel;
import twaver.web.svg.chart.AbstractSVGChart;

public abstract class AbstractChart
extends JPanel
implements TView,
MouseInputListener,
MouseWheelListener {
    private CellRendererPane \u0426 = new CellRendererPane();
    private DataBoxListener \u0409 = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            AbstractChart.this.publishData(true);
        }

        public void elementRemoved(DataBoxEvent e2) {
            AbstractChart.this.publishData(true);
        }

        public void elementsCleared(DataBoxEvent e2) {
            AbstractChart.this.publishData(true);
        }
    };
    private PropertyChangeListener \u0424 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Element element = (Element)evt.getSource();
            if ("visible".equals(evt.getPropertyName()) && AbstractChart.this.visibleFilters.size() == 1 && AbstractChart.this.visibleFilters.get(0) == D.C) {
                AbstractChart.this.publishData(true);
            } else if (AbstractChart.this.isVisible(element)) {
                AbstractChart.this.legendPane.A(element);
                AbstractChart.this.publishData(false);
            }
        }
    };
    private DataBoxSequenceListener \u0410 = new DataBoxSequenceAdapter(){

        public void hiberarchyChanged(Element element) {
            if (AbstractChart.this.isIteratorByHiberarchy()) {
                AbstractChart.this.publishData();
            }
        }
    };
    private Point \u041c = null;
    protected TDataBox box = null;
    protected Comparator sortComparator = null;
    protected List visibleFilters = new ArrayList();
    protected List publishedElements = new ArrayList();
    protected double sum = 0.0;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double range = 0.0;
    protected List proportionsOfSum = new ArrayList();
    protected List proportionsOfRange = new ArrayList();
    protected Map proportions = new LinkedHashMap();
    protected List shapeStructs = new ArrayList();
    protected JLabel titleLabel = new JLabel();
    protected A chartPane = new A(this);
    protected B legendPane = new B(this);
    protected Rectangle backgroundBounds = new Rectangle();
    protected boolean backgroundVisible = TUIManager.getBoolean("tchart.background.visible");
    protected Color backgroundFillColor = TUIManager.getColor("tchart.background.fill.color");
    protected Color backgroundOutlineColor = TUIManager.getColor("tchart.background.outline.color");
    protected String backgroundStroke = TUIManager.getString("tchart.background.stroke");
    protected boolean backgroundGradient = TUIManager.getBoolean("tchart.background.gradient");
    protected Color backgroundGradientColor = TUIManager.getColor("tchart.background.gradient.color");
    protected int backgroundGradientFactory = TUIManager.getInt("tchart.background.gradient.factory");
    protected Font legendFont = TUIManager.getFont("tchart.legend.font");
    protected int legendLayout = TUIManager.getInt("tchart.legend.layout");
    protected int legendOrientation = TUIManager.getInt("tchart.legend.orientation");
    protected int iconWidth = TUIManager.getInt("tchart.icon.width");
    protected int iconHeight = TUIManager.getInt("tchart.icon.height");
    protected int xGap = TUIManager.getInt("tchart.xgap");
    protected int yGap = TUIManager.getInt("tchart.ygap");
    protected int textGap = TUIManager.getInt("tchart.text.gap");
    protected double upperLimit = TUIManager.getDouble("tchart.upper.limit");
    protected double lowerLimit = TUIManager.getDouble("tchart.lower.limit");
    protected int selectedOffset = TUIManager.getInt("tchart.selected.offset");
    protected Color selectedColor = TUIManager.getColor("tchart.selected.color");
    protected String selectedStroke = TUIManager.getString("tchart.selected.stroke");
    protected Color highlightBackground = TUIManager.getColor("tchart.highlight.background");
    protected Color highlightForeground = TUIManager.getColor("tchart.highlight.foreground");
    protected String unit = TUIManager.getString("tchart.unit");
    protected String stroke = TUIManager.getString("tchart.stroke");
    protected NumberFormat format = TUIManager.getNumberFormat("tchart.format");
    protected boolean valueTextVisible = TUIManager.getBoolean("tchart.value.text.visible");
    protected boolean valueTextCenter = TUIManager.getBoolean("tchart.value.text.center");
    protected Color valueTextColor = TUIManager.getColor("tchart.value.text.color");
    protected Font valueTextFont = TUIManager.getFont("tchart.value.text.font");
    protected int valueTextPosition = TUIManager.getInt("tchart.value.text.positon");
    protected boolean antialias = TUIManager.getBoolean("tchart.antialias");
    protected boolean gradient = TUIManager.getBoolean("tchart.gradient");
    protected int shadowOffset = TUIManager.getInt("tchart.shadow.offset");
    private boolean \u041b = TUIManager.getBoolean("tchart.selectable.on.right.click");
    private boolean \u0407 = TUIManager.getBoolean("tchart.clear.selection.on.margin.clicked");
    private boolean \u0414 = TUIManager.getBoolean("tchart.enable.double.click.to.reset");
    private boolean \u0419 = TUIManager.getBoolean("tchart.enable.tooltiptext");
    private boolean \u040a = TUIManager.getBoolean("tchart.enable.xtranslate");
    private boolean \u041f = TUIManager.getBoolean("tchart.enable.ytranslate");
    private double \u041e = TUIManager.getDouble("tchart.xtranslate");
    private double \u040b = TUIManager.getDouble("tchart.ytranslate");
    private boolean \u0415 = TUIManager.getBoolean("tchart.enable.xzoom");
    private boolean \u040c = TUIManager.getBoolean("tchart.enable.yzoom");
    private double \u0420 = TUIManager.getDouble("tchart.xzoom");
    private double \u0417 = TUIManager.getDouble("tchart.yzoom");
    private double \u0411 = TUIManager.getDouble("tchart.zoom.increment");
    private double \u0413 = TUIManager.getDouble("tchart.max.zoom");
    private double \u0418 = TUIManager.getDouble("tchart.min.zoom");
    protected Color gradientColor = TUIManager.getColor("tchart.gradient.color");
    private PopupMenuGenerator \u0423 = TUIManager.getPopupMenuGenerator("tchart.popup.menu.generator");
    private boolean \u041a = TUIManager.getBoolean("tchart.lazy.publish.mode");
    private boolean \u0421 = true;
    private boolean \u0425 = false;
    private boolean \u0422 = false;
    private boolean \u0408 = false;
    private boolean \u040e = false;
    private List \u0416 = new ArrayList();
    private List \u040f = new ArrayList();
    private List \u0412 = new LinkedList();
    private BatchListener \u041d = new BatchAdapter(){

        public void batchEnded(BatchEvent e2) {
            AbstractChart.this.publishData(true);
        }
    };

    public abstract void paintChart(Graphics2D var1, int var2, int var3);

    protected void paintComponent(Graphics2D g2, Component c2, int x, int y, int w, int h2) {
        g2.setStroke(TWaverConst.BASIC_STROKE);
        this.\u0426.paintComponent(g2, c2, this.chartPane, x, y, w, h2, true);
    }

    protected void paintBackground(Graphics2D g2) {
        if (this.backgroundVisible) {
            if (this.backgroundFillColor != null) {
                if (this.backgroundGradient) {
                    O factory = d.E(this.backgroundGradientFactory);
                    Paint paint = factory.A(this.backgroundBounds, this.backgroundGradientColor, this.backgroundFillColor);
                    g2.setPaint(paint);
                } else {
                    g2.setColor(this.backgroundFillColor);
                }
                g2.fill(this.backgroundBounds);
            }
            if (this.backgroundOutlineColor != null && this.backgroundStroke != null) {
                g2.setColor(this.backgroundOutlineColor);
                g2.setStroke(TUIManager.getStrokeByType(this.backgroundStroke));
                g2.draw(this.backgroundBounds);
            }
        }
    }

    Dimension B(String text, Font font) {
        return this.B(1, text, font);
    }

    Dimension B(int orientation, String text, Font font) {
        JLabel label = RotatableLabel.getLabelRenderer(orientation);
        label.setFont(font);
        label.setText(text);
        return label.getPreferredSize();
    }

    void A(Graphics2D g2, String text, Color color, Font font, int x, int y, int position) {
        this.A(g2, 1, text, color, font, x, y, position);
    }

    void A(Graphics2D g2, LabelStruct s) {
        this.A(g2, s.getOrientation(), s.getText(), s.getColor(), s.getFont(), s.getX(), s.getY(), s.getPosition());
    }

    void A(Graphics2D g2, int orientation, String text, Color color, Font font, int x, int y, int position) {
        if (text == null || color == null || font == null) {
            return;
        }
        JLabel label = RotatableLabel.getLabelRenderer(orientation);
        label.setForeground(color);
        label.setFont(font);
        label.setText(text);
        Dimension size = label.getPreferredSize();
        switch (position) {
            case 3: {
                this.paintComponent(g2, label, x - size.width / 2, y, size.width, size.height);
                break;
            }
            case 8: {
                this.paintComponent(g2, label, x - size.width, y, size.width, size.height);
                break;
            }
            case 9: {
                this.paintComponent(g2, label, x, y, size.width, size.height);
                break;
            }
            case 1: {
                this.paintComponent(g2, label, x - size.width / 2, y - size.height / 2, size.width, size.height);
                break;
            }
            case 2: {
                this.paintComponent(g2, label, x - size.width / 2, y - size.height, size.width, size.height);
                break;
            }
            case 4: {
                this.paintComponent(g2, label, x - size.width, y - size.height / 2, size.width, size.height);
                break;
            }
            case 5: {
                this.paintComponent(g2, label, x, y - size.height / 2, size.width, size.height);
                break;
            }
            case 6: {
                this.paintComponent(g2, label, x - size.width, y - size.height, size.width, size.height);
                break;
            }
            case 7: {
                this.paintComponent(g2, label, x, y - size.height, size.width, size.height);
                break;
            }
            default: {
                this.paintComponent(g2, label, x - size.width / 2, y - size.height / 2, size.width, size.height);
            }
        }
    }

    Rectangle2D.Double A(int orientation, String text, Color color, Font font, double x, double y, int position) {
        JLabel label = RotatableLabel.getLabelRenderer(orientation);
        label.setForeground(color);
        label.setFont(font);
        label.setText(text);
        Dimension lableSize = label.getPreferredSize();
        Rectangle2D.Double rectangle = null;
        switch (position) {
            case 3: {
                rectangle = new Rectangle2D.Double(x - (double)(lableSize.width / 2), y, lableSize.width, lableSize.height);
                break;
            }
            case 8: {
                rectangle = new Rectangle2D.Double(x - (double)lableSize.width, y, lableSize.width, lableSize.height);
                break;
            }
            case 9: {
                rectangle = new Rectangle2D.Double(x, y, lableSize.width, lableSize.height);
                break;
            }
            case 1: {
                rectangle = new Rectangle2D.Double(x - (double)(lableSize.width / 2), y - (double)(lableSize.height / 2), lableSize.width, lableSize.height);
                break;
            }
            case 2: {
                rectangle = new Rectangle2D.Double(x - (double)(lableSize.width / 2), y - (double)lableSize.height, lableSize.width, lableSize.height);
                break;
            }
            case 4: {
                rectangle = new Rectangle2D.Double(x - (double)lableSize.width, y - (double)(lableSize.height / 2), lableSize.width, lableSize.height);
                break;
            }
            case 5: {
                rectangle = new Rectangle2D.Double(x, y - (double)(lableSize.height / 2), lableSize.width, lableSize.height);
                break;
            }
            case 6: {
                rectangle = new Rectangle2D.Double(x - (double)lableSize.width, y - (double)lableSize.height, lableSize.width, lableSize.height);
                break;
            }
            case 7: {
                rectangle = new Rectangle2D.Double(x, y - (double)lableSize.height, lableSize.width, lableSize.height);
                break;
            }
            default: {
                rectangle = new Rectangle2D.Double(x - (double)(lableSize.width / 2), y - (double)(lableSize.height / 2), lableSize.width, lableSize.height);
            }
        }
        return rectangle;
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
        JPopupMenu popMenu;
        this.\u041c = null;
        this.chartPane.setCursor(Cursor.getPredefinedCursor(0));
        if (this.getPopupMenuGenerator() != null && SwingUtilities.isRightMouseButton(e2) && (popMenu = this.getPopupMenuGenerator().generate(this, e2)) != null) {
            popMenu.show(this.chartPane, e2.getPoint().x, e2.getPoint().y);
            popMenu.requestFocus();
        }
    }

    public void mouseDragged(MouseEvent e2) {
        if (this.\u041c != null && SwingUtilities.isLeftMouseButton(e2) && (this.\u040a || this.\u041f)) {
            this.chartPane.setCursor(Cursor.getPredefinedCursor(12));
            double x = this.\u041e - (double)(this.\u041c.x - e2.getPoint().x);
            double y = this.\u040b - (double)(this.\u041c.y - e2.getPoint().y);
            this.setTranslate(x, y);
            this.\u041c = e2.getPoint();
            this.chartPane.repaint();
        }
    }

    public void mouseClicked(MouseEvent e2) {
        if (!SwingUtilities.isLeftMouseButton(e2)) {
            return;
        }
        C shapeStruct = this.A(e2.getPoint());
        if (shapeStruct != null) {
            MouseActionEvent event = new MouseActionEvent((Object)shapeStruct.C, e2, this, shapeStruct.B);
            if (e2.getClickCount() == 2) {
                this.fireElementDoubleClicked(event);
            }
            this.fireElementClicked(event);
        } else if (this.\u0414 && e2.getClickCount() == 2) {
            this.reset();
        }
    }

    public void mousePressed(MouseEvent e2) {
        this.\u041c = e2.getPoint();
        if (this.isSelectableOnRightClick() && SwingUtilities.isRightMouseButton(e2) || SwingUtilities.isLeftMouseButton(e2)) {
            C shapeStruct = this.A(e2.getPoint());
            Element element = shapeStruct == null ? null : shapeStruct.C;
            if (!this.isSelectable(element)) {
                element = null;
            }
            this.A(element, e2.isControlDown());
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (e2.getWheelRotation() > 0) {
            this.zoomOut();
        } else {
            this.zoomIn();
        }
    }

    public void lock() {
        if (!this.\u040e) {
            this.\u040e = true;
            this.firePropertyChange("locked", false, true);
        }
    }

    public boolean isLocked() {
        return this.\u040e;
    }

    public void unlock() {
        if (this.\u040e) {
            this.\u040e = false;
            this.publishData(true);
            this.firePropertyChange("locked", true, false);
        }
    }

    void A(Element element, boolean isControlDown) {
        if (element == null) {
            if (!isControlDown && this.box.getSelectionModel().size() > 0 && this.isClearSelectionOnMarginClicked()) {
                this.box.getSelectionModel().clearSelection();
            }
        } else if (!element.isSelected()) {
            if (isControlDown) {
                this.box.getSelectionModel().appendSelection(element);
            } else {
                this.box.getSelectionModel().setSelection(element);
            }
        } else if (isControlDown) {
            this.box.getSelectionModel().removeSelection(element);
        } else {
            this.box.getSelectionModel().setSelection(element);
        }
    }

    public AbstractChart() {
        this(new TDataBox());
    }

    public AbstractChart(TDataBox box) {
        this(box, null, null);
    }

    public AbstractChart(TDataBox box, String title, Color backgroundColor) {
        this(box, title, backgroundColor, null);
    }

    public AbstractChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        this.B(box, title, backgroundColor, foregroundColor);
    }

    public AbstractChart(List elements) {
        this(elements, null, null, null);
    }

    public AbstractChart(List elements, String title) {
        this(elements, title, null, null);
    }

    public AbstractChart(List elements, String title, Color backgroundColor) {
        this(elements, title, backgroundColor, null);
    }

    public AbstractChart(List elements, String title, Color backgroundColor, Color foregroundColor) {
        TDataBox box = new TDataBox();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                box.addElement(element);
            }
        }
        this.B(box, title, backgroundColor, foregroundColor);
    }

    private void B(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        this.visibleFilters.add(D.C);
        this.titleLabel.setText(title);
        this.titleLabel.setOpaque(false);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setVerticalAlignment(0);
        this.chartPane.add(this.\u0426);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.chartPane, "Center");
        this.k();
        this.setDataBox(box);
        if (backgroundColor == null) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(backgroundColor);
        }
        if (foregroundColor == null) {
            this.setForeground(Color.BLACK);
        } else {
            this.setForeground(foregroundColor);
        }
        this.chartPane.addMouseListener(this);
        this.chartPane.addMouseMotionListener(this);
        this.chartPane.addMouseWheelListener(this);
    }

    public TDataBox getDataBox() {
        return this.box;
    }

    public void setDataBox(TDataBox box) {
        if (box == null) {
            throw new IllegalArgumentException("DataBox must be non null");
        }
        if (this.box != null) {
            this.j();
        }
        TDataBox oldValue = this.box;
        this.box = box;
        this.l();
        this.publishData(true);
        this.firePropertyChange("databox", oldValue, this.box);
    }

    private void l() {
        this.box.addBatchListener(this.\u041d);
        this.box.addDataBoxListener(this.\u0409);
        this.box.addDataBoxSequenceListener(this.\u0410);
        this.box.addElementPropertyChangeListener(this.\u0424);
    }

    private void j() {
        this.box.removeBatchListener(this.\u041d);
        this.box.removeDataBoxListener(this.\u0409);
        this.box.removeDataBoxSequenceListener(this.\u0410);
        this.box.removeElementPropertyChangeListener(this.\u0424);
    }

    public void updateTViewUI() {
        this.publishData(true);
    }

    public Element getElementAt(Point point) {
        C shapeStruct = this.A(point);
        if (shapeStruct == null) {
            return null;
        }
        return shapeStruct.C;
    }

    C A(Point point) {
        point = new Point(point.x - (int)this.\u041e, point.y - (int)this.\u040b);
        Iterator it = this.shapeStructs.iterator();
        while (it.hasNext()) {
            C shapeStruct = (C)it.next();
            if (!shapeStruct.A(point)) continue;
            return shapeStruct;
        }
        return null;
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void addItem(Item item) {
        if (!this.box.contains(item)) {
            this.box.addElement(item);
        }
    }

    public void removeItem(Item item) {
        this.box.removeElement(item);
    }

    public void clearItems() {
        this.box.clear();
    }

    public int getItemCount() {
        return this.publishedElements.size();
    }

    public List getItems() {
        return this.publishedElements;
    }

    public Item getItemByIndex(int index) {
        return (Item)this.publishedElements.get(index);
    }

    public void setItems(List items) {
        this.box.clear();
        this.box.addElements(items);
    }

    public void paint(Graphics g2) {
        this.cleanDirtyState();
        super.paint(g2);
    }

    public void cleanDirtyState() {
        if (this.\u0425) {
            this.\u0425 = false;
            this.\u0408 = true;
            this.publishData(this.\u0422);
            this.\u0408 = false;
            this.\u0422 = false;
        }
    }

    protected abstract void calculate();

    public void publishData() {
        this.publishData(true);
    }

    public void publishData(boolean updateLegendLayout) {
        if (this.isLocked() || this.box.isBatching()) {
            return;
        }
        if (!this.\u0408 && this.isLazyPublishMode()) {
            this.\u0425 = true;
            if (!this.\u0422) {
                this.\u0422 = updateLegendLayout;
            }
            this.repaint();
            return;
        }
        this.publishedElements.clear();
        if (this.isIteratorByHiberarchy()) {
            Enumeration e2 = this.box.breadthFirstEnumeration();
            while (e2.hasMoreElements()) {
                Element element = (Element)e2.nextElement();
                if (!this.isVisible(element)) continue;
                this.publishedElements.add(element);
            }
        } else {
            Iterator it = this.box.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!this.isVisible(element)) continue;
                this.publishedElements.add(element);
            }
        }
        if (this.sortComparator != null) {
            Collections.sort(this.publishedElements, this.sortComparator);
        }
        this.calculate();
        if (updateLegendLayout) {
            this.legendPane.A();
        } else {
            this.legendPane.B();
        }
        this.chartPane.repaint();
    }

    public boolean isIteratorByHiberarchy() {
        return this.\u0421;
    }

    public void setIteratorByHiberarchy(boolean iteratorByHiberarchy) {
        if (this.\u0421 != iteratorByHiberarchy) {
            this.\u0421 = iteratorByHiberarchy;
            this.publishData(true);
        }
    }

    public List getElementDoubleClickedActionListeners() {
        return this.\u0416;
    }

    public List getElementClickedActionListeners() {
        return this.\u040f;
    }

    public void addElementDoubleClickedActionListener(ActionListener l2) {
        if (!this.\u0416.contains(l2)) {
            this.\u0416.add(l2);
        }
    }

    public void removeElementDoubleClickedActionListener(ActionListener l2) {
        this.\u0416.remove(l2);
    }

    public void fireElementDoubleClicked(MouseActionEvent event) {
        for (int i2 = 0; i2 < this.\u0416.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u0416.get(i2);
            l2.actionPerformed(event);
        }
    }

    public void addElementClickedActionListener(ActionListener l2) {
        if (!this.\u040f.contains(l2)) {
            this.\u040f.add(l2);
        }
    }

    public void removeElementClickedActionListener(ActionListener l2) {
        this.\u040f.remove(l2);
    }

    public void fireElementClicked(MouseActionEvent event) {
        for (int i2 = 0; i2 < this.\u040f.size(); ++i2) {
            ActionListener l2 = (ActionListener)this.\u040f.get(i2);
            l2.actionPerformed(event);
        }
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
        this.publishData(false);
    }

    public void setForeground(Color foregroundColor) {
        super.setForeground(foregroundColor);
        if (this.legendPane != null) {
            this.legendPane.B();
        }
        if (this.titleLabel != null) {
            this.titleLabel.setForeground(foregroundColor);
        }
    }

    public JComponent getChartPane() {
        return this.chartPane;
    }

    public JPanel getLegendPane() {
        return this.legendPane;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public int getLegendLayout() {
        return this.legendLayout;
    }

    public void setLegendLayout(int legendLayout) {
        if (this.legendLayout != legendLayout) {
            this.legendLayout = legendLayout;
            this.legendPane.A();
            this.remove(this.legendPane);
            this.k();
            this.validate();
        }
    }

    private void k() {
        if (this.legendLayout == 1 || this.legendLayout == 6 || this.legendLayout == 10) {
            this.add((Component)this.legendPane, "South");
        } else if (this.legendLayout == 2 || this.legendLayout == 4 || this.legendLayout == 8) {
            this.add((Component)this.legendPane, "East");
        } else if (this.legendLayout == 7 || this.legendLayout == 3) {
            this.add((Component)this.legendPane, "West");
        } else if (this.legendLayout == 9 || this.legendLayout == 5) {
            this.add((Component)this.legendPane, "North");
        }
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
        this.legendPane.revalidate();
        this.legendPane.repaint();
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
        this.legendPane.revalidate();
        this.legendPane.repaint();
    }

    public int getXGap() {
        return this.xGap;
    }

    public void setXGap(int gap) {
        this.xGap = gap;
        this.chartPane.repaint();
    }

    public int getYGap() {
        return this.yGap;
    }

    public void setYGap(int gap) {
        this.yGap = gap;
        this.chartPane.repaint();
    }

    public boolean isValueTextVisible() {
        return this.valueTextVisible;
    }

    public void setValueTextVisible(boolean valueTextVisible) {
        this.valueTextVisible = valueTextVisible;
        this.chartPane.repaint();
    }

    public Color getValueTextColor() {
        return this.valueTextColor;
    }

    public void setValueTextColor(Color valueTextColor) {
        this.valueTextColor = valueTextColor;
        this.chartPane.repaint();
    }

    public Font getValueTextFont() {
        return this.valueTextFont;
    }

    public void setValueTextFont(Font valueTextFont) {
        this.valueTextFont = valueTextFont;
        this.chartPane.repaint();
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
        this.chartPane.repaint();
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
        for (int i2 = 0; i2 < this.legendPane.getComponentCount(); ++i2) {
            JLabel label = (JLabel)this.legendPane.getComponent(i2);
            if (this.legendFont != null) {
                label.setFont(this.legendFont);
                continue;
            }
            label.setFont(TUIManager.getDefaultFont());
        }
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
        this.chartPane.repaint();
    }

    public Comparator getSortComparator() {
        return this.sortComparator;
    }

    public void setSortComparator(Comparator sortComparator) {
        this.sortComparator = sortComparator;
        this.publishData(true);
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null && !this.visibleFilters.contains(visibleFilter)) {
            this.visibleFilters.add(visibleFilter);
            this.publishData(true);
        }
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null) {
            this.visibleFilters.remove(visibleFilter);
            this.publishData(true);
        }
    }

    public List getVisibleFilters() {
        return new ArrayList(this.visibleFilters);
    }

    public boolean isVisible(Element element) {
        if (!this.box.contains(element)) {
            return false;
        }
        Iterator it = this.visibleFilters.iterator();
        while (it.hasNext()) {
            VisibleFilter filter = (VisibleFilter)it.next();
            if (filter.isVisible(element)) continue;
            return false;
        }
        return true;
    }

    public void addSelectableFilter(SelectableFilter filter) {
        if (filter != null && !this.\u0412.contains(filter)) {
            this.\u0412.add(filter);
        }
    }

    public void removeSelectableFilter(SelectableFilter filter) {
        if (filter != null) {
            this.\u0412.remove(filter);
        }
    }

    public List getSelectableFilters() {
        return new ArrayList(this.\u0412);
    }

    public void clearSelectableFilters() {
        this.\u0412.clear();
    }

    public boolean isSelectable(Element element) {
        if (element == null) {
            return false;
        }
        Iterator it = this.\u0412.iterator();
        while (it.hasNext()) {
            SelectableFilter filter = (SelectableFilter)it.next();
            if (filter.isSelectable(element)) continue;
            return false;
        }
        return true;
    }

    public boolean isLazyPublishMode() {
        return this.\u041a;
    }

    public void setLazyPublishMode(boolean lazyPublishMode) {
        this.\u041a = lazyPublishMode;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
        this.publishData(false);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.chartPane.repaint();
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
        this.legendPane.B();
    }

    public Color getHighlightForeground() {
        return this.highlightForeground;
    }

    public void setHighlightForeground(Color highlightForeground) {
        this.highlightForeground = highlightForeground;
        this.legendPane.B();
    }

    public Color getSelectedColor(Element element) {
        if (this.selectedColor == null) {
            return this.getColor(element).darker();
        }
        return this.selectedColor;
    }

    public Stroke getSelectedStroke(Element element) {
        if (this.selectedStroke == null) {
            return TWaverConst.DOUBLE_WIDTH_STROKE;
        }
        return TUIManager.getStrokeByType(this.selectedStroke);
    }

    protected Color getGradientColor(Element element) {
        return this.gradientColor;
    }

    protected String getFormatedText(Element element, double value) {
        return this.getFormatedText(element, value, -1);
    }

    protected String getFormatedText(Element element, double value, int index) {
        NumberFormat format = this.getFormat(element);
        String ret = format.format(value);
        if (this.unit != null) {
            ret = ret + this.unit;
        }
        return ret;
    }

    public Color getColor(Element element) {
        return element.getChartColor();
    }

    public double getValue(Element element) {
        return element.getChartValue();
    }

    public double getMax(Element element) {
        return element.getChartMax();
    }

    public double getMin(Element element) {
        return element.getChartMin();
    }

    public String getLegendLabel(Element element) {
        return element.getName();
    }

    public String getToolTipText(Element element) {
        if (!this.isEnableToolTipText()) {
            return null;
        }
        String text = element.getToolTipText();
        if (text == null) {
            text = this.getLegendLabel(element);
        }
        return text;
    }

    public NumberFormat getFormat(Element element) {
        NumberFormat format = (NumberFormat)element.getClientProperty("chart.format");
        if (format != null) {
            return format;
        }
        if (this.format != null) {
            return this.format;
        }
        return TUIManager.getNumberFormat("chart.format");
    }

    public Stroke getStroke(Element element) {
        String value = (String)element.getClientProperty("chart.stroke");
        if (value != null) {
            return TUIManager.getStrokeByType(value);
        }
        if (this.stroke != null) {
            return TUIManager.getStrokeByType(this.stroke);
        }
        return TUIManager.getStrokeByType(TUIManager.getString("chart.stroke"));
    }

    public List getValues(Element element) {
        return element.getChartValues();
    }

    public List getPublishedElements() {
        this.cleanDirtyState();
        return this.publishedElements;
    }

    protected List getLegendElements() {
        return this.getPublishedElements();
    }

    public String getStroke() {
        return this.stroke;
    }

    public void setStroke(String stroke) {
        this.stroke = stroke;
        this.chartPane.repaint();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.chartPane.repaint();
    }

    public String getSelectedStroke() {
        return this.selectedStroke;
    }

    public void setSelectedStroke(String selectedStroke) {
        this.selectedStroke = selectedStroke;
        this.chartPane.repaint();
    }

    public int getSelectedOffset() {
        return this.selectedOffset;
    }

    public void setSelectedOffset(int selectedOffset) {
        this.selectedOffset = selectedOffset;
        this.chartPane.repaint();
    }

    public int getShadowOffset() {
        return this.shadowOffset;
    }

    public void setShadowOffset(int shadowOffset) {
        this.shadowOffset = shadowOffset;
        this.chartPane.repaint();
    }

    public int getLegendOrientation() {
        return this.legendOrientation;
    }

    public void setLegendOrientation(int legendOrientation) {
        this.legendOrientation = legendOrientation;
        this.legendPane.A();
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public void setGradient(boolean gradient) {
        this.gradient = gradient;
        this.chartPane.repaint();
    }

    public boolean isValueTextCenter() {
        return this.valueTextCenter;
    }

    public void setValueTextCenter(boolean valueTextCenter) {
        this.valueTextCenter = valueTextCenter;
        this.chartPane.repaint();
    }

    public int getTextGap() {
        return this.textGap;
    }

    public void setTextGap(int textGap) {
        this.textGap = textGap;
        this.chartPane.repaint();
    }

    public void setTranslate(double x, double y) {
        this.\u041e = x;
        this.\u040b = y;
        if (!this.\u040a) {
            this.\u041e = 0.0;
        }
        if (!this.\u041f) {
            this.\u040b = 0.0;
        }
        this.chartPane.repaint();
    }

    public double getXZoom() {
        return this.\u0420;
    }

    public void setXZoom(double zoom) {
        if (this.\u0415 && zoom >= this.\u0418 && zoom <= this.\u0413) {
            double w = ((double)(this.chartPane.getWidth() / 2) - this.\u041e) / this.\u0420;
            double offset = (int)(w * (zoom - this.\u0420));
            this.\u0420 = zoom;
            this.setTranslate(this.\u041e - offset, this.\u040b);
        }
    }

    public double getYZoom() {
        return this.\u0417;
    }

    public void setYZoom(double zoom) {
        if (this.\u040c && zoom >= this.\u0418 && zoom <= this.\u0413) {
            double h2 = ((double)(this.chartPane.getHeight() / 2) - this.\u040b) / this.\u0417;
            int offset = (int)(h2 * (zoom - this.\u0417));
            this.\u0417 = zoom;
            this.setTranslate(this.\u041e, this.\u040b - (double)offset);
        }
    }

    public double getZoomIncrement() {
        return this.\u0411;
    }

    public void setZoomIncrement(double zoomIncrement) {
        this.\u0411 = zoomIncrement;
    }

    public double getMaxZoom() {
        return this.\u0413;
    }

    public void setMaxZoom(double maxZoom) {
        this.\u0413 = maxZoom;
        if (this.\u0420 > maxZoom) {
            this.\u0420 = maxZoom;
            this.chartPane.repaint();
        }
        if (this.\u0417 > maxZoom) {
            this.\u0417 = maxZoom;
            this.chartPane.repaint();
        }
    }

    public double getMinZoom() {
        return this.\u0418;
    }

    public void setMinZoom(double minZoom) {
        this.\u0418 = minZoom;
        if (this.\u0420 < minZoom) {
            this.\u0420 = minZoom;
            this.chartPane.repaint();
        }
        if (this.\u0417 < minZoom) {
            this.\u0417 = minZoom;
            this.chartPane.repaint();
        }
    }

    public void reset() {
        this.\u0420 = 1.0;
        this.\u0417 = 1.0;
        this.\u041e = 0.0;
        this.\u040b = 0.0;
        this.chartPane.repaint();
    }

    public boolean isEnableXTranslate() {
        return this.\u040a;
    }

    public void setEnableXTranslate(boolean enableXTranslate) {
        this.\u040a = enableXTranslate;
    }

    public boolean isEnableXZoom() {
        return this.\u0415;
    }

    public void setEnableXZoom(boolean enableXZoom) {
        this.\u0415 = enableXZoom;
    }

    public boolean isEnableYTranslate() {
        return this.\u041f;
    }

    public void setEnableYTranslate(boolean enableYTranslate) {
        this.\u041f = enableYTranslate;
    }

    public boolean isEnableYZoom() {
        return this.\u040c;
    }

    public void setEnableYZoom(boolean enableYZoom) {
        this.\u040c = enableYZoom;
    }

    public double getXTranslate() {
        return this.\u041e;
    }

    public void setXTranslate(double translate) {
        this.\u041e = translate;
    }

    public double getYTranslate() {
        return this.\u040b;
    }

    public void setYTranslate(double translate) {
        this.\u040b = translate;
    }

    public void zoomIn() {
        this.setXZoom(this.\u0420 * this.\u0411);
        this.setYZoom(this.\u0417 * this.\u0411);
    }

    public void zoomOut() {
        this.setXZoom(this.\u0420 / this.\u0411);
        this.setYZoom(this.\u0417 / this.\u0411);
    }

    public PopupMenuGenerator getPopupMenuGenerator() {
        return this.\u0423;
    }

    public void setPopupMenuGenerator(PopupMenuGenerator popupMenuGenerator) {
        this.\u0423 = popupMenuGenerator;
    }

    public boolean isSelectableOnRightClick() {
        return this.\u041b;
    }

    public void setSelectableOnRightClick(boolean isSelectableOnRightClick) {
        this.\u041b = isSelectableOnRightClick;
    }

    public boolean isClearSelectionOnMarginClicked() {
        return this.\u0407;
    }

    public void setClearSelectionOnMarginClicked(boolean isClearSelectionOnMarginClicked) {
        this.\u0407 = isClearSelectionOnMarginClicked;
    }

    public boolean isEnableDoubleClickToReset() {
        return this.\u0414;
    }

    public void setEnableDoubleClickToReset(boolean enableDoubleClickToReset) {
        this.\u0414 = enableDoubleClickToReset;
    }

    public boolean isEnableToolTipText() {
        return this.\u0419;
    }

    public void setEnableToolTipText(boolean enableToolTipText) {
        this.\u0419 = enableToolTipText;
        this.chartPane.repaint();
    }

    public Color getBackgroundFillColor() {
        return this.backgroundFillColor;
    }

    public void setBackgroundFillColor(Color backgroundFillColor) {
        this.backgroundFillColor = backgroundFillColor;
        this.chartPane.repaint();
    }

    public Color getBackgroundOutlineColor() {
        return this.backgroundOutlineColor;
    }

    public void setBackgroundOutlineColor(Color backgroundOutlineColor) {
        this.backgroundOutlineColor = backgroundOutlineColor;
        this.chartPane.repaint();
    }

    public String getBackgroundStroke() {
        return this.backgroundStroke;
    }

    public void setBackgroundStroke(String backgroundStroke) {
        this.backgroundStroke = backgroundStroke;
        this.chartPane.repaint();
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean backgroundVisible) {
        this.backgroundVisible = backgroundVisible;
        this.chartPane.repaint();
    }

    public Rectangle getBackgroundBounds() {
        return (Rectangle)this.backgroundBounds.clone();
    }

    public boolean exportImage(String fileName, String formatName, boolean wholeChart) {
        if (wholeChart) {
            return TWaverUtil.exportImage(this, fileName, formatName);
        }
        ChartExporter exporter = new ChartExporter(this, formatName);
        return exporter.exportToFile(fileName);
    }

    public boolean exportToImageIcon(String iconUrl, String formatName, boolean wholeChart) {
        if (wholeChart) {
            return TWaverUtil.exportToImageIcon(this, iconUrl, formatName);
        }
        ChartExporter exporter = new ChartExporter(this, formatName);
        return exporter.exportToImageIcon(iconUrl);
    }

    public boolean exportImage(JFileChooser chooser, boolean wholeChart) {
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return false;
        }
        String fileName = chooser.getSelectedFile().getAbsolutePath();
        String formatName = chooser.getFileFilter().getDescription();
        return this.exportImage(fileName, formatName, wholeChart);
    }

    public boolean isBackgroundGradient() {
        return this.backgroundGradient;
    }

    public void setBackgroundGradient(boolean backgroundGradient) {
        this.backgroundGradient = backgroundGradient;
        this.chartPane.repaint();
    }

    public Color getBackgroundGradientColor() {
        return this.backgroundGradientColor;
    }

    public void setBackgroundGradientColor(Color backgroundGradientColor) {
        this.backgroundGradientColor = backgroundGradientColor;
        this.chartPane.repaint();
    }

    public int getBackgroundGradientFactory() {
        return this.backgroundGradientFactory;
    }

    public void setBackgroundGradientFactory(int backgroundGradientFactory) {
        this.backgroundGradientFactory = backgroundGradientFactory;
        this.chartPane.repaint();
    }

    public int getValueTextPosition() {
        return this.valueTextPosition;
    }

    public void setValueTextPosition(int valueTextPosition) {
        this.valueTextPosition = valueTextPosition;
        this.chartPane.repaint();
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
        this.chartPane.repaint();
    }

    public void exportSVG(String fileName, int width, int height) {
    }

    public void exportSVG(String fileName) {
        this.exportSVG(fileName, this.getWidth(), this.getHeight());
    }

    protected void setChartSVGAttribute(AbstractSVGChart chart) {
        chart.setDataBox(this.box);
        chart.setBackgroundColor(this.getBackground());
        chart.setGradient(this.isGradient());
        chart.setLowerLimit(this.getLowerLimit());
        chart.setSelectedOffset(this.getSelectedOffset());
        chart.setShadowOffset(this.getShadowOffset());
        chart.setStroke(this.getStroke());
        chart.setTextGap(this.getTextGap());
        chart.setUpperLimit(this.getUpperLimit());
        chart.setValueTextFont(this.getValueTextFont());
        chart.setValueTextVisible(this.isValueTextVisible());
        chart.setXGap(this.getXGap());
        chart.setYGap(this.getYGap());
        chart.setSortComparator(this.getSortComparator());
        chart.setUnit(this.getUnit());
        chart.setFormat(this.getFormat());
        chart.setValueTextCenter(this.isValueTextCenter());
        chart.setValueTextColor(this.getValueTextColor());
        chart.setBackgroundFillColor(this.getBackgroundFillColor());
        chart.setBackgroundGradient(this.isBackgroundGradient());
        chart.setBackgroundGradientColor(this.getBackgroundGradientColor());
        chart.setBackgroundGradientFactory(this.getBackgroundGradientFactory());
        chart.setBackgroundOutlineColor(this.getBackgroundOutlineColor());
        chart.setBackgroundStroke(this.getBackgroundStroke());
        chart.setBackgroundVisible(this.isBackgroundVisible());
        chart.setGradient(this.isGradient());
        int size = this.getVisibleFilters().size();
        for (int i2 = 0; i2 < size; ++i2) {
            chart.addVisibleFilter((VisibleFilter)this.visibleFilters.get(i2));
        }
    }
}

