/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.lazyloader;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.button.JBasicMenuButton;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.layout.toolbar.ToolBarLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.menu.JBasicMenu;
import com.nepxion.swing.menuitem.JBasicCheckBoxMenuItem;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.menuitem.JBasicRadioButtonMenuItem;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.searchable.JSearchableContainer;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.swing.tip.balloon.JBalloonTip;
import com.nepxion.swing.tree.lazyloader.ILazyLoaderContainer;
import com.nepxion.swing.tree.lazyloader.ILazyLoaderTree;
import com.nepxion.swing.tree.lazyloader.JLazyLoaderTreeNode;
import com.nepxion.swing.tree.lazyloader.LazyLoaderTreeController;
import com.nepxion.swing.tree.lazyloader.SearchDescription;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class JLazyLoaderContainer
extends JSearchableContainer
implements ILazyLoaderContainer {
    private ILazyLoaderTree lazyLoaderTree;
    private SearchBar searchBar;
    private boolean isShown = false;

    public JLazyLoaderContainer() {
        this((ILazyLoaderTree)null);
    }

    public JLazyLoaderContainer(ILazyLoaderTree lazyLoaderTree) {
        this.lazyLoaderTree = lazyLoaderTree;
        this.searchBar = new SearchBar();
        this.setLazyLoaderTree(lazyLoaderTree);
        ActionListener toggleShownActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLazyLoaderContainer.this.toggleShown();
            }
        };
        KeyStrokeManager.registerComponent(this, toggleShownActionListener, 70, 2);
    }

    public ILazyLoaderTree getLazyLoaderTree() {
        return this.lazyLoaderTree;
    }

    public void setLazyLoaderTree(ILazyLoaderTree lazyLoaderTree) {
        this.lazyLoaderTree = lazyLoaderTree;
        this.lazyLoaderTree.setLazyLoaderContainer(this);
        this.add((Component)new JBasicScrollPane((JTree)((Object)lazyLoaderTree)), "Center");
    }

    @Override
    public void toggleShown() {
        if (this.isShown) {
            this.hide(this.searchBar);
        } else {
            this.show(this.searchBar);
        }
        this.isShown = !this.isShown;
    }

    public class HistoryRadioButtonMenuItem
    extends JBasicRadioButtonMenuItem {
        private SearchDescription searchDescription;

        public HistoryRadioButtonMenuItem(SearchDescription searchDescription) {
            super(searchDescription.toString(), searchDescription.toString());
            this.searchDescription = searchDescription;
        }

        public HistoryRadioButtonMenuItem(SearchDescription searchDescription, boolean selected) {
            super(searchDescription.toString(), searchDescription.toString(), selected);
            this.searchDescription = searchDescription;
        }

        public SearchDescription getSearchDescription() {
            return this.searchDescription;
        }

        public void setSearchDescription(SearchDescription searchDescription) {
            this.searchDescription = searchDescription;
        }
    }

    public class RecursionDepthRadioButtonMenuItem
    extends JBasicRadioButtonMenuItem {
        private int recursionDepth;

        public RecursionDepthRadioButtonMenuItem(String text, String toolTipText) {
            super(text, toolTipText);
        }

        public RecursionDepthRadioButtonMenuItem(String text, String toolTipText, boolean selected) {
            super(text, toolTipText, selected);
        }

        public int getRecursionDepth() {
            return this.recursionDepth;
        }

        public void setRecursionDepth(int recursionDepth) {
            this.recursionDepth = recursionDepth;
        }
    }

    public class SearchBar
    extends JPanel {
        private JBasicButton closeButton;
        private JBasicTextField searchTextField;
        private JBasicButton searchButton;
        private JBasicButton backwardButton;
        private JBasicButton forwardButton;
        private JBasicMenuButton preferenceMenuButton;
        private JBasicMenuButton historyMenuButton;
        private JBasicCheckBoxMenuItem caseSensitiveMenuItem;
        private JBasicCheckBoxMenuItem matchTextMenuItem;
        private ButtonGroup recursionDepthButtonGroup;
        private ButtonGroup historyButtonGroup;
        private JBasicMenuItem historyEmptyMenuItem;
        private int maximumHistoryCount = 10;

        public SearchBar() {
            this.setLayout(new ToolBarLayout());
            this.closeButton = new JBasicButton(IconFactory.getSwingIcon("stereo/close_16.png"), SwingLocale.getString("close"));
            this.closeButton.setDimension(new Dimension(26, 26));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLazyLoaderContainer.this.toggleShown();
                }
            });
            this.searchTextField = new JBasicTextField();
            DimensionManager.setDimension(this.searchTextField, new Dimension(70, 24));
            this.searchButton = new JBasicButton(IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("search"));
            this.searchButton.setDimension(new Dimension(26, 26));
            ActionListener searchActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isLoadable = LazyLoaderTreeController.isLoadable(JLazyLoaderContainer.this.lazyLoaderTree);
                    if (!isLoadable) {
                        return;
                    }
                    String searchText = SearchBar.this.searchTextField.getText().trim();
                    if (searchText.equals("")) {
                        SearchBar.this.searchTextField.showTip(SwingLocale.getString("input_not_null"), JBalloonTip.TIP_ICON_ERROR_MESSAGE, 1, 7);
                        return;
                    }
                    JLazyLoaderTreeNode treeNode = (JLazyLoaderTreeNode)JLazyLoaderContainer.this.lazyLoaderTree.getSelectionTreeNode();
                    int recursionDepth = SearchBar.this.getRecursionDepth();
                    JLazyLoaderContainer.this.lazyLoaderTree.getLazyLoader().setRecursive(true);
                    JLazyLoaderContainer.this.lazyLoaderTree.getLazyLoader().setRecursionDepth(recursionDepth);
                    SearchDescription searchDescription = new SearchDescription();
                    searchDescription.setSearchText(searchText);
                    searchDescription.setCaseSensitive(SearchBar.this.caseSensitiveMenuItem.isSelected());
                    searchDescription.setTextMatched(SearchBar.this.matchTextMenuItem.isSelected());
                    searchDescription.setTreeNode(treeNode);
                    JLazyLoaderContainer.this.lazyLoaderTree.getLazyLoader().setSearchDescription(searchDescription);
                    JLazyLoaderContainer.this.lazyLoaderTree.search(treeNode);
                    SearchBar.this.addHistory(searchDescription);
                }
            };
            this.searchButton.addActionListener(searchActionListener);
            KeyStrokeManager.registerButton((AbstractButton)this.searchButton, searchActionListener, 10);
            this.forwardButton = new JBasicButton(IconFactory.getSwingIcon("stereo/arrow_down_16.png"), SwingLocale.getString("search_forward"));
            this.forwardButton.setDimension(new Dimension(26, 26));
            ActionListener forwardActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDescription searchDescription = SearchBar.this.getSearchDescription();
                    boolean hasResult = SearchBar.this.hasResult(searchDescription);
                    if (!hasResult) {
                        return;
                    }
                    int resultIndex = searchDescription.getResultIndex();
                    TreeNode treeNode = (TreeNode)searchDescription.getResult().get(resultIndex);
                    JLazyLoaderContainer.this.lazyLoaderTree.setSelectionTreeNode(treeNode);
                    JLazyLoaderContainer.this.lazyLoaderTree.scrollToVisible(treeNode);
                    searchDescription.forward();
                }
            };
            this.forwardButton.addActionListener(forwardActionListener);
            KeyStrokeManager.registerButton((AbstractButton)this.forwardButton, forwardActionListener, 68, 2);
            this.backwardButton = new JBasicButton(IconFactory.getSwingIcon("stereo/arrow_up_16.png"), SwingLocale.getString("search_backward"));
            this.backwardButton.setDimension(new Dimension(26, 26));
            ActionListener backwardActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDescription searchDescription = SearchBar.this.getSearchDescription();
                    boolean hasResult = SearchBar.this.hasResult(searchDescription);
                    if (!hasResult) {
                        return;
                    }
                    int resultIndex = searchDescription.getResultIndex();
                    TreeNode treeNode = (TreeNode)searchDescription.getResult().get(resultIndex);
                    JLazyLoaderContainer.this.lazyLoaderTree.setSelectionTreeNode(treeNode);
                    JLazyLoaderContainer.this.lazyLoaderTree.scrollToVisible(treeNode);
                    searchDescription.backward();
                }
            };
            this.backwardButton.addActionListener(backwardActionListener);
            KeyStrokeManager.registerButton((AbstractButton)this.backwardButton, backwardActionListener, 85, 2);
            this.preferenceMenuButton = new JBasicMenuButton(IconFactory.getSwingIcon("stereo/favorite_16.png"), SwingLocale.getString("preference"));
            this.preferenceMenuButton.setDimension(new Dimension(31, 26));
            JBasicPopupMenu preferencePopupMenu = new JBasicPopupMenu();
            this.preferenceMenuButton.setPopupMenu(preferencePopupMenu);
            JBasicMenu recursionDepthMenu = this.createRecursionDepthMenu();
            preferencePopupMenu.add(recursionDepthMenu);
            JBasicMenuItem highlightMenuItem = new JBasicMenuItem(SwingLocale.getString("highlight"), SwingLocale.getString("highlight"));
            highlightMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDescription searchDescription = SearchBar.this.getSearchDescription();
                    boolean hasResult = SearchBar.this.hasResult(searchDescription);
                    if (!hasResult) {
                        return;
                    }
                    TreeNode[] treeNodes = new TreeNode[searchDescription.getResult().size()];
                    for (int i = 0; i < searchDescription.getResult().size(); ++i) {
                        treeNodes[i] = (TreeNode)searchDescription.getResult().get(i);
                    }
                    JLazyLoaderContainer.this.lazyLoaderTree.clearSelection();
                    JLazyLoaderContainer.this.lazyLoaderTree.addSelectionTreeNodes(treeNodes);
                }
            });
            preferencePopupMenu.add(highlightMenuItem);
            preferencePopupMenu.addSeparator();
            this.caseSensitiveMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("case_sensitive"), SwingLocale.getString("case_sensitive"));
            preferencePopupMenu.add(this.caseSensitiveMenuItem);
            this.matchTextMenuItem = new JBasicCheckBoxMenuItem(SwingLocale.getString("match_text"), SwingLocale.getString("match_text"));
            preferencePopupMenu.add(this.matchTextMenuItem);
            this.historyButtonGroup = new ButtonGroup();
            this.historyMenuButton = new JBasicMenuButton(IconFactory.getSwingIcon("stereo/history_16.png"), SwingLocale.getString("history_record"));
            this.historyMenuButton.setDimension(new Dimension(31, 26));
            JBasicPopupMenu historyPopupMenu = new JBasicPopupMenu();
            this.historyMenuButton.setPopupMenu(historyPopupMenu);
            this.historyEmptyMenuItem = new JBasicMenuItem(SwingLocale.getString("history_empty"), SwingLocale.getString("history_empty"));
            this.historyEmptyMenuItem.setEnabled(false);
            historyPopupMenu.add(this.historyEmptyMenuItem);
            historyPopupMenu.addSeparator();
            JBasicMenuItem clearMenuItem = new JBasicMenuItem(SwingLocale.getString("history_record_clear"), SwingLocale.getString("history_record_clear"));
            clearMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchBar.this.clearHistories();
                }
            });
            historyPopupMenu.add(clearMenuItem);
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.add(this.closeButton);
            this.add(this.searchTextField);
            this.add(this.searchButton);
            this.add(this.forwardButton);
            this.add(this.backwardButton);
            this.add(this.preferenceMenuButton);
            this.add(this.historyMenuButton);
            ButtonManager.updateUI(this);
        }

        private JBasicMenu createRecursionDepthMenu() {
            JBasicMenu recursionDepthMenu = new JBasicMenu(SwingLocale.getString("search_depth"), SwingLocale.getString("search_depth"));
            this.recursionDepthButtonGroup = new ButtonGroup();
            for (int i = 1; i <= 10; ++i) {
                RecursionDepthRadioButtonMenuItem recursionDepthMenuItem = new RecursionDepthRadioButtonMenuItem(i + SwingLocale.getString("search_deep_level"), i + SwingLocale.getString("search_deep_level"));
                recursionDepthMenuItem.setRecursionDepth(i);
                this.recursionDepthButtonGroup.add(recursionDepthMenuItem);
                recursionDepthMenu.add(recursionDepthMenuItem);
            }
            RecursionDepthRadioButtonMenuItem recursionAllMenuItem = new RecursionDepthRadioButtonMenuItem(SwingLocale.getString("search_full_deep_level"), SwingLocale.getString("search_full_deep_level"), true);
            recursionAllMenuItem.setRecursionDepth(-1);
            recursionDepthMenu.addSeparator();
            this.recursionDepthButtonGroup.add(recursionAllMenuItem);
            recursionDepthMenu.add(recursionAllMenuItem);
            return recursionDepthMenu;
        }

        private int getRecursionDepth() {
            Enumeration<AbstractButton> enumeration = this.recursionDepthButtonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                RecursionDepthRadioButtonMenuItem recursionDepthRadioButtonMenuItem = (RecursionDepthRadioButtonMenuItem)enumeration.nextElement();
                if (!recursionDepthRadioButtonMenuItem.isSelected()) continue;
                return recursionDepthRadioButtonMenuItem.getRecursionDepth();
            }
            return -1;
        }

        private SearchDescription getSearchDescription() {
            Enumeration<AbstractButton> enumeration = this.historyButtonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                HistoryRadioButtonMenuItem historyRadioButtonMenuItem = (HistoryRadioButtonMenuItem)enumeration.nextElement();
                if (!historyRadioButtonMenuItem.isSelected()) continue;
                return historyRadioButtonMenuItem.getSearchDescription();
            }
            return null;
        }

        private void addHistory(SearchDescription searchDescription) {
            JBasicPopupMenu historyPopupMenu = (JBasicPopupMenu)this.historyMenuButton.getPopupMenu();
            if (historyPopupMenu.getComponent(0) == this.historyEmptyMenuItem) {
                historyPopupMenu.remove(this.historyEmptyMenuItem);
            }
            if (historyPopupMenu.getComponentCount() >= this.maximumHistoryCount + 2) {
                this.historyButtonGroup.remove((HistoryRadioButtonMenuItem)historyPopupMenu.getComponent(this.maximumHistoryCount - 1));
                historyPopupMenu.remove(historyPopupMenu.getComponent(this.maximumHistoryCount - 1));
            }
            HistoryRadioButtonMenuItem historyRadioButtonMenuItem = new HistoryRadioButtonMenuItem(searchDescription);
            this.historyButtonGroup.add(historyRadioButtonMenuItem);
            historyPopupMenu.add((Component)historyRadioButtonMenuItem, 0);
            historyRadioButtonMenuItem.setSelected(true);
        }

        private void clearHistories() {
            JBasicPopupMenu historyPopupMenu = (JBasicPopupMenu)this.historyMenuButton.getPopupMenu();
            Enumeration<AbstractButton> enumeration = this.historyButtonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                HistoryRadioButtonMenuItem historyRadioButtonMenuItem = (HistoryRadioButtonMenuItem)enumeration.nextElement();
                historyPopupMenu.remove(historyRadioButtonMenuItem);
            }
            historyPopupMenu.add((Component)this.historyEmptyMenuItem, 0);
            this.historyButtonGroup = new ButtonGroup();
        }

        private boolean hasResult(SearchDescription searchDescription) {
            if (searchDescription == null) {
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)JLazyLoaderContainer.this.lazyLoaderTree)), SwingLocale.getString("search_result_empty"), SwingLocale.getString("information"), 1);
                return false;
            }
            if (searchDescription.getResult() == null || searchDescription.getResult().isEmpty()) {
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame((JTree)((Object)JLazyLoaderContainer.this.lazyLoaderTree)), SwingLocale.getString("search_result_empty"), SwingLocale.getString("information"), 1);
                return false;
            }
            return true;
        }
    }
}

