/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.file;

import com.nepxion.swing.listener.SelectionListener;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.file.JFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JRootPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.JTextComponent;

public class JBasicFileChooser
extends JFileChooser {
    private JDialog dialog;
    private Component parentComponent;

    public JBasicFileChooser(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public JBasicFileChooser(Component parentComponent, String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.parentComponent = parentComponent;
    }

    public JBasicFileChooser(Component parentComponent, File currentDirectory) {
        super(currentDirectory);
        this.parentComponent = parentComponent;
    }

    public JBasicFileChooser(Component parentComponent, FileSystemView fsv) {
        super(fsv);
        this.parentComponent = parentComponent;
    }

    public JBasicFileChooser(Component parentComponent, File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.parentComponent = parentComponent;
    }

    public JBasicFileChooser(Component parentComponent, String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.parentComponent = parentComponent;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        this.dialog = super.createDialog(parent);
        this.verifyFileFilterComboBox();
        this.verifyApprovalButton();
        return this.dialog;
    }

    @Override
    public void approveSelection() {
        File file;
        super.approveSelection();
        if (this.getDialogType() != 1 && !(file = this.getSelectedFile()).exists()) {
            JBasicOptionPane.showMessageDialog(this.parentComponent, this.getType() + SwingLocale.getString("file_error_not_existed"), SwingLocale.getString("warning"), 2);
            this.dialog.setVisible(true);
        }
    }

    public void verifyFileFilterComboBox() {
        Container container = (Container)this.getComponent(this.getComponentCount() - 1);
        Container textFieldContainer = (Container)container.getComponent(0);
        Component textFieldComponent = textFieldContainer.getComponent(textFieldContainer.getComponentCount() - 1);
        Container comboBoxContainer = (Container)container.getComponent(container.getComponentCount() - 2);
        Component comboBoxComponent = comboBoxContainer.getComponent(1);
        if (comboBoxComponent instanceof JComboBox && textFieldComponent instanceof JTextComponent) {
            final JTextComponent textField = (JTextComponent)textFieldComponent;
            JComboBox comboBox = (JComboBox)comboBoxComponent;
            comboBox.addItemListener(new SelectionListener(){

                @Override
                public void itemSelectionStateChanged(ItemEvent e) {
                    String fileSuffix;
                    String fileName = textField.getText();
                    if (fileName.lastIndexOf(".") > -1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    }
                    textField.setText((fileSuffix = JBasicFileChooser.this.getFileSuffix()) != null ? fileName + "." + fileSuffix : fileName);
                }
            });
        }
    }

    public void verifyApprovalButton() {
        Container container = (Container)this.getComponent(this.getComponentCount() - 1);
        Container buttonContainer = (Container)container.getComponent(container.getComponentCount() - 1);
        Component approvalButtonComponent = buttonContainer.getComponent(0);
        if (approvalButtonComponent instanceof JButton) {
            JButton approvalButton = (JButton)approvalButtonComponent;
            JRootPane rootPane = this.getRootPane();
            if (rootPane != null) {
                rootPane.setDefaultButton(approvalButton);
            }
            boolean isActionListener = false;
            ActionListener[] actionListeners = approvalButton.getActionListeners();
            for (int i = 0; i < actionListeners.length; ++i) {
                ActionListener actionListener = actionListeners[i];
                if (!(actionListener instanceof ApprovalActionListener)) continue;
                isActionListener = true;
                break;
            }
            if (!isActionListener) {
                approvalButton.addActionListener(new ApprovalActionListener());
            }
        }
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public String getFileSuffix() {
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof JFileFilter) {
            List filterWords = ((JFileFilter)fileFilter).getWords();
            return filterWords.get(0).toString();
        }
        return null;
    }

    public String getType() {
        String type = null;
        int fileSelectionMode = this.getFileSelectionMode();
        switch (fileSelectionMode) {
            case 0: {
                type = SwingLocale.getString("file");
                break;
            }
            case 1: {
                type = SwingLocale.getString("directory");
                break;
            }
            case 2: {
                type = SwingLocale.getString("file_or_directory");
                break;
            }
            default: {
                type = SwingLocale.getString("file_or_directory");
            }
        }
        return type;
    }

    public class ApprovalActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI basicFileChooserUI;
            String fileName;
            FileChooserUI fileChooserUI = JBasicFileChooser.this.getUI();
            if (fileChooserUI instanceof BasicFileChooserUI && ((fileName = (basicFileChooserUI = (BasicFileChooserUI)fileChooserUI).getFileName()) == null || fileName.trim().equals(""))) {
                JBasicOptionPane.showMessageDialog(JBasicFileChooser.this.parentComponent, JBasicFileChooser.this.getType() + SwingLocale.getString("name_not_null"), SwingLocale.getString("warning"), 2);
            }
        }
    }
}

