/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.locale;

import com.nepxion.util.locale.LocaleConstants;
import com.nepxion.util.locale.LocaleContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class LocaleManager
implements LocaleConstants {
    private static Map resourceBundleMap;

    public static String getString(Class bundleClazz, String key) {
        ResourceBundle resourceBundle = LocaleManager.getResourceBundle(bundleClazz);
        return resourceBundle.getString(key);
    }

    public static String getString(Class bundleClazz, String key, Locale locale) {
        ResourceBundle resourceBundle = LocaleManager.getResourceBundle(bundleClazz, locale);
        return resourceBundle.getString(key);
    }

    public static String getString(String bundleName, String key) {
        ResourceBundle resourceBundle = LocaleManager.getResourceBundle(bundleName);
        return resourceBundle.getString(key);
    }

    public static String getString(String bundleName, String key, Locale locale) {
        ResourceBundle resourceBundle = LocaleManager.getResourceBundle(bundleName, locale);
        return resourceBundle.getString(key);
    }

    public static ResourceBundle getResourceBundle(Class bundleClazz) {
        String bundleName = LocaleManager.getBundleName(bundleClazz);
        return LocaleManager.getResourceBundle(bundleName);
    }

    public static ResourceBundle getResourceBundle(Class bundleClazz, Locale locale) {
        String bundleName = LocaleManager.getBundleName(bundleClazz);
        return LocaleManager.getResourceBundle(bundleName, locale);
    }

    public static ResourceBundle getResourceBundle(String bundleName) {
        return LocaleManager.getResourceBundle(bundleName, LocaleContext.getLocale());
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        String key;
        ResourceBundle resourceBundle;
        if (resourceBundleMap == null) {
            resourceBundleMap = new HashMap();
        }
        if ((resourceBundle = (ResourceBundle)resourceBundleMap.get(key = bundleName + "_" + locale)) == null) {
            resourceBundle = ResourceBundle.getBundle(bundleName, locale);
            resourceBundleMap.put(key, resourceBundle);
        }
        return resourceBundle;
    }

    public static String getBundleName(Class bundleClazz) {
        String bundleName = bundleClazz.getName();
        int index = bundleName.lastIndexOf(46);
        bundleName = index != -1 ? bundleName.substring(0, index) + "." + "Locale" : "Locale";
        return bundleName;
    }
}

