/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import twaver.BaseElement;
import twaver.TWaverConst;
import twaver.base.A.E.L;
import twaver.base.A.E.b;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.AbstractElementSVGUI;

public class BaseElementSVGUI
extends AbstractElementSVGUI {
    private BaseElement O = null;

    public BaseElementSVGUI(TSVGNetwork network, BaseElement element) {
        super(network, element);
        this.O = element;
    }

    protected SVGStruct toBodySVG(SVGContext context) {
        if (this.O.isCustomDraw()) {
            return this.toCustomDrawBodySVG(context);
        }
        return this.toDefaultBodySVG(context);
    }

    protected SVGStruct toDefaultBodySVG(SVGContext context) {
        StringBuffer sb = new StringBuffer();
        Rectangle bounds = this.element.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        float alpha = this.getRenderAlpha();
        Color bodyColor = this.O.getBodyColor();
        bodyColor = this.getPaintBodyColor(bodyColor);
        if (this.O.isBodyFill()) {
            Object fillObject = this.getFillObject(context, bodyColor);
            I.A(context, sb, bounds, fillObject, null, (Object)"1", alpha, 0.0, null);
        }
        I.A(context, sb, bodyColor, x, y, width, height, this.O.isBodyRaised(), alpha);
        this.appendDefaultStateOutline(sb, context, bounds);
        return new SVGStruct(sb.toString(), bounds);
    }

    public Point getHotspot(SVGContext context) {
        Point hotspot;
        if (this.O.isCustomDraw() && (hotspot = L.A(this.O.getCustomDrawShapeFactory(), this.element.getBounds())) != null) {
            return hotspot;
        }
        Rectangle bounds = this.element.getBounds();
        Point hotSpot = new Point(bounds.x + bounds.width, bounds.y);
        if (bounds.width > 3) {
            hotSpot.x -= 3;
        }
        if (bounds.height > 3) {
            hotSpot.y += 3;
        }
        return hotSpot;
    }

    protected Object getCustomDrawFillObject(SVGContext context) {
        Object fillObject = null;
        if (this.O.isCustomDrawFill()) {
            Color fillColor = this.O.getCustomDrawFillColor();
            fillColor = this.getPaintBodyColor(fillColor);
            fillObject = this.O.isCustomDrawGradient() ? this.getGradientID(context, this.O.getCustomDrawGradientFactory(), this.O.getCustomDrawGradientColor(), fillColor) : this.getFillObject(context, fillColor);
        }
        return fillObject;
    }

    protected SVGStruct toCustomDrawBodySVG(SVGContext context) {
        StringBuffer sb = new StringBuffer();
        Rectangle bounds = this.element.getBounds();
        Object fillObject = this.getCustomDrawFillObject(context);
        Shape shape = L.B(this.O.getCustomDrawShapeFactory(), bounds);
        String id = I.A(context, shape);
        float alpha = this.getRenderAlpha();
        Stroke stroke = b.F(this.element, "custom.draw.outline.stroke");
        if (!(stroke instanceof BasicStroke)) {
            stroke = TWaverConst.DOUBLE_WIDTH_STROKE;
        }
        Color outlineColor = null;
        if (this.O.isCustomDrawOutline()) {
            outlineColor = this.O.getCustomDrawOutlineColor();
            outlineColor = this.getPaintBodyColor(outlineColor);
            if (this.O.isCustomDrawOutline3D()) {
                I.A(sb, id);
                Color color = outlineColor.brighter().brighter();
                I.A(context, sb, null, (Object)color, stroke, alpha);
                I.A(sb, -1, -1).append("/>\n");
                I.A(sb, id);
                color = outlineColor.darker().darker();
                I.A(context, sb, null, (Object)color, stroke, alpha);
                I.A(sb, 1, 1).append("/>\n");
            }
        }
        I.A(sb, id);
        I.C(context, sb, fillObject, outlineColor, stroke, alpha).append("/>\n");
        this.appendCustomStateOutline(sb, context, bounds, id);
        return new SVGStruct(sb.toString(), bounds);
    }

    protected void appendDefaultStateOutline(StringBuffer sb, SVGContext context, Rectangle bounds) {
        Color stateColor = this.getStateOutlineColor();
        if (stateColor != null) {
            int insets = this.O.getStateOutlineInsets();
            if (insets > 0) {
                bounds.grow(insets, insets);
            }
            I.A(context, sb, (Shape)bounds, null, (Object)stateColor, (Object)("" + this.O.getStateOutlineWidth()), 0.0f, 0.0, null);
        }
    }

    protected void appendCustomStateOutline(StringBuffer sb, SVGContext context, Rectangle bounds, String id) {
        Color stateColor = this.getStateOutlineColor();
        if (stateColor != null) {
            int insets = this.O.getStateOutlineInsets();
            if (insets > 0) {
                bounds.grow(insets, insets);
                Shape shape = L.B(this.O.getCustomDrawShapeFactory(), bounds);
                id = I.A(context, shape);
            }
            I.A(sb, id);
            I.A(context, sb, null, (Object)stateColor, "2", 0.0f).append("/>\n");
        }
    }
}

