/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.layout.toolbar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ToolBarLayout
implements LayoutManager {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int axis;

    public ToolBarLayout() {
        this(0);
    }

    public ToolBarLayout(int axis) {
        this.axis = axis;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = new Dimension();
        Insets insets = parent.getInsets();
        if (this.axis == 0) {
            size.width += insets.left + insets.right;
        } else if (this.axis == 1) {
            size.height += insets.top + insets.bottom;
        }
        for (int i = 0; i < parent.getComponents().length; ++i) {
            Component component = parent.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            component.setVisible(true);
            if (this.axis == 0) {
                size.width += dimension.width;
                size.height = Math.max(size.height, dimension.height);
                continue;
            }
            if (this.axis != 1) continue;
            size.width += Math.max(size.width, dimension.width);
            size.height = dimension.height;
        }
        if (this.axis == 0) {
            size.height += insets.top + insets.bottom;
        } else if (this.axis == 1) {
            size.width += insets.left + insets.right;
        }
        return size;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        block5: {
            int index;
            int lastButtonIndex;
            int height;
            block4: {
                int index2;
                Dimension size = this.calculatesSize(parent);
                Insets insets = parent.getInsets();
                int x = insets.left;
                int y = insets.top;
                int width = insets.left + insets.right;
                height = insets.top + insets.bottom;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component component = parent.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension);
                    if (this.axis == 0) {
                        component.setLocation(x, y + (size.height - dimension.height) / 2);
                        x += dimension.width;
                        width += dimension.width;
                        continue;
                    }
                    if (this.axis != 1) continue;
                    component.setLocation(x + (size.width - dimension.width) / 2, y);
                    y += dimension.height;
                    height += dimension.height;
                }
                lastButtonIndex = 0;
                if (this.axis != 0) break block4;
                int parentWidth = parent.getSize().width;
                while (width > parentWidth && (index2 = parent.getComponentCount() - ++lastButtonIndex) > -1) {
                    Component component = parent.getComponent(index2);
                    component.setVisible(false);
                    width -= component.getSize().width;
                }
                break block5;
            }
            if (this.axis != 1) break block5;
            int parentHeight = parent.getSize().height;
            while (height > parentHeight && (index = parent.getComponentCount() - ++lastButtonIndex) > -1) {
                Component component = parent.getComponent(index);
                component.setVisible(false);
                height -= component.getSize().height;
            }
        }
    }

    private Dimension calculatesSize(Container parent) {
        Dimension size = new Dimension();
        size.width = 0;
        size.height = 0;
        for (int i = 0; i < parent.getComponents().length; ++i) {
            Component component = parent.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            if (this.axis == 0) {
                size.width += dimension.width;
                size.height = Math.max(size.height, dimension.height);
                continue;
            }
            if (this.axis != 1) continue;
            size.width += Math.max(size.width, dimension.width);
            size.height = dimension.height;
        }
        return size;
    }
}

