/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.keystroke;

import com.nepxion.swing.button.ButtonAncestorListener;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class KeyStrokeManager {
    public static void registerComponent(JComponent component, ActionListener actionListener, int keyCode) {
        KeyStrokeManager.registerComponent(component, actionListener, keyCode, 0);
    }

    public static void registerComponent(JComponent component, ActionListener actionListener, int keyCode, int modifiers) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        KeyStrokeManager.registerComponent(component, actionListener, keyStroke);
    }

    public static void registerComponent(JComponent component, ActionListener actionListener, KeyStroke keyStroke) {
        component.registerKeyboardAction(actionListener, keyStroke, 1);
    }

    public static void registerComponentToEnterKey(JComponent component, ActionListener actionListener) {
        KeyStrokeManager.registerComponent(component, actionListener, 10, 0);
    }

    public static void registerComponentToEscapeKey(JComponent component, ActionListener actionListener) {
        KeyStrokeManager.registerComponent(component, actionListener, 27, 0);
    }

    public static void registerButton(AbstractButton button, int keyCode) {
        KeyStrokeManager.registerButton(button, (ActionListener)button.getAction(), keyCode);
    }

    public static void registerButton(AbstractButton button, ActionListener actionListener, int keyCode) {
        KeyStrokeManager.registerButton(button, actionListener, keyCode, 0);
    }

    public static void registerButton(AbstractButton button, int keyCode, int modifiers) {
        KeyStrokeManager.registerButton(button, (ActionListener)button.getAction(), keyCode, modifiers);
    }

    public static void registerButton(AbstractButton button, ActionListener actionListener, int keyCode, int modifiers) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        KeyStrokeManager.registerButton(button, actionListener, keyStroke);
    }

    public static void registerButton(AbstractButton button, KeyStroke keyStroke) {
        KeyStrokeManager.registerButton(button, (ActionListener)button.getAction(), keyStroke);
    }

    public static void registerButton(AbstractButton button, ActionListener actionListener, KeyStroke keyStroke) {
        if (button instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)button;
            menuItem.setAccelerator(keyStroke);
        } else {
            button.registerKeyboardAction(actionListener, keyStroke, 2);
        }
    }

    public static void registerButton(AbstractButton button, int keyCode, char mnemonic) {
        KeyStrokeManager.registerButton(button, (ActionListener)button.getAction(), keyCode, mnemonic);
    }

    public static void registerButton(AbstractButton button, ActionListener actionListener, int keyCode, char mnemonic) {
        KeyStrokeManager.registerButton(button, actionListener, keyCode, 0, mnemonic);
    }

    public static void registerButton(AbstractButton button, int keyCode, int modifiers, char mnemonic) {
        KeyStrokeManager.registerButton(button, button.getAction(), keyCode, modifiers, mnemonic);
    }

    public static void registerButton(AbstractButton button, ActionListener actionListener, int keyCode, int modifiers, char mnemonic) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        KeyStrokeManager.registerButton(button, actionListener, keyStroke, mnemonic);
    }

    public static void registerButton(AbstractButton button, KeyStroke keyStroke, char mnemonic) {
        KeyStrokeManager.registerButton(button, (ActionListener)button.getAction(), keyStroke, mnemonic);
    }

    public static void registerButton(AbstractButton button, ActionListener actionListener, KeyStroke keyStroke, char mnemonic) {
        KeyStrokeManager.registerButton(button, actionListener, keyStroke);
        button.setMnemonic(mnemonic);
    }

    public static void registerButtonToEnterKey(AbstractButton button) {
        KeyStrokeManager.registerButtonToEnterKey(button, button.getAction());
    }

    public static void registerButtonToEnterKey(AbstractButton button, ActionListener actionListener) {
        KeyStrokeManager.registerButton(button, actionListener, 10, 0, 'Y');
        button.addAncestorListener(new ButtonAncestorListener());
    }

    public static void registerButtonToEscapeKey(AbstractButton button) {
        KeyStrokeManager.registerButtonToEscapeKey(button, button.getAction());
    }

    public static void registerButtonToEscapeKey(AbstractButton button, ActionListener actionListener) {
        KeyStrokeManager.registerButton(button, actionListener, 27, 0, 'N');
    }
}

