/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.searcher.ip.netease;

import com.nepxion.util.net.http.apache.ClientInvoker;
import com.nepxion.util.net.http.apache.ClientParameterList;
import com.nepxion.util.net.http.apache.ClientRequestGet;
import com.nepxion.util.searcher.ip.netease.NeteaseIPConstants;
import com.nepxion.util.searcher.ip.netease.NeteaseIPEntity;
import com.nepxion.util.xml.dom4j.Dom4JReader;
import java.net.URI;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class NeteaseIPSearcher
implements NeteaseIPConstants {
    private String charset = "GBK";
    private ClientInvoker clientInvoker;

    public NeteaseIPSearcher() {
        this("GBK");
    }

    public NeteaseIPSearcher(String charset) {
        this.charset = charset;
        this.clientInvoker = new ClientInvoker();
    }

    public NeteaseIPEntity search(String ip) throws Exception {
        String xml = this.getXML(ip);
        return this.createEntity(xml);
    }

    private NeteaseIPEntity createEntity(String xml) {
        if (xml == null || xml.equals("")) {
            return null;
        }
        Document document = null;
        try {
            document = Dom4JReader.getDocument(xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        Element productElement = rootElement.element("product");
        NeteaseIPEntity ipEntity = new NeteaseIPEntity();
        Element ipElement = productElement.element("ip");
        ipEntity.setIP(ipElement.getText());
        Element locationElement = productElement.element("location");
        String location = locationElement.getText();
        String country = "";
        String region = "";
        int index = location.indexOf(" ");
        if (index > -1) {
            country = location.substring(0, index);
            region = location.substring(index + 1).equals("") ? location : location.substring(index + 1);
        } else {
            country = "";
            region = location;
        }
        ipEntity.setCountry(country);
        ipEntity.setRegion(region);
        return ipEntity;
    }

    public String getXML(String ip) throws Exception {
        ClientRequestGet clientRequestGet = new ClientRequestGet();
        clientRequestGet.setURI(URI.create("http://www.youdao.com/smartresult-xml/search.s"));
        ClientParameterList clientParameterList = new ClientParameterList();
        clientParameterList.put("q", ip);
        clientParameterList.put("type", "ip");
        clientRequestGet.setParameterEntity(clientParameterList, this.charset);
        String responseText = this.clientInvoker.getResponseText(clientRequestGet, this.charset);
        return responseText;
    }
}

