/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import y.algo.GraphConnectivity;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.layout.AbstractLayoutStage;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;
import y.util.D;

public class ComponentLayouter
extends AbstractLayoutStage {
    private double ce;
    private double ch;
    private double cf;
    private double cg = 45.0;

    public ComponentLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
    }

    public ComponentLayouter() {
        this.setPreferredLayoutSize(400.0, 400.0);
    }

    public void setPreferredLayoutSize(double d2, double d3) {
        this.ce = d2;
        this.ch = d3;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() != null) {
            YCursor yCursor;
            YCursor yCursor2;
            Object object;
            boolean bl = true;
            NodeMap nodeMap = layoutGraph.createNodeMap();
            int n = GraphConnectivity.connectedComponents(layoutGraph, nodeMap);
            NodeList[] nodeListArray = new NodeList[n];
            EdgeList[] edgeListArray = new EdgeList[n];
            int n2 = 0;
            while (n2 < n) {
                nodeListArray[n2] = new NodeList();
                edgeListArray[n2] = new EdgeList();
                ++n2;
            }
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                object = edgeCursor.edge();
                edgeListArray[nodeMap.getInt(((Edge)object).source())].add(object);
                layoutGraph.hide((Edge)object);
                edgeCursor.next();
            }
            object = layoutGraph.nodes();
            while (object.ok()) {
                Node node = object.node();
                nodeListArray[nodeMap.getInt(node)].add(node);
                layoutGraph.hide(object.node());
                object.next();
            }
            int n3 = 0;
            while (n3 < n) {
                NodeCursor nodeCursor = nodeListArray[n3].nodes();
                while (nodeCursor.ok()) {
                    layoutGraph.unhide(nodeCursor.node());
                    nodeCursor.next();
                }
                yCursor2 = edgeListArray[n3].edges();
                while (yCursor2.ok()) {
                    layoutGraph.unhide(yCursor2.edge());
                    yCursor2.next();
                }
                bl = this.canLayoutCore(layoutGraph);
                EdgeCursor edgeCursor2 = edgeListArray[n3].edges();
                while (edgeCursor2.ok()) {
                    layoutGraph.hide(edgeCursor2.edge());
                    edgeCursor2.next();
                }
                yCursor = nodeListArray[n3].nodes();
                while (yCursor.ok()) {
                    layoutGraph.hide(yCursor.node());
                    yCursor.next();
                }
                if (!bl) break;
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                yCursor2 = nodeListArray[n4].nodes();
                while (yCursor2.ok()) {
                    layoutGraph.unhide(yCursor2.node());
                    yCursor2.next();
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < n) {
                yCursor = edgeListArray[n5].edges();
                while (yCursor.ok()) {
                    layoutGraph.unhide(yCursor.edge());
                    yCursor.next();
                }
                ++n5;
            }
            layoutGraph.disposeNodeMap(nodeMap);
            return bl;
        }
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor;
        double d2;
        YCursor yCursor;
        Object object;
        D.bug(this, (Object)"Do the component layout ..");
        D.bug(this, (Object)"-> Calculate the connected components..");
        D.bug(this, (Object)("--> Number of nodes " + layoutGraph.nodeCount()));
        D.bug(this, (Object)("--> Number of edges " + layoutGraph.edgeCount()));
        if (layoutGraph.isEmpty()) {
            return;
        }
        NodeMap nodeMap = layoutGraph.createNodeMap();
        int n = GraphConnectivity.connectedComponents(layoutGraph, nodeMap);
        D.bug(this, (Object)("--> Number of components: " + n));
        D.bug(this, (Object)"-> Layout the components..");
        NodeList[] nodeListArray = new NodeList[n];
        EdgeList[] edgeListArray = new EdgeList[n];
        YRectangle[] yRectangleArray = new YRectangle[n];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n];
        int n2 = 0;
        while (n2 < n) {
            nodeListArray[n2] = new NodeList();
            edgeListArray[n2] = new EdgeList();
            ++n2;
        }
        EdgeCursor edgeCursor2 = layoutGraph.edges();
        while (edgeCursor2.ok()) {
            object = edgeCursor2.edge();
            edgeListArray[nodeMap.getInt(((Edge)object).source())].add(object);
            layoutGraph.hide((Edge)object);
            edgeCursor2.next();
        }
        object = layoutGraph.nodes();
        while (object.ok()) {
            Node node = object.node();
            nodeListArray[nodeMap.getInt(node)].add(node);
            layoutGraph.hide(object.node());
            object.next();
        }
        int n3 = 0;
        while (n3 < n) {
            NodeCursor nodeCursor = nodeListArray[n3].nodes();
            while (nodeCursor.ok()) {
                layoutGraph.unhide(nodeCursor.node());
                nodeCursor.next();
            }
            yCursor = edgeListArray[n3].edges();
            while (yCursor.ok()) {
                layoutGraph.unhide(yCursor.edge());
                yCursor.next();
            }
            D.bug(this, (Object)("--> Number of nodes in component:" + layoutGraph.nodeCount()));
            D.bug(this, (Object)("--> Number of edges in component:" + layoutGraph.edgeCount()));
            this.doLayoutCore(layoutGraph);
            Rectangle rectangle = layoutGraph.getBoundingBox();
            yRectangleArray[n3] = new YRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle2DArray[n3] = new Rectangle2D.Double();
            if (this.cf > 0.0) {
                double d3 = this.cg + Math.ceil((rectangle.getWidth() + 1.0) / this.cf) * this.cf;
                d2 = this.cg + Math.ceil((rectangle.getHeight() + 1.0) / this.cf) * this.cf;
                rectangle2DArray[n3].setFrame(rectangle.getX(), rectangle.getY(), d3, d2);
            } else {
                rectangle2DArray[n3].setFrame(rectangle.getX(), rectangle.getY(), rectangle.getWidth() + this.cg, rectangle.getHeight() + this.cg);
            }
            edgeCursor = edgeListArray[n3].edges();
            while (edgeCursor.ok()) {
                layoutGraph.hide(edgeCursor.edge());
                edgeCursor.next();
            }
            NodeCursor nodeCursor2 = nodeListArray[n3].nodes();
            while (nodeCursor2.ok()) {
                layoutGraph.hide(nodeCursor2.node());
                nodeCursor2.next();
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            yCursor = nodeListArray[n4].nodes();
            while (yCursor.ok()) {
                layoutGraph.unhide(yCursor.node());
                yCursor.next();
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            edgeCursor = edgeListArray[n5].edges();
            while (edgeCursor.ok()) {
                layoutGraph.unhide(edgeCursor.edge());
                edgeCursor.next();
            }
            ++n5;
        }
        D.bug(this, (Object)"-> Arrange the components..");
        LayoutTool.arrangeRectangleRows(rectangle2DArray, null, this.ce / this.ch);
        if (this.cf <= 0.0) {
            int n6 = 0;
            while (n6 < rectangle2DArray.length) {
                this.setOrigin(layoutGraph, nodeListArray[n6], edgeListArray[n6], new YPoint(rectangle2DArray[n6].getX(), rectangle2DArray[n6].getY()), yRectangleArray[n6]);
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < rectangle2DArray.length) {
                d2 = Math.floor((rectangle2DArray[n7].getX() - yRectangleArray[n7].getX()) / this.cf) * this.cf;
                double d4 = Math.floor((rectangle2DArray[n7].getY() - yRectangleArray[n7].getY()) / this.cf) * this.cf;
                double d5 = yRectangleArray[n7].getX() + d2;
                double d6 = yRectangleArray[n7].getY() + d4;
                this.setOrigin(layoutGraph, nodeListArray[n7], edgeListArray[n7], new YPoint(d5, d6), yRectangleArray[n7]);
                ++n7;
            }
        }
        D.bug(this, (Object)"done !");
        layoutGraph.disposeNodeMap(nodeMap);
    }

    protected void arrangeComponentGraphs(LayoutGraph layoutGraph, NodeList[] nodeListArray, EdgeList[] edgeListArray, YRectangle[] yRectangleArray, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        D.bug(this, (Object)"Linear arrangement");
        int n = 0;
        while (n < nodeListArray.length) {
            D.bug(this, (Object)"Calc bb");
            YRectangle yRectangle = yRectangleArray[n];
            D.bug(this, (Object)("BB: " + yRectangle));
            if (bl) {
                D.bug(this, (Object)("Leftbound: " + d2));
                this.setOrigin(layoutGraph, nodeListArray[n], edgeListArray[n], new YPoint(d2, 0.0), yRectangleArray[n]);
                d2 += yRectangle.getWidth() + 40.0;
            } else {
                this.setOrigin(layoutGraph, nodeListArray[n], edgeListArray[n], new YPoint(0.0, d3), yRectangleArray[n]);
                d3 += yRectangle.getHeight() + 40.0;
            }
            ++n;
        }
    }

    protected void setOrigin(LayoutGraph layoutGraph, NodeList nodeList, EdgeList edgeList, YPoint yPoint, YRectangle yRectangle) {
        Object object;
        double d2 = -yRectangle.getX() + yPoint.getX();
        double d3 = -yRectangle.getY() + yPoint.getY();
        NodeCursor nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            object = layoutGraph.getLocation(nodeCursor.node());
            layoutGraph.setLocation(nodeCursor.node(), new YPoint(((YPoint)object).getX() + d2, ((YPoint)object).getY() + d3));
            nodeCursor.next();
        }
        object = edgeList.edges();
        while (object.ok()) {
            Edge edge = object.edge();
            Vector<YPoint> vector = new Vector<YPoint>();
            YCursor yCursor = layoutGraph.getPoints(edge).cursor();
            while (yCursor.ok()) {
                YPoint yPoint2 = (YPoint)yCursor.current();
                vector.addElement(new YPoint(yPoint2.getX() + d2, yPoint2.getY() + d3));
                yCursor.next();
            }
            layoutGraph.setPoints(edge, new YPointPath(vector));
            object.next();
        }
        this.a(layoutGraph, nodeList, edgeList, yPoint, yRectangle);
    }

    private void a(LayoutGraph layoutGraph, NodeList nodeList, EdgeList edgeList, YPoint yPoint, YRectangle yRectangle) {
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        if (dataProvider != null) {
            double d2 = -yRectangle.getX() + yPoint.getX();
            double d3 = -yRectangle.getY() + yPoint.getY();
            EdgeCursor edgeCursor = edgeList.edges();
            while (edgeCursor.ok()) {
                LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(edgeCursor.edge());
                if (labelLayoutDataArray != null) {
                    int n = 0;
                    while (n < labelLayoutDataArray.length) {
                        labelLayoutDataArray[n].setLocation(labelLayoutDataArray[n].getX() + d2, labelLayoutDataArray[n].getY() + d3);
                        ++n;
                    }
                }
                edgeCursor.next();
            }
        }
    }

    public double getGridSpacing() {
        return this.cf;
    }

    public void setGridSpacing(double d2) {
        this.cf = d2;
    }

    public double getComponentSpacing() {
        return this.cg;
    }

    public void setComponentSpacing(double d2) {
        this.cg = d2;
    }
}

