/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import twaver.A.A.C.A.A;
import twaver.A.A.C.A.B;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxQuickFinder;
import twaver.DataBoxSelectionModel;
import twaver.Element;
import twaver.Generator;
import twaver.GeoCoordinate;
import twaver.Link;
import twaver.PolyLine;
import twaver.ShapeNode;
import twaver.TDataBox;
import twaver.TWaverUtil;
import twaver.gis.GeographyFeature;
import twaver.gis.GeographyMap;
import twaver.gis.GisManager;
import twaver.gis.event.MapEvent;
import twaver.gis.event.MapListener;
import twaver.gis.filter.PanActionFilter;
import twaver.gis.filter.VoronoiElementFilter;
import twaver.gis.gadget.VoronoiDiagram;
import twaver.gis.utils.GisInputHandlerFactory;
import twaver.gis.utils.GisToolkits;
import twaver.network.InteractionEvent;
import twaver.network.InteractionListener;
import twaver.network.InteractionModeFactory;
import twaver.network.TNetwork;
import twaver.network.background.Background;

public class GisNetworkAdapter {
    private TNetwork T;
    private GeographyMap Q;
    private ComponentListener G;
    private MapListener A;
    private DataBoxListener H;
    private InteractionListener K;
    private PropertyChangeListener I;
    private PropertyChangeListener J;
    private Timer C;
    private static final int E = 100;
    private boolean B;
    private VoronoiDiagram O;
    private VoronoiElementFilter R;
    private Generator F;
    private boolean L;
    private DataBoxQuickFinder N;
    private MouseWheelListener D;
    private PanActionFilter P;
    private boolean S;
    private MouseAdapter M;

    public GisNetworkAdapter(TNetwork network) {
        this.T = network;
        this.M();
        this.G();
    }

    public void setLocateWithFilter(boolean v) {
        this.S = v;
    }

    public void setVoronoiGraphBoundsShapeGenerator(Generator gengerator) {
        this.F = gengerator;
    }

    public GeographyMap getMap() {
        return this.Q;
    }

    public void unInstallAdapter() {
        this.B(false);
    }

    public void setVoronoiElementFilter(VoronoiElementFilter filter) {
        this.R = filter;
    }

    public void setVoronoiDiagram(VoronoiDiagram diagram) {
        Background bg = this.T.getCurrentBackground();
        if (bg instanceof twaver.A.A.D.B) {
            ((twaver.A.A.D.B)bg).setVoronoiDiagram(diagram);
        }
    }

    private synchronized void A(boolean dirty) {
        this.B = dirty;
    }

    private synchronized boolean F() {
        return this.B;
    }

    private void E() {
        this.C = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GisNetworkAdapter.this.Q != null && GisNetworkAdapter.this.F() && GisNetworkAdapter.this.T.isShowing()) {
                    GisNetworkAdapter.this.reLocateElements();
                    GisNetworkAdapter.this.A(false);
                }
            }
        });
        this.C.start();
    }

    private void M() {
        if (this.T != null) {
            this.H = new DataBoxListener(){

                public void elementAdded(DataBoxEvent e) {
                    if (GisNetworkAdapter.this.T.isShowing()) {
                        Element element = e.getElement();
                        Object o = element.getClientProperty((Object)"geocoordinates");
                        if (o instanceof GeoCoordinate) {
                            GisNetworkAdapter.this.A(element, GisNetworkAdapter.this.Q);
                        } else {
                            GisNetworkAdapter.this.A(GisNetworkAdapter.this.Q, element);
                        }
                    }
                }

                public void elementRemoved(DataBoxEvent e) {
                }

                public void elementsCleared(DataBoxEvent e) {
                }
            };
        }
    }

    private void G() {
        if (this.T == null) {
            return;
        }
        this.I = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("databox".equals(evt.getPropertyName()) && GisNetworkAdapter.this.T.isShowing()) {
                    GisNetworkAdapter.this.reLocateElements();
                }
            }
        };
        this.J = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (GisNetworkAdapter.this.T.isShowing()) {
                    String propertyName = TWaverUtil.getPropertyName((PropertyChangeEvent)evt);
                    Element element = (Element)evt.getSource();
                    if ("geocoordinates".equals(propertyName)) {
                        GisNetworkAdapter.this.A(element, GisNetworkAdapter.this.getMap());
                    }
                }
            }
        };
        this.K = new InteractionListener(){

            public void interactionPerformed(InteractionEvent event) {
                int type = event.getType();
                if (5 == type || 9 == type || 3 == type) {
                    DataBoxSelectionModel model = (DataBoxSelectionModel)event.getSource();
                    Iterator selectedElements = model.getAllSelectedElement().iterator();
                    while (selectedElements.hasNext()) {
                        Element element = (Element)selectedElements.next();
                        GisNetworkAdapter.this.A(GisNetworkAdapter.this.Q, element);
                    }
                }
            }
        };
    }

    private void T() {
        this.Q = new B();
        this.D = new twaver.A.A.C.D.B(this.Q);
    }

    private void Q() {
        this.M = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && GisNetworkAdapter.this.isZoomInByDoubleClick() && GisNetworkAdapter.this.Q.getMapMode() == -1 && GisNetworkAdapter.this.T.getSelectionModel().getAllSelectedElement().size() == 0) {
                    Point clickPoint = e.getPoint();
                    double[] ll = GisNetworkAdapter.this.Q.getLL(clickPoint.getX(), clickPoint.getY());
                    if (ll != null) {
                        GisNetworkAdapter.this.Q.addBackAndForwardTask();
                        if (GisNetworkAdapter.this.Q instanceof A) {
                            A tm = (A)GisNetworkAdapter.this.Q;
                            tm.setCenterPoint(new GeoCoordinate(ll[0], ll[1]));
                            tm.setZoom(tm.getZoom() + 1);
                        }
                    }
                }
            }
        };
    }

    private void B(boolean isInitialization) {
        this.T.setEnableMouseWheelToZoom(!isInitialization);
        this.T.setEnableAutoAdjustCanvasSize(!isInitialization);
        this.T.setEnableAutoScroll(!isInitialization);
        if (isInitialization) {
            this.T.getCanvasScrollPane().setHorizontalScrollBarPolicy(31);
            this.T.getCanvasScrollPane().setVerticalScrollBarPolicy(21);
            this.J();
            this.A();
            this.N();
            this.B();
            this.I();
            this.P();
            this.N = this.T.getDataBox().createClientPropertyFinder("twaver.selectedfeature.shape");
        } else {
            this.T.getCanvasScrollPane().setHorizontalScrollBarPolicy(30);
            this.T.getCanvasScrollPane().setVerticalScrollBarPolicy(20);
            this.S();
            this.R();
            this.C();
            this.D();
            this.L();
            this.K();
        }
    }

    private void L() {
        this.T.setToolbarByName("default");
    }

    private void P() {
        this.T.setToolbarByName("TileGisClientToolbar");
    }

    private void K() {
        this.T.getCanvas().removeMouseListener(this.M);
        this.T.setCurrentBackground(null);
        this.O = null;
        this.setVoronoiElementFilter(null);
    }

    private void B() {
        twaver.A.A.D.B background = null;
        background = new twaver.A.A.D.B(this.T);
        this.O = new VoronoiDiagram();
        background.setVoronoiDiagram(this.O);
        this.T.getCanvas().addMouseListener(this.M);
        if (background != null) {
            background.setMap(this.Q);
            this.T.setBackground((Background)background);
        }
    }

    public VoronoiDiagram getVoronoiDiagram() {
        return this.O;
    }

    public void enableVoronoiGraphVisible(boolean isVisible) {
        if (this.O != null) {
            this.O.setVisible(isVisible);
            this.H();
        }
        Background bg = this.T.getCurrentBackground();
        ((twaver.A.A.D.B)bg).clearVoronoiGraphCache();
    }

    public boolean isVoronoiGraphVisible() {
        if (this.O != null) {
            return this.O.isVisible();
        }
        return false;
    }

    private void D() {
        if (this.G != null) {
            this.T.getCanvasScrollPane().removeComponentListener(this.G);
        }
    }

    private void A() {
        final GeographyMap map = this.getMap();
        if (map != null) {
            this.G = new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    Rectangle viewport = GisNetworkAdapter.this.T.getCanvasScrollPane().getViewport().getVisibleRect();
                    GisNetworkAdapter.this.T.putClientProperty((Object)"viewport", (Object)viewport);
                    if (viewport.getWidth() > 0.0) {
                        map.setViewport(viewport);
                        if (GisNetworkAdapter.this.isVoronoiGraphVisible()) {
                            GisNetworkAdapter.this.O.setVisibleBounds(viewport);
                        }
                    }
                }
            };
            this.T.getCanvasScrollPane().addComponentListener(this.G);
        }
    }

    public void reLocateElements() {
        List elements = this.T.getDataBox().getAllElements();
        GeographyMap map = this.getMap();
        this.A(elements, true);
        this.A(elements, map);
        this.A(elements, false);
        Background bg = this.T.getCurrentBackground();
        if (bg instanceof twaver.A.A.D.B) {
            ((twaver.A.A.D.B)bg).clearVoronoiGraphCache();
        }
        this.T.getCanvas().repaint();
    }

    private void A(List elements, GeographyMap map) {
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            boolean doLocate = true;
            if (this.S) {
                doLocate = this.T.isVisible(element);
            }
            if (!doLocate) continue;
            this.A(element, map);
        }
        this.H();
    }

    private void A(List elements, boolean freeze) {
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof Link)) continue;
            Link link = (Link)element;
            link.setShapeFrozen(freeze);
        }
    }

    private void A(Element element, GeographyMap map) {
        GisToolkits.locateElement(element, map);
        if (element instanceof PolyLine) {
            PolyLine pl = (PolyLine)element;
            Object[] plns = pl.getAllNodes().toArray();
            int j = 0;
            while (j < plns.length) {
                this.A((Element)plns[j], map);
                ++j;
            }
            return;
        }
        if (element instanceof ShapeNode) {
            this.A(map, this.T, (ShapeNode)element, GisManager.getBoolean("optimize.gepmetry"));
        }
    }

    private void A(GeographyMap map, TNetwork network, ShapeNode region, boolean optimize) {
        if (network.isVisible((Element)region)) {
            region.clear();
            List vp = GisToolkits.getRegionPath(map, region, optimize);
            if (vp != null) {
                region.setPoints((List)vp.get(0));
                region.setSegments((List)vp.get(1));
            }
        }
    }

    private void I() {
        this.T.addPropertyChangeListener(this.I);
        this.T.addInteractionListener(this.K);
        this.T.getCanvas().addMouseWheelListener(this.D);
        this.T.setInteractionMode(GisInputHandlerFactory.createDefaultMode(this.T, this.Q));
    }

    private void R() {
        this.T.removePropertyChangeListener(this.I);
        this.T.removeInteractionListener(this.K);
        this.T.getCanvas().removeMouseWheelListener(this.D);
        this.T.setInteractionMode(InteractionModeFactory.getDefaultMode((TNetwork)this.T));
    }

    private void C() {
        TDataBox box = this.T.getDataBox();
        box.removeDataBoxListener(this.H);
        box.removeElementPropertyChangeListener(this.J);
    }

    private void N() {
        TDataBox box = this.T.getDataBox();
        box.addDataBoxListener(this.H);
        box.addElementPropertyChangeListener(this.J);
    }

    private void A(GeographyMap map, Element element) {
        GisToolkits.setGeographicalCoordinate(map, element);
    }

    private void J() {
        this.A = new MapListener(){

            public void mapChanged(MapEvent evt) {
                int type = evt.getEventType();
                if (2 == type || 1 == type || 3 == type) {
                    int mode = GisNetworkAdapter.this.Q.getMapMode();
                    if (3 == mode || -1 == mode) {
                        GisNetworkAdapter.this.reLocateElements();
                    } else {
                        GisNetworkAdapter.this.A(true);
                    }
                    GisNetworkAdapter.this.T.getCanvas().repaint();
                } else if (4 == type) {
                    GeographyFeature[] selectedFeatures = GisNetworkAdapter.this.Q.getSelectedFeatures();
                    if (selectedFeatures.length > 0) {
                        GisNetworkAdapter.this.A(selectedFeatures);
                    } else {
                        GisNetworkAdapter.this.O();
                    }
                }
            }
        };
        this.getMap().addMapListener(this.A);
    }

    private void O() {
        TDataBox box = this.T.getDataBox();
        List selectedShape = this.N.find((Object)Boolean.TRUE);
        if (selectedShape != null) {
            Iterator iterator = new Vector(selectedShape).iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!(element instanceof ShapeNode)) continue;
                box.removeElement(element);
            }
        }
    }

    private void A(final GeographyFeature[] features) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.O();
            this.A(features, this.T);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GisNetworkAdapter.this.A(features);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void A(GeographyFeature[] features, TNetwork network) {
        if (features != null) {
            int i = 0;
            while (i < features.length) {
                twaver.A.A.C.I.A feature = (twaver.A.A.C.I.A)features[i];
                ShapeNode node = new ShapeNode();
                node.putClientProperty((Object)"twaver.selectedfeature.shape", (Object)Boolean.TRUE);
                Vector points = feature.getPoints();
                node.putClientProperty((Object)"shape_bounds", (Object)points);
                node.setShapeNodeType(1);
                node.putCustomDrawFill(true);
                node.putCustomDrawOutline(true);
                node.putCustomDrawGradient(false);
                node.putCustomDrawOutlineStroke("solid.1");
                node.putCustomDrawOutlineColor(Color.GREEN.brighter());
                node.putCustomDrawFillColor(Color.GREEN.brighter());
                node.putRenderAlpha(0.3f);
                network.getDataBox().addElement((Element)node);
                ++i;
            }
        }
    }

    private void H() {
        if (this.O != null) {
            this.O.clear();
        }
        if (this.isVoronoiGraphVisible()) {
            List elements = this.T.getDataBox().getAllElements();
            if (this.F != null) {
                this.O.setClipShape((Shape)this.F.generate(null));
            }
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                this.A((Element)iterator.next());
            }
        }
    }

    private void A(Element element) {
        if (this.R != null && this.T.isVisible(element) && this.R.isVoronoiElement(element)) {
            this.O.addSite(element);
        }
    }

    private void S() {
        this.getMap().removeMapListener(this.A);
    }

    public void installAdapter() {
        this.T();
        this.B(true);
        this.E();
    }

    public boolean isZoomInByDoubleClick() {
        return this.L;
    }

    public void setZoomInByDoubleClick(boolean zoomInByDoubleClick) {
        this.L = zoomInByDoubleClick;
    }
}

