/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.toggle;

import com.nepxion.swing.container.JContainer;
import com.nepxion.swing.panel.decoration.JDecorationHeader;
import com.nepxion.swing.toggle.IToggleContentPanel;
import com.nepxion.swing.toggle.ITogglePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JToggleContentPanel
extends JPanel
implements IToggleContentPanel {
    private JContainer container;
    private JDecorationHeader header = new JDecorationHeader();
    private JPanel bannerPanel;

    public JToggleContentPanel() {
        this(false);
    }

    public JToggleContentPanel(boolean isHeaderDecorated) {
        this(isHeaderDecorated, true);
    }

    public JToggleContentPanel(boolean isHeaderDecorated, boolean isHeaderVisible) {
        if (!isHeaderDecorated) {
            this.header.setGradientColor(UIManager.getColor("Panel.background"));
            this.header.setBackground(UIManager.getColor("Panel.background"));
            this.header.getLabel().setForeground(Color.black);
        }
        if (isHeaderVisible) {
            this.bannerPanel = new JPanel();
            this.bannerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.bannerPanel.setLayout(new BorderLayout());
            this.bannerPanel.add((Component)this.header, "Center");
        }
        this.container = new JContainer();
        this.container.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        if (isHeaderVisible) {
            this.add((Component)this.bannerPanel, "North");
        }
        this.add((Component)this.container, "Center");
    }

    public JContainer getWorkspace() {
        return this.container;
    }

    public JDecorationHeader getHeader() {
        return this.header;
    }

    public JPanel getBannerPanel() {
        return this.bannerPanel;
    }

    public void setTitle(String title) {
        this.header.setTitle(title);
    }

    public void setIcon(Icon icon) {
        this.header.setIcon(icon);
    }

    @Override
    public void toggle(ITogglePanel togglePanel) {
        this.setTitle(togglePanel.getToggleDescription());
        this.setIcon(togglePanel.getToggleBannerIcon());
        this.container.addComponent((JPanel)((Object)togglePanel), "Center");
    }
}

