/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.tree;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.tree.animation.AnimationImageObserver;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ElementTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final String TREE_THEME_CLASSIC = "theme/tree/classic/";
    public static final String TREE_THEME_PLASTIC = "theme/tree/plastic/";
    public static final String TREE_THEME_LUNIX = "theme/tree/lunix/";
    public static final String TREE_THEME_WINDOWS = "theme/tree/windows/";
    public static final String TREE_THEME_NIMBUS = "theme/tree/nimbus/";
    public static final String TREE_THEME_HELP = "theme/tree/help/";
    private String treeTheme;
    private int rowHeight;

    public ElementTreeCellRenderer() {
        this(-1);
    }

    public ElementTreeCellRenderer(int rowHeight) {
        this(TREE_THEME_PLASTIC, rowHeight);
    }

    public ElementTreeCellRenderer(String treeTheme) {
        this(treeTheme, -1);
    }

    public ElementTreeCellRenderer(String treeTheme, int rowHeight) {
        this.treeTheme = treeTheme;
        this.rowHeight = rowHeight;
    }

    public String getTreeTheme() {
        return this.treeTheme;
    }

    public void setTreeTheme(String treeTheme) {
        this.treeTheme = treeTheme;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode treeNode;
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        if (this.rowHeight > 0 && tree.getRowHeight() != this.rowHeight) {
            tree.setRowHeight(this.rowHeight);
        }
        if ((treeNode = (DefaultMutableTreeNode)value) instanceof IElementNode) {
            IElementNode element = (IElementNode)((Object)treeNode);
            this.setFacade(tree, element, treeNode, expanded);
        } else {
            this.adaptIcon(treeNode, expanded);
        }
        return this;
    }

    private void setFacade(JTree tree, IElementNode element, DefaultMutableTreeNode treeNode, boolean expanded) {
        this.setText(element.getText());
        this.setToolTipText(element.getToolTipText());
        if (element.getIcon() != null) {
            if (element.getIcon() instanceof ImageIcon && element.isAnimation()) {
                ImageIcon imageIcon = (ImageIcon)element.getIcon();
                imageIcon.setImageObserver(new AnimationImageObserver(tree, treeNode));
            }
            this.setIcon(element.getIcon());
        } else {
            this.adaptIcon(treeNode, expanded);
        }
    }

    private void adaptIcon(DefaultMutableTreeNode treeNode, boolean expanded) {
        String iconName = null;
        iconName = treeNode.isRoot() ? this.treeTheme + "tree_root.png" : (treeNode.isLeaf() ? this.treeTheme + "tree_leaf.png" : (expanded ? this.treeTheme + "tree_open.png" : this.treeTheme + "tree_closed.png"));
        this.setIcon(IconFactory.getSwingIcon(iconName));
    }
}

