/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.memorybar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.NumberFormat;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class JMemoryProgressBar
extends JProgressBar {
    public static final int KILO = 1024;
    public static final String MEGA = "M";
    private UpdateTimer updateTimer;
    private MemoryMXBean memorybean;
    private NumberFormat numberFormat;
    private int delayTime = 2000;

    public JMemoryProgressBar() {
        this.initComponents();
    }

    private void initComponents() {
        this.updateTimer = new UpdateTimer();
        this.memorybean = ManagementFactory.getMemoryMXBean();
        this.numberFormat = NumberFormat.getInstance();
        this.setStringPainted(true);
        this.updateMemory();
    }

    private void updateMemory() {
        long usedMemory = this.memorybean.getHeapMemoryUsage().getUsed();
        long totalMemory = this.memorybean.getHeapMemoryUsage().getMax();
        int percent = (int)(usedMemory * 100L / totalMemory);
        this.setValue(percent);
        String usedMega = this.numberFormat.format(usedMemory / 1024L / 1024L) + MEGA;
        String totalMega = this.numberFormat.format(totalMemory / 1024L / 1024L) + MEGA;
        String message = usedMega + "/" + totalMega;
        this.setString(message);
        this.setToolTipText("Memory used " + this.numberFormat.format(usedMemory) + " of total " + this.numberFormat.format(totalMemory));
    }

    public void gc() {
        System.gc();
        this.updateMemory();
    }

    public boolean isRunning() {
        return this.updateTimer.isRunning();
    }

    public void start() {
        this.updateTimer.start();
    }

    public void start(int delayTime) {
        this.setDelayTime(delayTime);
        this.start();
    }

    public void stop() {
        this.updateTimer.stop();
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
        this.updateTimer.setDelay(delayTime);
    }

    public class UpdateTimer
    extends Timer
    implements ActionListener {
        public UpdateTimer() {
            super(JMemoryProgressBar.this.delayTime, null);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMemoryProgressBar.this.updateMemory();
        }
    }
}

