/*
 * Decompiled with CFR 0.152.
 */
package twaver.tree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import twaver.Element;
import twaver.Generator;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.base.A.D.I;
import twaver.base.A.E.O;
import twaver.tree.TTree;

public class TTreeCellIcon
implements Icon {
    protected TTree tree = null;
    protected Element element = null;
    protected boolean drawIconShape = TUIManager.getBoolean("draw.icon.shape");

    public TTreeCellIcon(Element element) {
        this.element = element;
    }

    public TTreeCellIcon(Element element, TTree tree) {
        this.element = element;
        this.tree = tree;
    }

    public Element getElement() {
        return this.element;
    }

    public void paintIcon(Component c2, Graphics g2, int x, int y) {
        Graphics2D g2d = (Graphics2D)g2;
        float alpha = this.element.getRenderAlpha();
        Composite oldComposite = null;
        if (alpha != 1.0f) {
            oldComposite = g2d.getComposite();
            AlphaComposite composite = AlphaComposite.getInstance(3, alpha);
            g2d.setComposite(composite);
        }
        this.paintContent(c2, g2d, x, y);
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
    }

    protected void paintContent(Component c2, Graphics2D g2d, int x, int y) {
        Color outlineColor;
        Icon icon = this.getElementIcon();
        if (icon == null) {
            return;
        }
        if (icon instanceof ImageIcon) {
            ImageIcon image = (ImageIcon)icon;
            g2d.drawImage(image.getImage(), x, y, this.getIconWidth(), this.getIconHeight(), null);
        } else {
            icon.paintIcon(c2, g2d, x, y);
        }
        if (this.tree != null && this.tree.isShowPlainIcon()) {
            return;
        }
        Generator generator = null;
        generator = this.tree == null ? TUIManager.getElementStateOutlineColorGenerator() : this.tree.getElementStateOutlineColorGenerator();
        Color color = outlineColor = generator == null ? null : (Color)generator.generate(this.element);
        if (outlineColor != null) {
            g2d.setColor(outlineColor);
            g2d.setStroke(TWaverConst.DOUBLE_WIDTH_STROKE);
            Object value = this.element.getClientProperty("draw.icon.shape");
            if (value != null) {
                this.drawIconShape = (Boolean)value;
            }
            if (this.drawIconShape && icon instanceof ImageIcon) {
                Shape imageShape = I.A(((ImageIcon)icon).getImage());
                if (imageShape != null) {
                    AffineTransform at = AffineTransform.getTranslateInstance(x, y);
                    imageShape = at.createTransformedShape(imageShape);
                    g2d.draw(imageShape);
                }
            } else {
                g2d.drawRect(x + 1, y + 1, this.getIconWidth() - 2, this.getIconHeight() - 2);
            }
        }
    }

    public int getIconWidth() {
        if (this.tree != null && this.tree.getIconWidth() > 0) {
            return this.tree.getIconWidth();
        }
        Icon icon = this.getElementIcon();
        if (icon != null) {
            return icon.getIconWidth();
        }
        return 0;
    }

    public int getIconHeight() {
        if (this.tree != null && this.tree.getIconHeight() > 0) {
            return this.tree.getIconHeight();
        }
        Icon icon = this.getElementIcon();
        if (icon != null) {
            return icon.getIconHeight();
        }
        return 0;
    }

    protected Icon getElementIcon() {
        Object value = this.element.getClientProperty("element.tree.icon");
        if (value instanceof Icon) {
            return (Icon)value;
        }
        Color color = null;
        if (this.tree == null || !this.tree.isShowPlainIcon()) {
            Generator generator = this.tree == null ? TUIManager.getElementBodyColorGenerator() : this.tree.getElementBodyColorGenerator();
            color = generator == null ? null : (Color)generator.generate(this.element);
        }
        return O.A(this.getElementIconURL(), color);
    }

    protected String getElementIconURL() {
        return this.element.getIconURL();
    }
}

