/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.ogc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import twaver.gis.GisManager;
import twaver.gis.gadget.GridBbox;
import twaver.gis.gadget.WMSLayerInfo;
import twaver.gis.utils.XMLUtils;

public class WMSUtils {
    private static final String A = "featureinfo";

    private static Node B(Node capabilitiesRoot) {
        return WMSUtils.E(capabilitiesRoot, "Service");
    }

    private static Node C(Node capabilitiesRoot) {
        return WMSUtils.E(capabilitiesRoot, "Capability");
    }

    private static Node A(Document doc) {
        if (doc == null) {
            return null;
        }
        return WMSUtils.E(doc, "WMT_MS_Capabilities");
    }

    private static Node B(Document doc) {
        if (doc == null) {
            return null;
        }
        return WMSUtils.E(doc, "WMS_Capabilities");
    }

    private static List C(Node parent, String name) {
        return XMLUtils.getChildren(parent, name);
    }

    private static Node E(Node parent, String sonTag) {
        return XMLUtils.getChild(parent, sonTag);
    }

    private static Node B(Node parent, String sonTag) {
        List result = WMSUtils.C(parent, sonTag);
        if (result != null) {
            return (Node)result.get(0);
        }
        return null;
    }

    private static String D(Node parent, String sonTag) {
        Node p = WMSUtils.B(parent, sonTag);
        if (p != null) {
            return p.getFirstChild().getNodeValue();
        }
        return null;
    }

    private static String F(Node parent, String sonTag) {
        return XMLUtils.getSonValue(parent, sonTag);
    }

    private static String G(Node node, String property) {
        return XMLUtils.getPropertyValue(node, property);
    }

    private static boolean A(Node parent, String tag) {
        List result = WMSUtils.C(parent, tag);
        return result != null;
    }

    private static final String A(String requestType, String version, String srs, String[] layers, String format, double[] bbox) {
        StringBuffer result = new StringBuffer();
        result.append(WMSUtils.E(requestType));
        result.append(WMSUtils.D(version));
        result.append(WMSUtils.A(format));
        result.append(WMSUtils.B(layers));
        result.append(WMSUtils.B(srs));
        result.append(WMSUtils.A(bbox));
        return result.toString();
    }

    private static final StringBuffer C(String parameterName) {
        StringBuffer result = new StringBuffer();
        result.append("&").append(parameterName).append("=");
        return result;
    }

    private static final String E(String requestType) {
        StringBuffer result = new StringBuffer();
        result.append("request").append("=");
        result.append(requestType);
        return result.toString();
    }

    private static final String D(String version) {
        StringBuffer result = WMSUtils.C("version");
        result.append(version);
        return result.toString();
    }

    private static final String B(String[] layers) {
        StringBuffer result = WMSUtils.C("layers");
        if (layers != null) {
            int lastIndex = layers.length - 1;
            int i = 0;
            while (i < layers.length) {
                result.append(layers[i]);
                if (i < lastIndex) {
                    result.append(",");
                }
                ++i;
            }
        }
        return result.toString();
    }

    private static final String A(String[] styles) {
        StringBuffer result = WMSUtils.C("styles");
        int lastIndex = styles.length - 1;
        int i = 0;
        while (i < styles.length) {
            if (styles[i] != null) {
                result.append(styles[i]);
                if (i < lastIndex) {
                    result.append(";");
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static final String A(String format) {
        StringBuffer result = WMSUtils.C("format");
        result.append("image/").append(format);
        return result.toString();
    }

    private static final String B(int width) {
        StringBuffer result = WMSUtils.C("width");
        result.append("" + width);
        return result.toString();
    }

    private static final String A(int height) {
        StringBuffer result = WMSUtils.C("height");
        result.append("" + height);
        return result.toString();
    }

    private static final String B(String srs) {
        StringBuffer result = WMSUtils.C("srs");
        if (!("EPSG:4326".equals(srs) || "EPSG:900913".equals(srs) || "EPSG:4230".equals(srs))) {
            srs = "EPSG:4326";
        }
        result.append(srs);
        return result.toString();
    }

    private static final String A(boolean transparent) {
        StringBuffer result = WMSUtils.C("transparent");
        if (transparent) {
            result.append("true");
        } else {
            result.append("false");
        }
        return result.toString();
    }

    private static final String A(GridBbox bbox) {
        StringBuffer result = WMSUtils.C("bbox");
        if (bbox != null) {
            result.append(bbox.getMinx()).append(",").append(bbox.getMiny()).append(",");
            result.append(bbox.getMaxx()).append(",").append(bbox.getMaxy());
        } else {
            result.append("-180,-90,180,90");
        }
        return result.toString();
    }

    private static final String A(double[] bbox) {
        StringBuffer result = WMSUtils.C("bbox");
        if (bbox != null && bbox.length == 4) {
            int i = 0;
            while (i < 4) {
                result.append(bbox[i]);
                if (i < 3) {
                    result.append(",");
                }
                ++i;
            }
        } else {
            result.append("-180,-90,180,90");
        }
        return result.toString();
    }

    public static final String getURL(String requestType, String version, String srs, String[] layers, String format, GridBbox bbox) {
        return WMSUtils.getURL(requestType, version, srs, layers, null, format, bbox, 256, 256);
    }

    public static final String getURL(String requestType, String version, String srs, String[] layers, String[] styles, String format, GridBbox bbox, int width, int height) {
        StringBuffer result = new StringBuffer();
        result.append(WMSUtils.E(requestType));
        result.append(WMSUtils.D(version));
        result.append(WMSUtils.A(format));
        result.append(WMSUtils.B(layers));
        if (styles != null) {
            result.append(WMSUtils.A(styles));
        } else {
            result.append("&styles=");
        }
        result.append(WMSUtils.B(srs));
        result.append(WMSUtils.A(bbox));
        result.append(WMSUtils.B(width));
        result.append(WMSUtils.A(height));
        result.append(WMSUtils.A(true));
        return result.toString();
    }

    public static List getFeatureInfo(String urlString) {
        try {
            String line;
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            InputStream is = connection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml   version=\"1.0\"  encoding=\"UTF-8\"?>");
            sb.append("<").append(A).append(">");
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            sb.append("</").append(A).append(">");
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes());
            Document doc = db.parse(bis);
            bis.close();
            Node featureinfo = WMSUtils.E(doc, A);
            Node html = WMSUtils.E(featureinfo, "html");
            Node body = WMSUtils.E(html, "body");
            List tables = WMSUtils.C(body, "table");
            int length = tables.size();
            int i = 0;
            while (i < length) {
                Node table = (Node)tables.get(i);
                List trs = WMSUtils.C(table, "tr");
                int trsNum = trs.size();
                boolean findTh = false;
                int t = 0;
                while (t < trsNum) {
                    Node tr = (Node)trs.get(i);
                    if (!findTh && WMSUtils.A(tr, "th")) {
                        findTh = true;
                    }
                    ++t;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static List A(String urlString, String charset) {
        ArrayList<WMSLayerInfo> result = null;
        if (urlString != null) {
            List layers;
            block6: {
                URL url = new URL(urlString);
                String contents = XMLUtils.getRequestResult(url, charset);
                Document doc = XMLUtils.createDocument(contents, charset);
                Node root = WMSUtils.B(doc);
                Node serviceNode = WMSUtils.B(root);
                Node capabilites = WMSUtils.C(root);
                Node abstractLayer = WMSUtils.E(capabilites, "Layer");
                layers = WMSUtils.C(abstractLayer, "Layer");
                if (layers != null) break block6;
                return null;
            }
            try {
                result = new ArrayList<WMSLayerInfo>();
                int length = layers.size();
                int i = 0;
                while (i < length) {
                    Node layer = (Node)layers.get(i);
                    String layerName = WMSUtils.F(layer, "Name");
                    List crsNodes = WMSUtils.C(layer, "CRS");
                    List boundingBoxList = WMSUtils.C(layer, "BoundingBox");
                    Object bn = null;
                    int crsCount = crsNodes.size();
                    String[] crses = new String[crsCount];
                    Node exGeographicBoundingBox = XMLUtils.getChild(layer, "EX_GeographicBoundingBox");
                    String minLongitude = WMSUtils.F(exGeographicBoundingBox, "westBoundLongitude");
                    String maxLongitude = WMSUtils.F(exGeographicBoundingBox, "eastBoundLongitude");
                    String minLatitude = WMSUtils.F(exGeographicBoundingBox, "southBoundLatitude");
                    String maxLatitude = WMSUtils.F(exGeographicBoundingBox, "northBoundLatitude");
                    int bc = 0;
                    while (bc < crsCount) {
                        crses[bc] = XMLUtils.getNodeValue((Node)crsNodes.get(bc));
                        ++bc;
                    }
                    Node style = WMSUtils.E(layer, "Style");
                    String styleName = WMSUtils.F(style, "Name");
                    WMSLayerInfo layerInfo = new WMSLayerInfo();
                    layerInfo.setLayerName(layerName);
                    layerInfo.setSrsArray(crses);
                    layerInfo.setStyleName(styleName);
                    layerInfo.setBoundingBox(new GridBbox(Double.parseDouble(minLongitude), Double.parseDouble(minLatitude), Double.parseDouble(maxLongitude), Double.parseDouble(maxLatitude)));
                    result.add(layerInfo);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List B(String urlString, String charset) {
        ArrayList<WMSLayerInfo> result = null;
        if (urlString == null) return result;
        try {
            List fouthLayers;
            URL url = new URL(urlString);
            String contents = XMLUtils.getRequestResult(url, charset);
            Document doc = XMLUtils.createDocument(contents, charset);
            Node root = WMSUtils.A(doc);
            Node capabilites = WMSUtils.C(root);
            Node topLayer = WMSUtils.E(capabilites, "Layer");
            Node secondLayer = WMSUtils.E(topLayer, "Layer");
            List srsList = WMSUtils.C(secondLayer, "SRS");
            if (srsList == null) return result;
            int size = srsList.size();
            String[] srs = new String[size];
            Iterator iterator = srsList.iterator();
            int index = 0;
            while (true) {
                if (!iterator.hasNext()) {
                    Node thirdLayer = WMSUtils.E(secondLayer, "Layer");
                    fouthLayers = WMSUtils.C(thirdLayer, "Layer");
                    if (fouthLayers != null) break;
                    return null;
                }
                Node srsNode = (Node)iterator.next();
                srs[index++] = XMLUtils.getNodeValue(srsNode);
            }
            result = new ArrayList<WMSLayerInfo>();
            Iterator fouthIterator = fouthLayers.iterator();
            block3: while (true) {
                if (!fouthIterator.hasNext()) {
                    return result;
                }
                Node fourthLayer = (Node)fouthIterator.next();
                List layers = WMSUtils.C(fourthLayer, "Layer");
                if (layers == null) {
                    return null;
                }
                int length = layers.size();
                int i = 0;
                while (true) {
                    if (i >= length) continue block3;
                    Node layer = (Node)layers.get(i);
                    String layerName = WMSUtils.F(layer, "Name");
                    Node bbox = WMSUtils.E(layer, "LatLonBoundingBox");
                    WMSLayerInfo layerInfo = new WMSLayerInfo();
                    if (srs != null) {
                        layerInfo.setSrsArray(srs);
                    }
                    layerInfo.setLayerName(layerName);
                    layerInfo.setLatlonBox(WMSUtils.A(bbox));
                    result.add(layerInfo);
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List getGeoWMSAbilities(String urlString) {
        return WMSUtils.getGeoWMSAbilities(urlString, "UTF-8");
    }

    public static List getGeoWMSAbilities(String urlString, String charset) {
        ArrayList<WMSLayerInfo> result = null;
        if (urlString != null) {
            List layers;
            block10: {
                URL url = new URL(urlString);
                String contents = XMLUtils.getRequestResult(url, charset);
                Document doc = XMLUtils.createDocument(contents, charset);
                Node root = WMSUtils.A(doc);
                Node capabilites = WMSUtils.C(root);
                Node abstractLayer = WMSUtils.E(capabilites, "Layer");
                layers = WMSUtils.C(abstractLayer, "Layer");
                if (layers != null) break block10;
                return null;
            }
            try {
                result = new ArrayList<WMSLayerInfo>();
                int length = layers.size();
                int i = 0;
                while (i < length) {
                    Node layer = (Node)layers.get(i);
                    String layerName = WMSUtils.F(layer, "Name");
                    String[] ss = null;
                    List srses = XMLUtils.getChildren(layer, "SRS");
                    if (srses != null) {
                        Iterator iterator = srses.iterator();
                        ss = new String[srses.size()];
                        int index = 0;
                        while (iterator.hasNext()) {
                            ss[index] = XMLUtils.getNodeValue((Node)iterator.next());
                            ++index;
                        }
                    }
                    Node latlonBox = WMSUtils.E(layer, "LatLonBoundingBox");
                    Node bbox = WMSUtils.E(layer, "BoundingBox");
                    Node style = WMSUtils.E(layer, "Style");
                    String styleName = WMSUtils.F(style, "Name");
                    WMSLayerInfo layerInfo = new WMSLayerInfo();
                    layerInfo.setLayerName(layerName);
                    layerInfo.setStyleName(styleName);
                    if (bbox != null) {
                        layerInfo.setSrs(WMSUtils.G(bbox, "SRS"));
                        layerInfo.setBoundingBox(WMSUtils.A(bbox));
                    }
                    if (ss != null && ss.length > 0) {
                        layerInfo.setSrsArray(ss);
                    }
                    if (latlonBox != null) {
                        layerInfo.setLatlonBox(WMSUtils.A(latlonBox));
                    }
                    result.add(layerInfo);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static GridBbox A(Node node) {
        GridBbox box = new GridBbox();
        box.setMinx(Double.parseDouble(WMSUtils.G(node, "minx")));
        box.setMiny(Double.parseDouble(WMSUtils.G(node, "miny")));
        box.setMaxx(Double.parseDouble(WMSUtils.G(node, "maxx")));
        box.setMaxy(Double.parseDouble(WMSUtils.G(node, "maxy")));
        return box;
    }

    public static WMSLayerInfo getLayerInfo(String layerName, String server, int type) {
        String abilityServer = server;
        List infos = WMSUtils.getWMSAbilities(type, abilityServer);
        if (infos == null && 1 == type) {
            abilityServer = GisManager.getDefaultSetting("GeoServer.Tile").toString();
            infos = WMSUtils.getWMSAbilities(type, abilityServer);
        }
        WMSLayerInfo layerInfo = null;
        if (infos != null) {
            Iterator iterator = infos.iterator();
            while (iterator.hasNext()) {
                layerInfo = (WMSLayerInfo)iterator.next();
                if (layerInfo.getLayerName().equals(layerName)) break;
            }
        }
        return layerInfo;
    }

    public static List getWMSAbilities(int type, String server) {
        return WMSUtils.getWMSAbilities(type, server, "UTF-8");
    }

    public static List getWMSAbilities(int type, String server, String charset) {
        String url = String.valueOf(server) + "request=GetCapabilities";
        if (4 == (type %= 30)) {
            return WMSUtils.A(url, charset);
        }
        if (1 == type || type == 0 || 30 == type) {
            return WMSUtils.getGeoWMSAbilities(url, charset);
        }
        if (3 == type) {
            return WMSUtils.B(url, charset);
        }
        return null;
    }
}

