/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.H.I;
import twaver.web.svg.chart.AbstractSVGScaleChart;
import twaver.web.svg.network.SVGContext;

public class SVGLineChart
extends AbstractSVGScaleChart {
    private boolean \u0135 = TUIManager.getBoolean("tchart.interrupted.when.null.value");
    private boolean \u0132 = TUIManager.getBoolean("tchart.xscale.line.visible");
    private boolean \u0131 = TUIManager.getBoolean("tchart.inflexion.visible");
    private Color \u0133 = TUIManager.getColor("tchart.xscale.line.color");
    private String \u0130 = TUIManager.getString("tchart.xscale.line.stroke");
    private int \u0137 = TUIManager.getInt("tchart.inflexion.style");
    private int \u0136 = TUIManager.getInt("tchart.line.type");
    private double \u0134 = 0.0;
    private double \u0138 = 0.0;

    public SVGLineChart() {
        this(new TDataBox());
    }

    public SVGLineChart(TDataBox box) {
        super(box, null, null);
        this.init();
    }

    public SVGLineChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
        this.init();
    }

    public SVGLineChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
        this.init();
    }

    protected void init() {
        this.valueTextVisible = false;
        this.shadowOffset = 0;
    }

    public void setXScaleLineVisible(boolean scaleLineVisible) {
        this.\u0132 = scaleLineVisible;
    }

    public boolean isInflexionVisible() {
        return this.\u0131;
    }

    public void setInflexionVisible(boolean inflexionVisible) {
        this.\u0131 = inflexionVisible;
    }

    protected void calculate() {
        this.calculateValuesProportionsOfRange(true, -1);
    }

    public String getXScaleLineStroke() {
        return this.\u0130;
    }

    public void setXScaleLineStroke(String xScaleLineStroke) {
        this.\u0130 = xScaleLineStroke;
    }

    public Color getXScaleLineColor() {
        return this.\u0133;
    }

    public void setXScaleLineColor(Color scaleLineColor) {
        this.\u0133 = scaleLineColor;
    }

    public int getLineType() {
        return this.\u0136;
    }

    public void setLineType(int lineType) {
        this.\u0136 = lineType;
    }

    public int getInflexionStyle(Element element) {
        Object value = element.getClientProperty("chart.inflexion.style");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return this.\u0137;
    }

    protected Rectangle getInflexionBounds(Element element, Point point) {
        Stroke stroke = this.getStroke(element);
        int w = 2;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 1;
        }
        Rectangle bounds = new Rectangle(point.x - w, point.y - w, w * 2 + 1, w * 2 + 1);
        if (this.getInflexionStyle(element) == 2) {
            if (bounds.width % 2 == 1) {
                ++bounds.width;
            }
            if (bounds.height % 2 == 1) {
                ++bounds.height;
            }
        }
        return bounds;
    }

    public boolean isInterruptedWhenNullValue() {
        return this.\u0135;
    }

    public void setInterruptedWhenNullValue(boolean interruptedWhenNullValue) {
        this.\u0135 = interruptedWhenNullValue;
    }

    public int getXScaleTextSpanCount() {
        return this.xScaleTextSpanCount;
    }

    public void setXScaleTextSpanCount(int scaleTextSpanCount) {
        this.xScaleTextSpanCount = scaleTextSpanCount;
    }

    protected int getXAxisExtraGap() {
        int gap = 0;
        if (this.xScaleTextVisible && this.xScaleTextList != null) {
            int count = this.xScaleTextList.size();
            for (int i2 = 0; i2 < count; ++i2) {
                String text = this.getXScaleText(i2);
                int h2 = this.A((int)this.xScaleTextOrientation, (String)text, (Font)this.xScaleTextFont).height;
                if (h2 <= gap) continue;
                gap = h2;
            }
        }
        if (gap > 0) {
            gap += this.textGap;
        }
        return gap;
    }

    protected void paintContent(SVGContext context, StringBuffer result, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, int baseLine, double pixelGap, double valueGap) {
        this.\u0134 = 0.0;
        this.\u0138 = 0.0;
        if (this.publishedElements.size() > 0 && this.proportions != null) {
            Element element = (Element)this.publishedElements.get(0);
            List list = (List)this.proportions.get(element);
            if (list == null) {
                return;
            }
            int count = list.size();
            if (this.endIndex < count) {
                count = this.endIndex;
            }
            if (this.startIndex != 0) {
                count -= this.startIndex;
            }
            if ((count = (count - 1) / this.valueSpanCount + 1) <= 0) {
                return;
            }
            double zeroLine = (double)baseLine + this.min / valueGap * pixelGap;
            double pillarWidth = (double)xAxisWidth / (double)count;
            if (pillarWidth == 0.0) {
                pillarWidth = 0.1;
            }
            this.\u0134 = (double)(this.xGap + this.shadowOffset + yAxisTextGap) + pillarWidth / 2.0;
            int end = list.size();
            if (this.endIndex < end) {
                end = this.endIndex;
            }
            for (int i2 = 0; i2 < this.publishedElements.size(); ++i2) {
                int j2;
                element = (Element)this.publishedElements.get(i2);
                double x = this.\u0134;
                ArrayList<Point> points = new ArrayList<Point>();
                ArrayList<String> values = new ArrayList<String>();
                list = (List)this.proportions.get(element);
                Point lastPoint = null;
                Stroke stroke = this.getStroke(element);
                for (j2 = this.startIndex; j2 < end; j2 += this.valueSpanCount) {
                    Double proportion;
                    boolean drawXScale = true;
                    if (this.xScaleTextSpanCount > 0 && (j2 - this.startIndex) % this.xScaleTextSpanCount != 0) {
                        drawXScale = false;
                    }
                    if (drawXScale) {
                        if (i2 == 0 && this.\u0132) {
                            I.A(context, result, (int)x, this.yGap, (int)x, height - this.yGap - xAxisTextGap - this.shadowOffset, TUIManager.getStrokeByType(this.\u0130), this.\u0133);
                        }
                        if (i2 == 0 && this.xScaleTextVisible) {
                            I.A(context, result, this.getXScaleText(j2), this.xScaleTextColor, this.xScaleTextFont, (int)x, height - this.yGap - xAxisTextGap, this.xScaleTextOrientation, 3);
                        }
                    }
                    if ((proportion = (Double)list.get(j2)) != null) {
                        Color color;
                        double y = (double)baseLine - proportion * this.toValidHeight(yAxisHeight);
                        Point currentPoint = new Point((int)x, (int)y);
                        Shape segment = null;
                        if (this.\u0136 == 3) {
                            Line2D.Double line = new Line2D.Double(currentPoint.x, currentPoint.y, currentPoint.x, zeroLine);
                            segment = stroke.createStrokedShape(line);
                            color = this.getColor(element);
                            I.A(context, result, segment, (Object)color, null, (Object)stroke, 1.0f, 0.0, null);
                        } else if (lastPoint != null) {
                            Line2D.Double line = new Line2D.Double(lastPoint, currentPoint);
                            segment = stroke.createStrokedShape(line);
                            color = this.getColor(element);
                            I.A(context, result, segment, color);
                            if (this.\u0136 == 2) {
                                Color areaColor = this.getAreaColor(element);
                                GeneralPath path = new GeneralPath();
                                path.moveTo(lastPoint.x, (int)zeroLine);
                                path.lineTo(lastPoint.x, lastPoint.y);
                                path.lineTo(currentPoint.x, currentPoint.y);
                                path.lineTo(currentPoint.x, (int)zeroLine);
                                path.closePath();
                                I.A(context, result, path, areaColor);
                            }
                        }
                        points.add(currentPoint);
                        double value = (Double)this.getValues(element).get(j2);
                        if (this.valueTextVisible) {
                            values.add(this.getFormatedText(element, value));
                        }
                        lastPoint = currentPoint;
                    } else if (this.\u0135) {
                        lastPoint = null;
                    }
                    x += pillarWidth;
                }
                this.\u0138 = x - pillarWidth;
                count = points.size();
                for (j2 = 0; j2 < count; ++j2) {
                    Point point = (Point)points.get(j2);
                    if (this.\u0131) {
                        this.paintInflexion(context, result, element, point);
                    }
                    if (!this.valueTextVisible) continue;
                    String text = (String)values.get(j2);
                    result.append(I.A(context, text, this.valueTextColor, this.valueTextFont, new Point(point.x + this.textGap + 1, point.y), false, null));
                }
            }
        }
    }

    public Color getAreaColor(Element element) {
        Color color = this.getColor(element);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    protected void paintInflexion(SVGContext context, StringBuffer result, Element element, Point point) {
        int inflexionStyle = this.getInflexionStyle(element);
        Rectangle bounds = this.getInflexionBounds(element, point);
        Shape shape = null;
        if (inflexionStyle == 1) {
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            shape = new Ellipse2D.Float(x, y, width, height);
        } else if (inflexionStyle == 2) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height / 2);
            path.lineTo(bounds.x + bounds.width / 2, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height / 2);
            path.closePath();
            shape = path;
        } else if (inflexionStyle == 3) {
            shape = bounds;
        } else if (inflexionStyle == 4) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
            path.closePath();
            shape = path;
        }
        if (shape != null) {
            Color color = this.getColor(element);
            I.A(context, result, shape, (Object)color, null, (Object)this.stroke, 1.0f, 0.0, null);
        }
    }

    public double getEndX() {
        return this.\u0138;
    }

    public void setEndX(double endX) {
        this.\u0138 = endX;
    }

    public double getStartX() {
        return this.\u0134;
    }

    public void setStartX(double startX) {
        this.\u0134 = startX;
    }

    public int getInflexionStyle() {
        return this.\u0137;
    }

    public void setInflexionStyle(int inflexionStyle) {
        this.\u0137 = inflexionStyle;
    }

    public boolean isXScaleLineVisible() {
        return this.\u0132;
    }
}

