/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.E.D;
import twaver.base.A.F.A.A;
import twaver.base.A.H.I;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.network.SVGContext;

public class SVGDialChart
extends AbstractSVGChart {
    private boolean \u016a = TUIManager.getBoolean("tchart.dial.scale.inside");
    private int \u014e = TUIManager.getInt("tchart.dial.scale.major.count");
    private int \u016c = TUIManager.getInt("tchart.dial.scale.minor.count");
    private boolean \u015e = TUIManager.getBoolean("tchart.dial.scale.minor.visible");
    private double \u0168 = TUIManager.getDouble("tchart.dial.scale.length");
    private String \u016e = TUIManager.getString("tchart.dial.scale.stroke");
    private Font \u0160 = TUIManager.getFont("tchart.dial.scale.text.font");
    private Color \u0159 = TUIManager.getColor("tchart.dial.scale.color");
    private boolean \u0152 = TUIManager.getBoolean("tchart.dial.scale.text.visible");
    private double \u0153 = TUIManager.getDouble("tchart.dial.start.angle");
    private double \u016f = TUIManager.getDouble("tchart.dial.end.angle");
    private double \u0158 = TUIManager.getDouble("tchart.dial.max.value");
    private double \u014c = TUIManager.getDouble("tchart.dial.min.value");
    private String \u015a = TUIManager.getString("tchart.dial.ring.stroke");
    private Color \u015f = TUIManager.getColor("tchart.dial.ring.color");
    private Color \u0157 = TUIManager.getColor("tchart.dial.ring.fill.color");
    private Color \u0162 = TUIManager.getColor("tchart.dial.ring.border.color");
    private Color \u0167 = TUIManager.getColor("tchart.dial.ball.color");
    private Color \u0155 = TUIManager.getColor("tchart.dial.ball.border.color");
    private double \u0151 = TUIManager.getDouble("tchart.dial.ball.size");
    private int \u0165 = TUIManager.getInt("tchart.dial.scale.style");
    private boolean \u014f = TUIManager.getBoolean("tchart.dial.ring.border.visible");
    private boolean \u016b = TUIManager.getBoolean("tchart.dial.ring.gradient");
    private boolean \u015c = TUIManager.getBoolean("tchart.dial.ball.gradient");
    private int \u014d = TUIManager.getInt("tchart.dial.ring.gradient.factory");
    private int \u0164 = TUIManager.getInt("tchart.dial.ball.gradient.factory");
    private Color \u0163 = TUIManager.getColor("tchart.dial.ring.gradient.color");
    private Color \u0169 = TUIManager.getColor("tchart.dial.ball.gradient.color");
    private boolean \u0173 = TUIManager.getBoolean("tchart.dial.scale.mintext.visible");
    private Color \u016d = TUIManager.getColor("tchart.dial.scale.text.color");
    private int \u015d = TUIManager.getInt("tchart.dial.type");
    private double \u0171 = TUIManager.getDouble("tchart.dial.arcrange");
    private double \u0150 = TUIManager.getDouble("tchart.dial.ball.percent.size");
    private Rectangle \u0156;
    private double \u0166;
    private double \u015b;
    private List \u0172 = new ArrayList();
    private double \u0154 = Math.PI / 180;
    private double \u0170 = 0.08;
    private double \u0161 = 0.08;

    public SVGDialChart() {
    }

    public SVGDialChart(TDataBox box) {
        super(box);
    }

    public SVGDialChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor);
    }

    public SVGDialChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    protected void calculate() {
        this.\u0166 = this.\u0158 - this.\u014c;
        this.\u015b = this.\u016f - this.\u0153;
        if (this.\u015d == 2) {
            this.\u015b = this.\u0171;
            this.\u0153 = 90.0 + (360.0 - this.\u0171) / 2.0;
        }
    }

    public StringBuffer toSVGContent(SVGContext context, int width, int height) {
        StringBuffer result = new StringBuffer();
        this.paintChart(context, result, width, height);
        return result;
    }

    public void paintChart(SVGContext context, StringBuffer result, int width, int height) {
        this.backgroundBounds.x = this.xGap;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = width - 2 * this.xGap;
        this.backgroundBounds.height = height - 2 * this.yGap;
        this.paintBackground(context, result);
        if (this.\u015d == 2) {
            this.E(context, result, width, height);
        } else {
            this.F(context, result, width, height);
        }
        this.F(context, result);
        this.G(context, result);
        this.E(context, result);
    }

    private void E(SVGContext context, StringBuffer result, int width, int height) {
        double r;
        double widthMaxR;
        Dimension dim = this.A(this.\u0158 + "", this.\u0160);
        double centerX = width / 2;
        double centerY = 0.0;
        if (this.\u0171 > 180.0) {
            widthMaxR = ((double)(width - 2 * this.xGap - 2 * dim.width) - 2.0 * this.\u0168) / 2.0;
            double heightMaxRr = ((double)(height - 2 * this.yGap - 2 * dim.height) - 2.0 * this.\u0168) / (1.0 + Math.cos((360.0 - this.\u0171) / 2.0 * this.\u0154));
            if (this.\u016a) {
                widthMaxR = (width - 2 * this.xGap) / 2;
                double ballActualSize = this.\u0151;
                if (this.\u0150 > 0.0) {
                    ballActualSize = (double)height * this.\u0150;
                }
                heightMaxRr = ((double)(height - 2 * this.yGap) - ballActualSize) / (1.0 + Math.cos((360.0 - this.\u0171) / 2.0 * this.\u0154));
            }
            boolean isUseW = widthMaxR > heightMaxRr;
            double d2 = r = isUseW ? heightMaxRr : widthMaxR;
            if (isUseW) {
                centerY = (double)(this.yGap + dim.height) + r + this.\u0168;
                if (this.\u016a) {
                    centerY = (double)this.yGap + r;
                }
            } else {
                centerY = (double)(height / 2) + (r - r * Math.cos((360.0 - this.\u0171) / 2.0 * this.\u0154)) / 2.0;
            }
        } else {
            widthMaxR = ((double)(width - 2 * this.xGap - 2 * dim.width) - 2.0 * this.\u0168) / 2.0;
            double ballActualSize = this.\u0151;
            if (this.\u0150 > 0.0) {
                ballActualSize = (double)height * this.\u0150;
            }
            double heightMaxRr = (double)(height - 2 * this.yGap - dim.height) - this.\u0168 - ballActualSize;
            if (this.\u016a) {
                widthMaxR = (width - 2 * this.xGap) / 2;
                heightMaxRr = (double)(height - 2 * this.yGap) - ballActualSize;
            }
            boolean isUseW = widthMaxR > heightMaxRr;
            r = isUseW ? heightMaxRr : widthMaxR;
            centerY = isUseW ? (double)(height - this.yGap - dim.height / 2) - (double)height / 2.0 * this.\u0150 : (double)(height / 2) + r / 2.0;
        }
        this.\u0156 = new Rectangle((int)(centerX - r), (int)(centerY - r), (int)(2.0 * r), (int)(2.0 * r));
        Arc2D.Double arc = new Arc2D.Double(this.\u0156, -(90.0 + (360.0 - this.\u0171) / 2.0), -this.\u0171, 2);
        Object fillObject = this.\u0157;
        if (this.\u016b) {
            fillObject = this.getGradientID(context, this.\u014d, this.\u0163, this.\u0157);
        }
        I.A(context, result, arc, fillObject);
        if (this.\u014f) {
            double subR = r - r / 2.0 * this.\u0170;
            Rectangle2D.Double rectangle = new Rectangle2D.Double(this.\u0156.getCenterX() - subR, this.\u0156.getCenterY() - subR, 2.0 * subR, 2.0 * subR);
            Arc2D.Double subArc = new Arc2D.Double(rectangle, -(90.0 + (360.0 - this.\u0171) / 2.0), -this.\u0171, 2);
            Area area = new Area(arc);
            area.subtract(new Area(subArc));
            I.A(context, result, area, this.\u0162);
        }
        if (this.\u0171 != 0.0 && this.\u0171 % 360.0 == 0.0) {
            Ellipse2D.Double ell = new Ellipse2D.Double((int)(centerX - r), (int)(centerY - r), (int)(2.0 * r), (int)(2.0 * r));
            I.A(context, result, ell, this.\u015f, TUIManager.getStrokeByType(this.\u015a));
        } else {
            I.A(context, result, arc, this.\u015f, TUIManager.getStrokeByType(this.\u015a));
        }
    }

    private void F(SVGContext context, StringBuffer result, int width, int height) {
        double widthLen = (double)(width - 2 * this.xGap) / 2.0;
        double heightLen = (double)(height - 2 * this.yGap) / 2.0;
        if (this.\u016a) {
            Rectangle widthR = D.A(this.xGap, (double)this.yGap + heightLen - widthLen, (double)this.xGap + widthLen * 2.0, (double)this.yGap + heightLen - widthLen + widthLen * 2.0);
            Rectangle heightR = D.A((double)this.xGap + widthLen - heightLen, this.yGap, (double)this.xGap + widthLen - heightLen + heightLen * 2.0, (double)this.yGap + heightLen * 2.0);
            this.\u0156 = widthLen < heightLen ? widthR : heightR;
        } else {
            Dimension dim = this.A(this.\u0158 + "", this.\u0160);
            double widthR = widthLen - this.\u0168 - dim.getWidth();
            double heightR = heightLen - this.\u0168 - dim.getHeight();
            double r = heightLen > widthLen ? widthR : heightR;
            this.\u0156 = D.A((double)this.xGap + widthLen - r, (double)this.yGap + heightLen - r, (double)this.xGap + widthLen + r, (double)this.yGap + heightLen + r);
        }
        Ellipse2D.Double ellip = new Ellipse2D.Double(this.\u0156.getX(), this.\u0156.getY(), this.\u0156.getWidth(), this.\u0156.getHeight());
        Object fillObject = this.\u0157;
        if (this.\u016b) {
            fillObject = this.getGradientID(context, this.\u014d, this.\u0163, this.\u0157);
        }
        I.A(context, result, ellip, fillObject);
        if (this.\u014f) {
            double centerX = ellip.getCenterX();
            double centerY = ellip.getCenterY();
            double eWidth = ellip.getWidth() - this.\u0156.getWidth() / 2.0 * this.\u0170;
            double eHeight = ellip.getHeight() - this.\u0156.getWidth() / 2.0 * this.\u0170;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - eWidth / 2.0, centerY - eHeight / 2.0, eWidth, eHeight);
            Arc2D.Double pie = new Arc2D.Double(this.\u0156.getX(), this.\u0156.getY(), this.\u0156.getWidth(), this.\u0156.getHeight(), 0.0, 360.0, 2);
            Area area = new Area(pie);
            area.subtract(new Area(ellipse));
            I.A(context, result, area, this.\u0162);
        }
        I.A(context, result, ellip, this.\u015f, TUIManager.getStrokeByType(this.\u015a));
    }

    private void G(SVGContext context, StringBuffer result) {
        double averageAngle = this.\u015b / (double)this.\u014e;
        double r = this.\u0156.getWidth() / 2.0;
        Point2D.Double point = new Point2D.Double(this.\u0156.getX() + this.\u0156.getWidth() / 2.0, this.\u0156.getY() + this.\u0156.getHeight() / 2.0);
        for (int i2 = 0; i2 <= this.\u014e; ++i2) {
            double angel = this.\u0153 + averageAngle * (double)i2;
            double endx = point.getX() + r * Math.cos(angel * this.\u0154);
            double endy = point.getY() + r * Math.sin(angel * this.\u0154);
            double startx = point.getX() + (this.\u016a ? r - this.\u0168 : r + this.\u0168) * Math.cos(angel * this.\u0154);
            double starty = point.getY() + (this.\u016a ? r - this.\u0168 : r + this.\u0168) * Math.sin(angel * this.\u0154);
            if (this.\u0165 == 1) {
                Line2D.Double li = new Line2D.Double(startx, starty, endx, endy);
                I.A(context, result, li, this.\u0159, TUIManager.getStrokeByType(this.\u016e));
            } else if (this.\u0165 == 2) {
                double ellx = (startx + endx) / 2.0 - this.\u0168 / 2.0;
                double elly = (starty + endy) / 2.0 - this.\u0168 / 2.0;
                Ellipse2D.Double ed = new Ellipse2D.Double(ellx, elly, this.\u0168, this.\u0168);
                I.A(context, result, ed, this.\u0159);
            }
            if (this.\u015e && i2 != this.\u014e) {
                int temp = this.\u016c + 1;
                for (int j2 = 0; j2 < this.\u016c; ++j2) {
                    double minangle = angel + averageAngle / (double)temp * (double)(j2 + 1);
                    double minEndx = point.getX() + r * Math.cos(minangle * this.\u0154);
                    double minEndy = point.getY() + r * Math.sin(minangle * this.\u0154);
                    double percent = 2.0;
                    if ((double)this.\u016c % 2.0 != 0.0 && j2 == this.\u016c / 2) {
                        percent = 1.5;
                    }
                    double minStartx = point.getX() + (this.\u016a ? r - this.\u0168 / percent : r + this.\u0168 / percent) * Math.cos(minangle * this.\u0154);
                    double minStarty = point.getY() + (this.\u016a ? r - this.\u0168 / percent : r + this.\u0168 / percent) * Math.sin(minangle * this.\u0154);
                    Shape shape = null;
                    if (this.\u0165 == 1) {
                        shape = new Line2D.Double(minStartx, minStarty, minEndx, minEndy);
                        I.A(context, result, shape, this.\u0159, TUIManager.getStrokeByType(this.\u016e));
                        continue;
                    }
                    if (this.\u0165 != 2) continue;
                    double ellx = (minStartx + minEndx) / 2.0 - this.\u0168 / (2.0 * percent);
                    double elly = (minStarty + minEndy) / 2.0 - this.\u0168 / (2.0 * percent);
                    shape = new Ellipse2D.Double(ellx, elly, this.\u0168 / percent, this.\u0168 / percent);
                    I.A(context, result, shape, this.\u0159);
                }
            }
            if (!this.\u0152 || i2 == 0 && !this.\u0173) continue;
            String text = this.getScaleValueText(i2, this.\u0166, this.\u014e);
            Dimension dim = this.A(text, this.\u0160);
            double scaleLen = this.\u0168 + dim.getWidth() / 2.0;
            double labelx = point.getX() + (this.\u016a ? r - scaleLen : r + scaleLen) * Math.cos(angel * this.\u0154);
            double labely = point.getY() + (this.\u016a ? r - scaleLen : r + scaleLen) * Math.sin(angel * this.\u0154);
            I.A(context, result, text, this.\u016d, this.\u0160, (int)labelx, (int)labely, 1);
        }
    }

    protected String getScaleValueText(int index, double valueRange, int scaleMajorCount) {
        String text = this.getFormat().format(this.\u014c + valueRange / (double)scaleMajorCount * (double)index);
        return text;
    }

    private void E(SVGContext context, StringBuffer result) {
        Element element;
        double pointx = this.\u0156.getX() + this.\u0156.getWidth() / 2.0;
        double pointy = this.\u0156.getY() + this.\u0156.getHeight() / 2.0;
        Point2D.Double point = new Point2D.Double(pointx, pointy);
        Iterator it = this.publishedElements.iterator();
        Element showInBall = null;
        boolean showBallFlag = false;
        while (it.hasNext()) {
            element = (Element)it.next();
            if (this.getValue(element) > this.\u0158 || this.getValue(element) < this.\u014c || element.isSelected()) continue;
            if (!showBallFlag) {
                showInBall = element;
                showBallFlag = true;
            }
            this.A(context, result, element, point);
        }
        showBallFlag = false;
        it = this.publishedElements.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (this.getValue(element) > this.\u0158 || this.getValue(element) < this.\u014c || !element.isSelected()) continue;
            if (!showBallFlag) {
                showInBall = element;
                showBallFlag = true;
            }
            this.A(context, result, element, point);
        }
        double actualBallSize = this.getActualBallSize();
        Ellipse2D.Double ball = new Ellipse2D.Double(point.getX() - actualBallSize, point.getY() - actualBallSize, actualBallSize * 2.0, actualBallSize * 2.0);
        Object fillObject = this.\u0167;
        if (this.\u015c) {
            fillObject = this.getGradientID(context, this.\u0164, this.\u0169, this.\u0167);
        }
        I.A(context, result, ball, fillObject);
        I.A(context, result, ball, this.\u0155, TUIManager.getStrokeByType("solid.2"));
        if (this.isValueTextCenter() && null != showInBall && this.valueTextVisible) {
            I.A(context, result, this.getFormatedText(showInBall, this.getValue(showInBall)), this.valueTextColor, this.valueTextFont, (int)point.getX(), (int)point.getY(), 1);
        }
    }

    private void A(SVGContext context, StringBuffer result, Element element, Point2D.Double point) {
        double angle = (this.getValue(element) - this.\u014c) / this.\u0166 * this.\u015b + this.\u0153;
        double r = this.\u0156.getWidth() / 2.0;
        Stroke elemenStroke = this.getStroke(element);
        Shape shape = null;
        double actualBallSize = this.getActualBallSize();
        double handLen = this.getHandLegth(element);
        Polygon polygon = new Polygon();
        int firstPointX = (int)(point.getX() + Math.cos(angle * this.\u0154) * handLen * r);
        int firstPointY = (int)(point.getY() + Math.sin(angle * this.\u0154) * handLen * r);
        polygon.addPoint(firstPointX, firstPointY);
        double te1 = 90.0 - angle;
        double center1x = actualBallSize / 1.2 * Math.cos(te1 * this.\u0154) + point.getX();
        double center1y = point.getY() - actualBallSize / 1.2 * Math.sin(te1 * this.\u0154);
        double center2x = point.getX() - actualBallSize / 1.2 * Math.cos(te1 * this.\u0154);
        double center2y = point.getY() + actualBallSize / 1.2 * Math.sin(te1 * this.\u0154);
        polygon.addPoint((int)center1x, (int)center1y);
        polygon.addPoint((int)center2x, (int)center2y);
        shape = polygon;
        double endPointX = point.getX() + Math.cos(angle * this.\u0154) * handLen * r;
        double endPointY = point.getY() + Math.sin(angle * this.\u0154) * handLen * r;
        Point2D.Double endPoint = new Point2D.Double(endPointX, endPointY);
        int handStyle = this.getHandStyle(element);
        if (handStyle == 1) {
            Line2D.Double li = new Line2D.Double(point.getX(), point.getY(), endPoint.x, endPoint.y);
            shape = elemenStroke.createStrokedShape(li);
        } else if (handStyle == 3) {
            double endx = point.getX() + Math.cos(angle * this.\u0154) * handLen * 0.94 * r;
            double endy = point.getY() + Math.sin(angle * this.\u0154) * handLen * 0.94 * r;
            Line2D.Double line = new Line2D.Double(point.getX(), point.getY(), endx, endy);
            shape = elemenStroke.createStrokedShape(line);
            double strokeW = 10.0;
            if (elemenStroke != null && elemenStroke instanceof BasicStroke) {
                strokeW = ((BasicStroke)elemenStroke).getLineWidth();
            }
            Polygon pol = new Polygon();
            pol.addPoint((int)endPoint.x, (int)endPoint.y);
            endx = point.getX() + Math.cos(angle * this.\u0154) * handLen * 0.918 * r;
            endy = point.getY() + Math.sin(angle * this.\u0154) * handLen * 0.918 * r;
            double temLen = r * 0.06 * Math.tan(0.5235987755982988);
            temLen = strokeW > temLen ? strokeW : temLen;
            double arrow1x = endx + temLen * Math.sin(angle * this.\u0154);
            double arrow1y = endy - temLen * Math.cos(angle * this.\u0154);
            double arrow2x = endx - temLen * Math.sin(angle * this.\u0154);
            double arrow2y = endy + temLen * Math.cos(angle * this.\u0154);
            pol.addPoint((int)arrow1x, (int)arrow1y);
            pol.addPoint((int)arrow2x, (int)arrow2y);
            Area ar = new Area(shape);
            ar.add(new Area(pol));
            shape = ar;
        }
        if (element.isSelected()) {
            I.A(context, result, shape, this.getSelectedColor(element), this.getSelectedStroke(element));
        }
        I.A(context, result, shape, this.getColor(element));
    }

    protected double getActualBallSize() {
        if (this.\u0150 > 0.0) {
            return this.\u0156.getWidth() / 2.0 * this.\u0150;
        }
        return this.\u0151;
    }

    private void F(SVGContext context, StringBuffer result) {
        if (this.\u0172 != null) {
            Collections.sort(this.\u0172, A.A());
            int size = this.\u0172.size();
            for (int i2 = 1; i2 < size; ++i2) {
                Marker markerst = (Marker)this.\u0172.get(i2 - 1);
                Marker markeren = (Marker)this.\u0172.get(i2);
                double start = (markerst.getValue() - this.\u014c) / this.\u0166 * this.\u015b + this.\u0153;
                if (markerst.getValue() > this.\u0158 || markeren.getValue() < this.\u014c) continue;
                if (markerst.getValue() < this.\u014c) {
                    start = this.\u0153;
                }
                double value = (markeren.getValue() - this.\u014c) / this.\u0166 * this.\u015b + this.\u0153 - start;
                if (markeren.getValue() > this.\u0158) {
                    value = this.\u0166 / this.\u0166 * this.\u015b + this.\u0153 - start;
                }
                double startValue = 360.0 - start - value;
                Arc2D.Double pie = new Arc2D.Double(this.\u0156.getX(), this.\u0156.getY(), this.\u0156.getWidth(), this.\u0156.getHeight(), startValue, value, 2);
                Area area = new Area(pie);
                double centerX = pie.getCenterX();
                double centerY = pie.getCenterY();
                double eWidth = pie.getWidth() - this.\u0156.getWidth() / 2.0 * this.\u0161;
                double eHeight = pie.getHeight() - this.\u0156.getWidth() / 2.0 * this.\u0161;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - eWidth / 2.0, centerY - eHeight / 2.0, eWidth, eHeight);
                area.subtract(new Area(ellipse));
                I.A(context, result, area, markerst.getColor());
            }
        }
    }

    public String getToolTipText(Element element) {
        return element.getName() + ":" + this.getFormat(element).format(this.getValue(element));
    }

    public double getHandLegth(Element element) {
        return element.getChartDialHandLength();
    }

    public int getHandStyle(Element element) {
        return element.getChartDialHandStyle();
    }

    public List getMarkers() {
        return this.\u0172;
    }

    public void setMarkers(List markers) {
        this.\u0172 = markers;
    }

    public boolean isScaleInside() {
        return this.\u016a;
    }

    public void setScaleInside(boolean scaleInside) {
        this.\u016a = scaleInside;
    }

    public double getStartAngle() {
        return this.\u0153;
    }

    public void setStartAngle(double startAngle) {
        this.\u0153 = startAngle;
        this.publishData();
    }

    public double getEndAngle() {
        return this.\u016f;
    }

    public void setEndAngle(double endAngle) {
        this.\u016f = endAngle;
        this.publishData();
    }

    public double getMaxValue() {
        return this.\u0158;
    }

    public void setMaxValue(double maxValue) {
        this.\u0158 = maxValue;
        this.publishData();
    }

    public double getMinValue() {
        return this.\u014c;
    }

    public void setMinValue(double minValue) {
        this.\u014c = minValue;
        this.publishData();
    }

    public double getScaleLength() {
        return this.\u0168;
    }

    public void setScaleLength(double scaleLength) {
        this.\u0168 = scaleLength;
    }

    public String getRingStroke() {
        return this.\u015a;
    }

    public void setRingStroke(String ringStroke) {
        this.\u015a = ringStroke;
    }

    public Color getRingColor() {
        return this.\u015f;
    }

    public void setRingColor(Color ringColor) {
        this.\u015f = ringColor;
    }

    public String getScaleStroke() {
        return this.\u016e;
    }

    public void setScaleStroke(String scaleStroke) {
        this.\u016e = scaleStroke;
    }

    public Color getScaleColor() {
        return this.\u0159;
    }

    public void setScaleColor(Color scaleColor) {
        this.\u0159 = scaleColor;
    }

    public Color getRingBorderColor() {
        return this.\u0162;
    }

    public void setRingBorderColor(Color ringBorderColor) {
        this.\u0162 = ringBorderColor;
    }

    public boolean isScaleTextVisible() {
        return this.\u0152;
    }

    public void setScaleTextVisible(boolean scaleTextVisible) {
        this.\u0152 = scaleTextVisible;
    }

    public int getScaleMajorCount() {
        return this.\u014e;
    }

    public void setScaleMajorCount(int scaleMajorCount) {
        this.\u014e = scaleMajorCount;
    }

    public boolean isScaleMinorVisible() {
        return this.\u015e;
    }

    public void setScaleMinorVisible(boolean scaleMinorVisible) {
        this.\u015e = scaleMinorVisible;
    }

    public Color getBallBorderColor() {
        return this.\u0155;
    }

    public void setBallBorderColor(Color ballBorderColor) {
        this.\u0155 = ballBorderColor;
    }

    public double getBallSize() {
        return this.\u0151;
    }

    public void setBallSize(double ballSize) {
        if (ballSize == 0.0) {
            ballSize = 1.0;
        }
        this.\u0151 = ballSize;
    }

    public int getScaleStyle() {
        return this.\u0165;
    }

    public void setScaleStyle(int scaleStyle) {
        this.\u0165 = scaleStyle;
    }

    public Color getBallColor() {
        return this.\u0167;
    }

    public void setBallColor(Color ballColor) {
        this.\u0167 = ballColor;
    }

    public int getScaleMinorCount() {
        return this.\u016c;
    }

    public void setScaleMinorCount(int scaleMinorNumber) {
        this.\u016c = scaleMinorNumber;
    }

    public boolean isRingBorderVisible() {
        return this.\u014f;
    }

    public void setRingBorderVisible(boolean ringBorderVisible) {
        this.\u014f = ringBorderVisible;
    }

    public Color getRingFillColor() {
        return this.\u0157;
    }

    public void setRingFillColor(Color fillColor) {
        this.\u0157 = fillColor;
    }

    public boolean isRingGradient() {
        return this.\u016b;
    }

    public void setRingGradient(boolean ringGradient) {
        this.\u016b = ringGradient;
    }

    public Color getBallGradientColor() {
        return this.\u0169;
    }

    public void setBallGradientColor(Color ballGradientColor) {
        this.\u0169 = ballGradientColor;
    }

    public boolean isBallGradient() {
        return this.\u015c;
    }

    public void setBallGradient(boolean ballGradient) {
        this.\u015c = ballGradient;
    }

    public int getRingGradientFactory() {
        return this.\u014d;
    }

    public void setRingGradientFactory(int ringGradientFactory) {
        this.\u014d = ringGradientFactory;
    }

    public int getBallGradientFactory() {
        return this.\u0164;
    }

    public void setBallGradientFactory(int ballGradientFactory) {
        this.\u0164 = ballGradientFactory;
    }

    public Color getRingGradientColor() {
        return this.\u0163;
    }

    public void setRingGradientColor(Color ringGradientColor) {
        this.\u0163 = ringGradientColor;
    }

    public boolean isScaleMinTextVisible() {
        return this.\u0173;
    }

    public void setScaleMinTextVisible(boolean scaleMinTextVisible) {
        this.\u0173 = scaleMinTextVisible;
    }

    public Rectangle getRingBound() {
        return this.\u0156;
    }

    public Color getScaleTextColor() {
        return this.\u016d;
    }

    public void setScaleTextColor(Color scaleTextColor) {
        this.\u016d = scaleTextColor;
    }

    public Font getScaleTextFont() {
        return this.\u0160;
    }

    public void setScaleTextFont(Font scaleTextFont) {
        this.\u0160 = scaleTextFont;
    }

    public void setArcRange(double arcRange) {
        double oldRange = this.\u0171;
        if (arcRange >= 360.0) {
            arcRange = 360.0;
        }
        if (arcRange <= 0.0) {
            arcRange = 0.0;
        }
        this.\u0171 = arcRange;
        if (oldRange != this.\u0171) {
            this.publishData();
        }
    }

    public double getArcRange() {
        return this.\u0171;
    }

    public int getDialType() {
        return this.\u015d;
    }

    public void setDialType(int dialType) {
        int old = this.\u015d;
        this.\u015d = dialType;
        if (old != this.\u015d) {
            this.publishData();
        }
    }

    public double getBallPercentSize() {
        return this.\u0150;
    }

    public void setBallPercentSize(double ballPercentSize) {
        this.\u0150 = ballPercentSize;
    }
}

