/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import y.base.Edge;
import y.base.ListCell;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.io.BadVersionException;
import y.layout.EdgeLayout;
import y.util.D;
import y.view.Arrow;
import y.view.Bend;
import y.view.BendCursor;
import y.view.BendList;
import y.view.EdgeLabel;
import y.view.Graph2D;
import y.view.LineType;
import y.view.NodeRealizer;
import y.view.Port;
import y.view.Util;

public abstract class EdgeRealizer
implements EdgeLayout {
    private static final int s = 1;
    private static final int k = 2;
    private boolean n;
    private int l;
    private Edge m;
    private Color f;
    private LineType x;
    private Arrow d;
    private Arrow t;
    private ArrayList w;
    private byte z;
    private boolean p;
    private Port o;
    private Port y;
    private float i;
    private float g;
    private float v;
    private float u;
    private static Color r = Color.orange;
    private static LineType h = LineType.LINE_5;
    private static Color q = Color.green;
    protected BendList bends;
    protected GeneralPath path;
    private final Ellipse2D.Double e = new Ellipse2D.Double(0.0, 0.0, 6.0, 6.0);
    Rectangle2D.Double j = null;

    public EdgeRealizer() {
        this.a();
        this.f = Color.black;
        this.x = LineType.LINE_1;
        this.t = this.d = Arrow.NONE;
        this.w = new ArrayList(1);
        this.setSourcePort(new Port());
        this.setTargetPort(new Port());
    }

    public EdgeRealizer(EdgeRealizer edgeRealizer) {
        this.a();
        this.f = edgeRealizer.getLineColor();
        this.x = edgeRealizer.getLineType();
        this.t = edgeRealizer.getArrow();
        this.d = edgeRealizer.getSourceArrow();
        int n = edgeRealizer.labelCount();
        this.w = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.addLabel((EdgeLabel)edgeRealizer.getLabel(n2).clone());
            ++n2;
        }
        BendCursor bendCursor = edgeRealizer.bends();
        while (bendCursor.ok()) {
            Bend bend = this.appendBend(bendCursor.bend().getX(), bendCursor.bend().getY());
            if (bend != null) {
                bend.setSelected(bendCursor.bend().isSelected());
            }
            bendCursor.next();
        }
        this.setSourcePort(edgeRealizer.getSourcePort().createCopy());
        this.setTargetPort(edgeRealizer.getTargetPort().createCopy());
        this.p = edgeRealizer.isSelected();
        this.n = true;
    }

    public EdgeRealizer createCopy() {
        return this.createCopy(this);
    }

    public abstract EdgeRealizer createCopy(EdgeRealizer var1);

    private void a() {
        this.l = 1;
        this.path = new GeneralPath(1, 2);
        this.bends = new BendList();
        this.n = true;
    }

    protected void bindEdge(Edge edge) {
        this.m = edge;
        this.setDirty();
    }

    public NodeRealizer getTargetRealizer() {
        return ((Graph2D)this.m.getGraph()).getRealizer(this.m.target());
    }

    public NodeRealizer getSourceRealizer() {
        return ((Graph2D)this.m.getGraph()).getRealizer(this.m.source());
    }

    public Edge getEdge() {
        return this.m;
    }

    Graph2D b() {
        if (this.m != null) {
            return (Graph2D)this.m.getGraph();
        }
        return null;
    }

    public void setPorts(Port port, Port port2) {
        this.setSourcePort(port);
        this.setTargetPort(port2);
    }

    public void setSourcePort(Port port) {
        port.a(this);
        this.o = port;
        this.setDirty();
    }

    public void setTargetPort(Port port) {
        port.a(this);
        this.y = port;
        this.setDirty();
    }

    public Port getSourcePort() {
        return this.o;
    }

    public Port getTargetPort() {
        return this.y;
    }

    public abstract Bend createBend(double var1, double var3, Bend var5, int var6);

    public abstract void reInsertBend(Bend var1, Bend var2, int var3);

    public abstract Bend insertBend(double var1, double var3);

    public abstract Bend removeBend(Bend var1);

    public void bendChanged(Bend bend, double d2, double d3) {
    }

    public Bend appendBend(double d2, double d3) {
        return this.createBend(d2, d3, this.lastBend(), 0);
    }

    public int bendPos(Bend bend) {
        return this.bends.indexOf(bend);
    }

    public int bendCount() {
        return this.bends.size();
    }

    public Bend getBend(int n) {
        return (Bend)this.bends.elementAt(n);
    }

    public BendCursor bends() {
        return this.bends.bends();
    }

    public Bend firstBend() {
        if (this.bends.size() == 0) {
            return null;
        }
        return (Bend)this.bends.first();
    }

    public Bend lastBend() {
        if (this.bends.size() == 0) {
            return null;
        }
        return (Bend)this.bends.last();
    }

    public int getMinBendCount() {
        return 0;
    }

    public void clearBends() {
        this.bends.clear();
        this.setDirty();
    }

    public YPoint getPoint(int n) {
        Bend bend = this.getBend(n);
        if (bend != null) {
            return new YPoint(bend.getX(), bend.getY());
        }
        return null;
    }

    public int pointCount() {
        return this.bendCount();
    }

    public YPoint getSourcePoint() {
        Port port = this.getSourcePort();
        return new YPoint(port.getOffsetX(), port.getOffsetY());
    }

    public YPoint getTargetPoint() {
        Port port = this.getTargetPort();
        return new YPoint(port.getOffsetX(), port.getOffsetY());
    }

    public void setSourcePoint(YPoint yPoint) {
        NodeRealizer nodeRealizer = this.getSourceRealizer();
        this.getSourcePort().setOffsets(yPoint.getX(), yPoint.getY());
    }

    public void setTargetPoint(YPoint yPoint) {
        NodeRealizer nodeRealizer = this.getTargetRealizer();
        this.getTargetPort().setOffsets(yPoint.getX(), yPoint.getY());
    }

    public void setPoint(int n, double d2, double d3) {
        Bend bend = this.getBend(n);
        if (bend != null) {
            bend.setLocation(d2, d3);
        }
    }

    public void addPoint(double d2, double d3) {
        this.appendBend(d2, d3);
    }

    public void clearPoints() {
        this.clearBends();
    }

    public void paintSloppy(Graphics2D graphics2D) {
        double d2;
        double d3;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            graphics2D.setColor(r);
        } else {
            object = this.getLineColor();
            if (object != null) {
                graphics2D.setColor((Color)object);
            } else {
                return;
            }
        }
        object = this.getSourceRealizer();
        double d4 = this.o.getX((NodeRealizer)object);
        double d5 = this.o.getY((NodeRealizer)object);
        ListCell listCell = this.bends.firstCell();
        while (listCell != null) {
            Bend bend = (Bend)listCell.getInfo();
            d3 = bend.getX();
            d2 = bend.getY();
            graphics2D.drawLine((int)d4, (int)d5, (int)d3, (int)d2);
            d4 = d3;
            d5 = d2;
            listCell = listCell.succ();
        }
        object = this.getTargetRealizer();
        d3 = this.y.getX((NodeRealizer)object);
        d2 = this.y.getY((NodeRealizer)object);
        graphics2D.drawLine((int)d4, (int)d5, (int)d3, (int)d2);
    }

    public void paint(Graphics2D graphics2D) {
        if ((this.l & 1) == 0) {
            return;
        }
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        if ((this.l & 2) == 0) {
            return;
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        if (this.isSelected()) {
            graphics2D.setColor(r);
            int n = (int)(this.x.getLineWidth() - h.getLineWidth());
            if (n >= 0) {
                graphics2D.setStroke(new BasicStroke(this.x.getLineWidth() + 4.0f, 2, 2));
            } else {
                graphics2D.setStroke(h);
            }
            graphics2D.draw(this.path);
        }
        if (this.f != null) {
            graphics2D.setColor(this.f);
            graphics2D.setStroke(this.x);
            graphics2D.draw(this.path);
            this.paintArrows(graphics2D);
        }
        this.paintLabels(graphics2D);
        this.paintPorts(graphics2D);
        if (this.isSelected()) {
            this.paintHighlightedBends(graphics2D);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    protected void paintHighlightedBends(Graphics2D graphics2D) {
        graphics2D.setStroke(LineType.LINE_1);
        if (this.bendCount() > 0) {
            BendCursor bendCursor = this.bends.bends();
            while (bendCursor.ok()) {
                Bend bend = bendCursor.bend();
                graphics2D.setColor(q);
                this.e.x = bend.getX() - 3.0;
                this.e.y = bend.getY() - 3.0;
                graphics2D.fill(this.e);
                graphics2D.setColor(Color.darkGray);
                graphics2D.draw(this.e);
                bendCursor.next();
            }
        }
    }

    protected void paintPorts(Graphics2D graphics2D) {
        this.o.paint(graphics2D, this.getSourceRealizer());
        this.y.paint(graphics2D, this.getTargetRealizer());
    }

    protected void paintArrows(Graphics2D graphics2D) {
        double d2;
        double d3;
        double d4;
        if (this.d == Arrow.NONE && this.t == Arrow.NONE) {
            return;
        }
        PathIterator pathIterator = this.path.getPathIterator(null);
        float[] fArray = Util.FLOAT6;
        pathIterator.currentSegment(fArray);
        pathIterator.next();
        float f2 = fArray[0];
        float f3 = fArray[1];
        pathIterator.currentSegment(fArray);
        pathIterator.next();
        double d5 = this.getLineType().getLineWidth();
        if (d5 != 1.0) {
            d5 = 1.0 + (d5 - 1.0) / 8.0;
        }
        AffineTransform affineTransform = Util.TRANSFORM;
        if (this.d != Arrow.NONE && (d4 = Math.sqrt((d3 = (double)(f2 - fArray[0])) * d3 + (d2 = (double)(f3 - fArray[1])) * d2)) > 0.0) {
            affineTransform.setTransform(d3 /= d4, d2 /= d4, -d2, d3, f2, f3);
            if (d5 != 1.0) {
                affineTransform.scale(d5, d5);
            }
            this.d.paint(graphics2D, affineTransform);
        }
        if (this.t != Arrow.NONE) {
            while (!pathIterator.isDone()) {
                f2 = fArray[0];
                f3 = fArray[1];
                pathIterator.currentSegment(fArray);
                pathIterator.next();
            }
            d3 = fArray[0] - f2;
            d2 = fArray[1] - f3;
            d4 = Math.sqrt(d3 * d3 + d2 * d2);
            if (d4 > 0.0) {
                affineTransform.setTransform(d3 /= d4, d2 /= d4, -d2, d3, fArray[0], fArray[1]);
                if (d5 != 1.0) {
                    affineTransform.scale(d5, d5);
                }
                this.t.paint(graphics2D, affineTransform);
            }
        }
    }

    protected void paintLabels(Graphics2D graphics2D) {
        int n = this.w.size() - 1;
        while (n >= 0) {
            EdgeLabel edgeLabel = this.getLabel(n);
            if (edgeLabel.isVisible() && edgeLabel.getText().length() != 0) {
                edgeLabel.paint(graphics2D);
            }
            --n;
        }
    }

    protected abstract void calculatePath();

    protected final void recalculateFeatures() {
        this.j = null;
        this.calculatePath();
        PathIterator pathIterator = this.path.getPathIterator(null);
        float[] fArray = Util.FLOAT6;
        pathIterator.currentSegment(fArray);
        this.i = fArray[0];
        this.g = fArray[1];
        pathIterator.next();
        this.l = pathIterator.isDone() ? (this.l &= 0xFFFFFFFD) : (this.l |= 2);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            pathIterator.next();
        }
        this.v = fArray[0];
        this.u = fArray[1];
        this.n = false;
    }

    public Point2D getSourceIntersection() {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        return new Point2D.Float(this.i, this.g);
    }

    public Point2D getTargetIntersection() {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        return new Point2D.Float(this.v, this.u);
    }

    public Color getLineColor() {
        return this.f;
    }

    public void setLineColor(Color color) {
        this.f = color;
    }

    public static void setSelectionColor(Color color) {
        r = color;
    }

    public static void setHighlightedBendColor(Color color) {
        q = color;
    }

    public static Color getHighlightedBendColor() {
        return q;
    }

    public static Color getSelectionColor() {
        return r;
    }

    public LineType getLineType() {
        return this.x;
    }

    public void setLineType(LineType lineType) {
        this.x = lineType;
    }

    public static void setSelectionStroke(LineType lineType) {
        h = lineType;
    }

    public static Stroke getSelectionStroke() {
        return h;
    }

    public Arrow getArrow() {
        return this.t;
    }

    public void setArrow(Arrow arrow) {
        this.t = arrow;
    }

    public Arrow getTargetArrow() {
        return this.t;
    }

    public void setTargetArrow(Arrow arrow) {
        this.t = arrow;
    }

    public Arrow getSourceArrow() {
        return this.d;
    }

    public void setSourceArrow(Arrow arrow) {
        this.d = arrow;
    }

    public void setLayer(byte by) {
        this.z = by;
    }

    public byte getLayer() {
        return this.z;
    }

    public void setVisible(boolean bl) {
        this.l = bl ? (this.l |= 1) : (this.l &= 0xFFFFFFFE);
    }

    public boolean isVisible() {
        return (this.l & 1) == 1;
    }

    public void setSelected(boolean bl) {
        if (bl != this.p) {
            this.p = bl;
            Graph2D graph2D = this.b();
            if (graph2D != null) {
                graph2D.fireGraph2DSelectionEvent(this.getEdge());
            }
        }
    }

    public boolean isSelected() {
        return this.p;
    }

    public void setDirty() {
        int n = this.w.size() - 1;
        while (n >= 0) {
            EdgeLabel edgeLabel = this.getLabel(n);
            edgeLabel.setOffsetDirty();
            --n;
        }
        this.n = true;
        this.j = null;
    }

    protected boolean isDirty() {
        return this.n;
    }

    public GeneralPath getPath() {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        return this.path;
    }

    public void addLabel(EdgeLabel edgeLabel) {
        edgeLabel.bindRealizer(this);
        this.w.add(edgeLabel);
    }

    public void removeLabel(EdgeLabel edgeLabel) {
        this.w.remove(edgeLabel);
        this.n = true;
    }

    public EdgeLabel getLabel() {
        if (this.labelCount() == 0) {
            this.addLabel(new EdgeLabel());
        }
        return this.getLabel(0);
    }

    public int labelCount() {
        return this.w.size();
    }

    public EdgeLabel getLabel(int n) {
        return (EdgeLabel)this.w.get(n);
    }

    public void setLabelText(String string) {
        this.getLabel().setText(string);
    }

    public String getLabelText() {
        return this.getLabel().getText();
    }

    public boolean contains(double d2, double d3) {
        return this.containsSeg(d2, d3) > 0;
    }

    public int containsSeg(double d2, double d3) {
        PathIterator pathIterator;
        float[] fArray = Util.FLOAT2;
        int n = 1;
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        if ((pathIterator = this.path.getPathIterator(null)).isDone()) {
            return 0;
        }
        pathIterator.currentSegment(fArray);
        pathIterator.next();
        float f2 = fArray[0];
        float f3 = fArray[1];
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (Line2D.ptSegDist(f2, f3, fArray[0], fArray[1], d2, d3) < 5.0) {
                return n;
            }
            ++n;
            pathIterator.next();
            f2 = fArray[0];
            f3 = fArray[1];
        }
        return 0;
    }

    public void calcUnionRect(Rectangle2D rectangle2D) {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        PathIterator pathIterator = this.path.getPathIterator(null);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(Util.FLOAT2);
            rectangle2D.add(Util.FLOAT2[0], Util.FLOAT2[1]);
            pathIterator.next();
        }
        int n = this.labelCount() - 1;
        while (n >= 0) {
            EdgeLabel edgeLabel = this.getLabel(n);
            if (edgeLabel.isVisible() && edgeLabel.getText().length() != 0) {
                YRectangle yRectangle = edgeLabel.getBox();
                double d2 = Math.min(yRectangle.getX(), rectangle2D.getX());
                double d3 = Math.max(yRectangle.getX() + yRectangle.getWidth(), rectangle2D.getX() + rectangle2D.getWidth());
                double d4 = Math.min(yRectangle.getY(), rectangle2D.getY());
                double d5 = Math.max(yRectangle.getY() + yRectangle.getHeight(), rectangle2D.getY() + rectangle2D.getHeight());
                rectangle2D.setFrame(d2, d4, d3 - d2, d5 - d4);
            }
            --n;
        }
        this.o.calcUnionRect(rectangle2D, this.getSourceRealizer());
        this.y.calcUnionRect(rectangle2D, this.getTargetRealizer());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        Point2D point2D;
        if (!this.isDirty() && this.j != null) {
            boolean bl = false;
            int n = this.labelCount() - 1;
            while (n >= 0) {
                EdgeLabel edgeLabel = this.getLabel(n);
                if (edgeLabel.isOffsetDirty() || edgeLabel.isSizeDirty()) {
                    bl = true;
                    break;
                }
                --n;
            }
            if (!bl) {
                return this.j.intersects(rectangle2D);
            }
            this.j = null;
        }
        if (this.bends.size() > 0) {
            ListCell listCell = this.bends.firstCell();
            while (listCell != null) {
                Bend bend = (Bend)listCell.getInfo();
                if (rectangle2D.contains(bend.getX(), bend.getY())) {
                    return true;
                }
                listCell = listCell.succ();
            }
        }
        if (rectangle2D.contains(point2D = this.getTargetIntersection())) {
            return true;
        }
        point2D = this.getSourceIntersection();
        if (rectangle2D.contains(point2D)) {
            return true;
        }
        this.j = new Rectangle2D.Double(point2D.getX(), point2D.getY(), 1.0, 1.0);
        this.calcUnionRect(this.j);
        return this.j.intersects(rectangle2D);
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(3);
        objectOutputStream.writeInt(this.bends.size());
        BendCursor bendCursor = this.bends();
        while (bendCursor.ok()) {
            objectOutputStream.writeFloat((float)bendCursor.bend().getX());
            objectOutputStream.writeFloat((float)bendCursor.bend().getY());
            bendCursor.next();
        }
        objectOutputStream.writeObject(this.getLineColor());
        objectOutputStream.writeByte(this.getArrow().getType());
        if (this.getArrow().getType() == 0) {
            objectOutputStream.writeObject(this.getArrow().getCustomName());
        }
        objectOutputStream.writeByte(this.getSourceArrow().getType());
        if (this.getSourceArrow().getType() == 0) {
            objectOutputStream.writeObject(this.getSourceArrow().getCustomName());
        }
        objectOutputStream.writeByte((byte)this.x.getLineWidth());
        objectOutputStream.writeByte(this.x.getLineStyle());
        objectOutputStream.writeObject(this.o.getClass().getName());
        this.o.write(objectOutputStream);
        objectOutputStream.writeObject(this.y.getClass().getName());
        this.y.write(objectOutputStream);
        objectOutputStream.writeInt(this.w.size());
        int n = 0;
        while (n < this.w.size()) {
            this.getLabel(n).write(objectOutputStream);
            ++n;
        }
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        switch (by) {
            case 0: {
                this.a(objectInputStream);
                break;
            }
            case 1: {
                this.b(objectInputStream);
                break;
            }
            case 2: {
                this.c(objectInputStream);
                break;
            }
            case 3: {
                int n = objectInputStream.readInt();
                int n2 = 0;
                while (n2 < n) {
                    this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
                    ++n2;
                }
                this.setLineColor((Color)objectInputStream.readObject());
                byte by2 = objectInputStream.readByte();
                if (by2 != 0) {
                    this.setArrow(Arrow.getArrow(by2));
                } else {
                    this.setArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
                }
                by2 = objectInputStream.readByte();
                if (by2 != 0) {
                    this.setSourceArrow(Arrow.getArrow(by2));
                } else {
                    this.setSourceArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
                }
                this.x = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
                try {
                    String string = (String)objectInputStream.readObject();
                    this.o = (Port)Class.forName(string).newInstance();
                    this.o.read(objectInputStream);
                    this.setSourcePort(this.o);
                    string = (String)objectInputStream.readObject();
                    this.y = (Port)Class.forName(string).newInstance();
                    this.y.read(objectInputStream);
                    this.setTargetPort(this.y);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
                int n3 = objectInputStream.readInt();
                int n4 = 0;
                while (n4 < n3) {
                    EdgeLabel edgeLabel = new EdgeLabel();
                    this.addLabel(edgeLabel);
                    edgeLabel.read(objectInputStream);
                    ++n4;
                }
                break;
            }
            default: {
                throw new BadVersionException(by);
            }
        }
    }

    void c(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
            ++n2;
        }
        int n3 = objectInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            EdgeLabel edgeLabel = new EdgeLabel();
            this.addLabel(edgeLabel);
            edgeLabel.read(objectInputStream);
            ++n4;
        }
        this.setLineColor((Color)objectInputStream.readObject());
        byte by = objectInputStream.readByte();
        if (by != 0) {
            this.setArrow(Arrow.getArrow(by));
        } else {
            this.setArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
        }
        by = objectInputStream.readByte();
        if (by != 0) {
            this.setSourceArrow(Arrow.getArrow(by));
        } else {
            this.setSourceArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
        }
        this.x = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            String string = (String)objectInputStream.readObject();
            this.o = (Port)Class.forName(string).newInstance();
            this.o.read(objectInputStream);
            this.setSourcePort(this.o);
            string = (String)objectInputStream.readObject();
            this.y = (Port)Class.forName(string).newInstance();
            this.y.read(objectInputStream);
            this.setTargetPort(this.y);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
    }

    void b(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
            ++n2;
        }
        int n3 = objectInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            EdgeLabel edgeLabel = new EdgeLabel();
            edgeLabel.read(objectInputStream);
            this.addLabel(edgeLabel);
            ++n4;
        }
        this.setLineColor((Color)objectInputStream.readObject());
        byte by = objectInputStream.readByte();
        if (by != 0) {
            this.setArrow(Arrow.getArrow(by));
        } else {
            this.setArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
        }
        by = objectInputStream.readByte();
        if (by != 0) {
            this.setSourceArrow(Arrow.getArrow(by));
        } else {
            this.setSourceArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
        }
        this.x = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            String string;
            if (objectInputStream.readBoolean()) {
                this.o = new Port();
            } else {
                string = (String)objectInputStream.readObject();
                if (string.startsWith("y.graph")) {
                    string = "y.view.Port";
                }
                this.o = (Port)Class.forName(string).newInstance();
                this.o.read(objectInputStream);
            }
            if (objectInputStream.readBoolean()) {
                this.y = new Port();
            } else {
                string = (String)objectInputStream.readObject();
                if (string.startsWith("y.graph")) {
                    string = "y.view.Port";
                }
                this.y = (Port)Class.forName(string).newInstance();
                this.y.read(objectInputStream);
            }
            this.setPorts(this.o, this.y);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
    }

    void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
            ++n2;
        }
        EdgeLabel edgeLabel = new EdgeLabel();
        edgeLabel.read(objectInputStream);
        this.addLabel(edgeLabel);
        this.setLineColor((Color)objectInputStream.readObject());
        byte by = objectInputStream.readByte();
        if (by != 0) {
            this.setArrow(Arrow.getArrow(by));
        } else {
            this.setArrow(Arrow.getCustomArrow((String)objectInputStream.readObject()));
        }
        this.x = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            String string;
            if (objectInputStream.readBoolean()) {
                this.o = new Port();
            } else {
                string = (String)objectInputStream.readObject();
                if (string.startsWith("y.graph")) {
                    string = "y.view.Port";
                }
                this.o = (Port)Class.forName(string).newInstance();
                this.o.read(objectInputStream);
            }
            if (objectInputStream.readBoolean()) {
                this.y = new Port();
            } else {
                string = (String)objectInputStream.readObject();
                if (string.startsWith("y.graph")) {
                    string = "y.view.Port";
                }
                this.y = (Port)Class.forName(string).newInstance();
                this.y.read(objectInputStream);
            }
            this.setPorts(this.o, this.y);
        }
        catch (IllegalAccessException illegalAccessException) {
            D.bug(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            D.bug(instantiationException);
        }
    }
}

