/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.element.TGroup;
import com.nepxion.cots.twaver.element.TLink;
import com.nepxion.cots.twaver.element.TNode;
import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TLabelConfigData;
import twaver.Element;
import twaver.Generator;

public class TLabelGenerator
implements Generator {
    private TGraph graph;
    private TLabelConfigData nodeLabelConfigData;
    private TLabelConfigData groupLabelConfigData;
    private TLabelConfigData linkLabelConfigData;

    public TLabelGenerator(TGraph graph) {
        this(graph, null, null, null);
    }

    public TLabelGenerator(TGraph graph, TLabelConfigData nodeLabelConfigData, TLabelConfigData groupLabelConfigData, TLabelConfigData linkLabelConfigData) {
        this.graph = graph;
        this.nodeLabelConfigData = nodeLabelConfigData;
        this.groupLabelConfigData = groupLabelConfigData;
        this.linkLabelConfigData = linkLabelConfigData;
        this.graph.setElementLabelGenerator(this);
    }

    public TLabelConfigData getNodeLabelConfigData() {
        return this.nodeLabelConfigData;
    }

    public TLabelConfigData getGroupLabelConfigData() {
        return this.groupLabelConfigData;
    }

    public TLabelConfigData getLinkLabelConfigData() {
        return this.linkLabelConfigData;
    }

    public Object generate(Object object) {
        if (object instanceof TNode) {
            return this.generateNodeLabel((TNode)object);
        }
        if (object instanceof TGroup) {
            return this.generateGroupLabel((TGroup)object);
        }
        if (object instanceof TLink) {
            return this.generateLinkLabel((TLink)object);
        }
        if (object instanceof Element) {
            return ((Element)object).getName();
        }
        return null;
    }

    public Object generateNodeLabel(TNode node) {
        if (this.nodeLabelConfigData == null) {
            return node.getName();
        }
        String key = this.nodeLabelConfigData.getKey();
        if (key != null) {
            if (key.equals("name")) {
                return node.getName();
            }
            return this.getServiceNodeLabel(node);
        }
        return "";
    }

    public Object getServiceNodeLabel(TNode node) {
        return "";
    }

    public Object generateGroupLabel(TGroup group) {
        if (this.groupLabelConfigData == null) {
            return group.getName();
        }
        String key = this.groupLabelConfigData.getKey();
        if (key != null) {
            if (key.equals("name")) {
                return group.getName();
            }
            return this.getServiceGroupLabel(group);
        }
        return "";
    }

    public Object getServiceGroupLabel(TGroup group) {
        return "";
    }

    public Object generateLinkLabel(TLink link) {
        if (this.linkLabelConfigData == null) {
            if (link.isBundleAgent()) {
                return "";
            }
            return link.getName();
        }
        String key = this.linkLabelConfigData.getKey();
        if (key != null) {
            if (link.isBundleAgent()) {
                return "";
            }
            if (key.equals("name")) {
                return link.getName();
            }
            return this.getServiceLinkLabel(link);
        }
        return "";
    }

    public Object getServiceLinkLabel(TLink link) {
        return "";
    }

    public TGraph getGraph() {
        return this.graph;
    }
}

