/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.border.BorderManager;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.renderer.list.RadioButtonListCellRenderer;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.util.data.CollectionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class TExportImageConfig
extends JPanel {
    private JList areaList;
    private JBasicTextField zoomTextField;
    private JBasicTextField marginTextField;
    private TGraph graph;

    public TExportImageConfig(TGraph graph) {
        this.graph = graph;
        ArrayList<ElementNode> areaElementNodes = new ArrayList<ElementNode>();
        areaElementNodes.add(new ElementNode(TLocale.getString("export_image_whole_area"), null, TLocale.getString("export_image_whole_area"), true));
        areaElementNodes.add(new ElementNode(TLocale.getString("export_image_suitable_area"), null, TLocale.getString("export_image_suitable_area"), false));
        this.areaList = new JList<Object>(CollectionUtil.parseArray(areaElementNodes));
        this.areaList.setCellRenderer(new RadioButtonListCellRenderer(this.areaList));
        double[][] size1 = new double[][]{{-1.0}, {100.0}};
        JPanel areaPanel = new JPanel();
        areaPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("export_image_area_setting")));
        areaPanel.setLayout((LayoutManager)new TableLayout((double[][])size1));
        areaPanel.add((Component)new JBasicScrollPane((Component)this.areaList), "0, 0");
        this.zoomTextField = new JBasicTextField();
        double[][] size2 = new double[][]{{0.3, 0.7}, {22.0}};
        JPanel zoomePanel = new JPanel();
        zoomePanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("export_image_zoom_setting")));
        zoomePanel.setLayout((LayoutManager)new TableLayout((double[][])size2));
        zoomePanel.add((Component)new JLabel(TLocale.getString("export_image_zoom")), "0, 0");
        zoomePanel.add((Component)this.zoomTextField, "1, 0");
        this.marginTextField = new JBasicTextField("0");
        double[][] size3 = new double[][]{{0.3, 0.7}, {22.0}};
        JPanel marginPanel = new JPanel();
        marginPanel.setBorder(BorderManager.createComplexTitledBorder((String)TLocale.getString("export_image_margin_setting")));
        marginPanel.setLayout((LayoutManager)new TableLayout((double[][])size3));
        marginPanel.add((Component)new JLabel(TLocale.getString("export_image_margin")), "0, 0");
        marginPanel.add((Component)this.marginTextField, "1, 0");
        this.setPreferredSize(new Dimension(220, this.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 1));
        this.add(areaPanel);
        this.add(zoomePanel);
        this.add(marginPanel);
    }

    public boolean isSaveWhole() {
        return this.isElementNodeSelected(0);
    }

    public boolean isSaveElement() {
        return this.isElementNodeSelected(1);
    }

    private boolean isElementNodeSelected(int index) {
        ListModel listModel = this.areaList.getModel();
        ElementNode elementNode = (ElementNode)listModel.getElementAt(index);
        return elementNode.isSelected();
    }

    public double getZoom() {
        try {
            return Double.parseDouble(this.zoomTextField.getText());
        }
        catch (NumberFormatException e) {
            return this.graph.getZoom();
        }
    }

    public void setZoom() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String zoomValue = numberFormat.format(this.graph.getZoom());
        this.zoomTextField.setText(zoomValue);
    }

    public int getMargin() {
        try {
            return Integer.parseInt(this.marginTextField.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

