/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.textfield.number;

import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.swing.textfield.number.NumberDocument;
import com.nepxion.swing.tip.balloon.JBalloonTip;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class JNumberTextField
extends JBasicTextField {
    public JNumberTextField() {
        this(Double.MIN_VALUE);
    }

    public JNumberTextField(double minimumValue) {
        this(minimumValue, Double.MAX_VALUE);
    }

    public JNumberTextField(int maximumLength, int decimalLength) {
        this(maximumLength, decimalLength, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public JNumberTextField(double minimumValue, double maximumValue) {
        this(16, 0, minimumValue, maximumValue);
    }

    public JNumberTextField(int maximumLength, int decimalLength, double minimumValue, double maximumValue) {
        this.setDocument(new NumberDocument(maximumLength, decimalLength, minimumValue, maximumValue){

            @Override
            public void insertString(int offset, String value, AttributeSet attributeSet) throws BadLocationException {
                boolean isExclude = JNumberTextField.this.exclude(value);
                if (isExclude) {
                    return;
                }
                try {
                    super.insertString(offset, value, attributeSet);
                }
                catch (NumberFormatException e) {
                    JNumberTextField.this.showTip(e.getMessage(), JBalloonTip.TIP_ICON_ERROR);
                }
                catch (IllegalArgumentException e) {
                    JNumberTextField.this.showTip(e.getMessage(), JBalloonTip.TIP_ICON_WARNING);
                }
            }
        });
    }

    public boolean exclude(String value) {
        return false;
    }
}

