/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.table.resizable;

import com.nepxion.swing.locale.SwingLocale;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class RowHeightResizer
extends MouseInputAdapter {
    private JTable table;
    private boolean active;
    private boolean rowSelectionAllowed;
    private int row;
    private int startY;
    private int startHeight;
    private static final int PIXELS = 5;
    private Cursor lastCursor;
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(9);
    private int minimumHeight = -1;
    private int maximumHeight = -1;

    public RowHeightResizer(JTable table) {
        this(table, -1, -1);
    }

    public RowHeightResizer(JTable table, int minimumHeight, int maximumHeight) {
        this.table = table;
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.row = -1;
        if (minimumHeight > maximumHeight) {
            throw new IllegalArgumentException(SwingLocale.getString("maximum_height_not_less_than_minimum_height"));
        }
        this.minimumHeight = minimumHeight;
        this.maximumHeight = maximumHeight;
    }

    public void done() {
        if (this.table == null) {
            return;
        }
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (this.isMouseOverRowMargin(p)) {
            if (this.lastCursor == null) {
                this.lastCursor = this.table.getCursor();
            }
            this.table.setCursor(resizeCursor);
        } else {
            this.table.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        if (this.isMouseOverRowMargin(p)) {
            this.active = true;
            this.startY = p.y;
            this.startHeight = this.table.getRowHeight(this.row);
            this.rowSelectionAllowed = this.table.getRowSelectionAllowed();
            this.table.setRowSelectionAllowed(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.active) {
            return;
        }
        int height = this.startHeight + e.getY() - this.startY;
        height = Math.max(1, height);
        this.table.setRowHeight(this.row, height);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.active) {
            return;
        }
        if (this.minimumHeight != -1 && this.maximumHeight != -1) {
            if (this.table.getRowHeight(this.row) < this.minimumHeight) {
                this.table.setRowHeight(this.row, this.minimumHeight);
            } else if (this.table.getRowHeight(this.row) > this.maximumHeight) {
                this.table.setRowHeight(this.row, this.maximumHeight);
            }
        }
        this.table.setRowSelectionAllowed(this.rowSelectionAllowed);
        this.active = false;
        this.row = -1;
    }

    private boolean isMouseOverRowMargin(Point p) {
        if (!this.table.isEnabled()) {
            return false;
        }
        this.row = this.table.rowAtPoint(p);
        int column = this.table.columnAtPoint(p);
        if (this.row == -1 || column == -1) {
            return false;
        }
        Rectangle r = this.table.getCellRect(this.row, column, true);
        return p.y >= r.y + r.height - 5;
    }
}

