/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.scrollpane;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.scrollpane.JCornerScrollPane;
import com.nepxion.swing.splitpane.DividerActionListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class JCornerSplitScrollPane
extends JCornerScrollPane {
    private JPanel horizontalToolBar;
    private JPanel verticalToolBar;
    private JBasicButton directLeftButton;
    private JBasicButton directRightButton;
    private JBasicButton directTopButton;
    private JBasicButton directBottomButton;

    public JCornerSplitScrollPane() {
        this.initComponents();
    }

    public JCornerSplitScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.initComponents();
    }

    public JCornerSplitScrollPane(Component view) {
        super(view);
        this.initComponents();
    }

    public JCornerSplitScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.initComponents();
    }

    private void initComponents() {
        this.directLeftButton = new JBasicButton(IconFactory.getSwingIcon("direction_west.png"), SwingLocale.getString("direct_left"));
        this.directRightButton = new JBasicButton(IconFactory.getSwingIcon("direction_east.png"), SwingLocale.getString("direct_right"));
        this.horizontalToolBar = new JPanel();
        this.horizontalToolBar.setLayout(new BoxLayout(this.horizontalToolBar, 0));
        this.horizontalToolBar.add(this.directLeftButton);
        this.horizontalToolBar.add(this.directRightButton);
        ButtonManager.updateUI((Container)this.horizontalToolBar, new Dimension(16, 16));
        this.directTopButton = new JBasicButton(IconFactory.getSwingIcon("direction_north.png"), SwingLocale.getString("direct_top"));
        this.directBottomButton = new JBasicButton(IconFactory.getSwingIcon("direction_south.png"), SwingLocale.getString("direct_bottom"));
        this.verticalToolBar = new JPanel();
        this.verticalToolBar.setLayout(new BoxLayout(this.verticalToolBar, 1));
        this.verticalToolBar.add(this.directTopButton);
        this.verticalToolBar.add(this.directBottomButton);
        ButtonManager.updateUI((Container)this.verticalToolBar, new Dimension(16, 16));
    }

    public void setHorizontalSplitPane(JSplitPane horizontalSplitPane) {
        int i;
        for (i = 0; i < this.directLeftButton.getActionListeners().length; ++i) {
            this.directLeftButton.removeActionListener(this.directLeftButton.getActionListeners()[i]);
        }
        this.directLeftButton.addActionListener(new DividerActionListener(horizontalSplitPane, true));
        for (i = 0; i < this.directRightButton.getActionListeners().length; ++i) {
            this.directRightButton.removeActionListener(this.directRightButton.getActionListeners()[i]);
        }
        this.directRightButton.addActionListener(new DividerActionListener(horizontalSplitPane, false));
    }

    public void setVerticalSplitPane(JSplitPane verticalSplitPane) {
        int i;
        for (i = 0; i < this.directTopButton.getActionListeners().length; ++i) {
            this.directTopButton.removeActionListener(this.directTopButton.getActionListeners()[i]);
        }
        this.directTopButton.addActionListener(new DividerActionListener(verticalSplitPane, true));
        for (i = 0; i < this.directBottomButton.getActionListeners().length; ++i) {
            this.directBottomButton.removeActionListener(this.directBottomButton.getActionListeners()[i]);
        }
        this.directBottomButton.addActionListener(new DividerActionListener(verticalSplitPane, false));
    }

    public void showHorizontalToolBar() {
        this.setHorizontalScrollBarPolicy(32);
        this.setScrollBarCorner("HORIZONTAL_LEADING", this.horizontalToolBar);
    }

    public void showVerticalToolBar() {
        this.setVerticalScrollBarPolicy(22);
        this.setScrollBarCorner("VERTICAL_BOTTOM", this.verticalToolBar);
    }

    public JPanel getHorizontalToolBar() {
        return this.horizontalToolBar;
    }

    public JPanel getVerticalToolBar() {
        return this.verticalToolBar;
    }
}

